<?php
/*
 * Plugin Name:		BuddhaThemes Core Features Plugin 
 * URI: 			http://wedesignthemes.com/plugins/buddhathemes-core-features 
 * Description: 	A simple wordpress plugin designed to implement <strong>core features of BuddhaThemes</strong> 
 * Version: 		1.5
 * Author: 			BuddhaThemes 
 * Author URI:		http://themeforest.net/user/buddhathemes
 */
  
if (! class_exists ( 'DTCorePlugin' )) {
	
	/**
	 * Basic class to load Shortcodes & Custom Posts
	 *
	 * @author iamdesigning11
	 */
	class DTCorePlugin {

		function __construct() {
			
			// Add Hook into the 'plugins_loaded()' action
			add_action ( 'plugins_loaded', array ( $this,'dtLoadPluginTextDomain') );

			// Register Shortcodes
			require_once plugin_dir_path ( __FILE__ ) . '/shortcodes/register-shortcodes.php';
			
			if (class_exists ( 'DTCoreShortcodes' )) {
				$dt_core_shortcodes = new DTCoreShortcodes();
			}
			
			// Register Custom Post Types
			require_once plugin_dir_path ( __FILE__ ) . '/custom-post-types/register-post-types.php';
			
			if (class_exists ( 'DTCoreCustomPostTypes' )) {
				$dt_core_custom_posts = new DTCoreCustomPostTypes();
			}
			
			// Register Page Builder
			require_once plugin_dir_path ( __FILE__ ) . '/page-builder/register-page-builder.php';
			
			if (class_exists ( 'DTCorePageBuilder' )) {
				$dt_core_page_builder = new DTCorePageBuilder ();
			}
			
			// To run shortcodes added in text widget
			add_filter( 'widget_text', 'do_shortcode' );
			
		}
				
		/**
		 * To load text domain
		 */
		function dtLoadPluginTextDomain() {
			load_plugin_textdomain ( 'dt_plugins', false, dirname ( plugin_basename ( __FILE__ ) ) . '/languages/' );
		}
		
		/**
		 */
		public static function dtCorePluginActivate() {
		}
		
		/**
		 */
		public static function dtCorePluginDectivate() {
		}
	}
}

if (class_exists ( 'DTCorePlugin' )) {
	
	register_activation_hook ( __FILE__, array (
			'DTCorePlugin',
			'dtCorePluginActivate' 
	) );
	register_deactivation_hook ( __FILE__, array (
			'DTCorePlugin',
			'dtCorePluginDectivate' 
	) );
	
	$dt_core_plugin = new DTCorePlugin ();
	
	if( !function_exists( 'dttheme_option' ) ){
		function dttheme_option($key1, $key2 = '') {
			$options = get_option ( 'painting-options' );
			$output = NULL;
		
			if (is_array ( $options )) {
		
				if (array_key_exists ( $key1, $options )) {
					$output = $options [$key1];
					if (is_array ( $output ) && ! empty ( $key2 )) {
						$output = (array_key_exists ( $key2, $output ) && (! empty ( $output [$key2] ))) ? $output [$key2] : NULL;
					}
				} else {
					$output = $output;
				}
			}
			return $output;
		}
	}

}
?>