<?php
if (! class_exists ( 'DTTemplatePostType' )) {
	class DTTemplatePostType {
		
		/**
		 */
		function __construct() {
			// Add Hook into the 'init()' action
			add_action ( 'init', array (
					$this,
					'dt_init' 
			) );
			
			// Add Hook into the 'admin_init()' action
			add_action ( 'admin_init', array (
					$this,
					'dt_admin_init' 
			) );
		}
		
		/**
		 * A function hook that the WordPress core launches at 'init' points
		 */
		function dt_init() {
			$this->createPostType ();
			add_action ( 'save_post', array (
					$this,
					'save_post_meta' 
			) );
			
			add_action ( 'pre_post_update', array (
					$this,
					'save_post_meta' 
			) );
		}
		
		/**
		 * A function hook that the WordPress core launches at 'admin_init' points
		 */
		function dt_admin_init() {
			wp_enqueue_script ( 'jquery-ui-sortable' );
			remove_filter( 'manage_posts_custom_column', 'likeThisDisplayPostLikes');
			remove_filter( 'manage_posts_columns', 'likeThisAddColumns');
			
			add_action ( 'add_meta_boxes', array (
					$this,
					'dt_add_template_meta_box' 
			) );
		}
		
		/**
		 */
		function createPostType() {
			
			$labels = array (
					'name' => esc_html__( 'Templates', 'dt_plugins' ),
					'all_items' => esc_html__( 'All Templates', 'dt_plugins' ),
					'singular_name' => esc_html__( 'Template', 'dt_plugins' ),
					'add_new' => esc_html__( 'Add New', 'dt_plugins' ),
					'add_new_item' => esc_html__( 'Add New Template', 'dt_plugins' ),
					'edit_item' => esc_html__( 'Edit Template', 'dt_plugins' ),
					'new_item' => esc_html__( 'New Template', 'dt_plugins' ),
					'view_item' => esc_html__( 'View Template', 'dt_plugins' ),
					'search_items' => esc_html__( 'Search Templates', 'dt_plugins' ),
					'not_found' => esc_html__( 'No templates found', 'dt_plugins' ),
					'not_found_in_trash' => esc_html__( 'No templates found in Trash', 'dt_plugins' ),
					'parent_item_colon' => esc_html__( 'Parent Template:', 'dt_plugins' ),
					'menu_name' => esc_html__( 'Templates', 'dt_plugins' ) 
			);
			
			$args = array (
					'labels' => $labels,
					'hierarchical' => false,
					'description' => 'This is custom post type templates',
					'supports' => array (
							'title',
					),
					
					'public' => true,
					'show_ui' => true,
					'show_in_menu' => true,
					'menu_position' => 6,
					'menu_icon' => 'dashicons-media-document',
					
					'show_in_nav_menus' => true,
					'publicly_queryable' => true,
					'exclude_from_search' => false,
					'has_archive' => true,
					'query_var' => true,
					'can_export' => true,
					'rewrite' => array( 'slug' => 'templates', 'hierarchical' => true, 'with_front' => false ),
					'capability_type' => 'page' 
			);
			
			register_post_type ( 'dt_templates', $args );
			
		}
		
		function dt_add_template_meta_box() {
			add_meta_box ( "dt-template-general-metabox", esc_html__( 'General Options', 'dt_plugins' ), array($this, 'dt_template_general_metabox'), 'dt_templates', "normal", "default" );
		}
		
		function dt_template_general_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_template_general_metabox.php';
		}
				
		function save_post_meta($post_id) {
			
			if ( ! isset( $_POST['dtcore_plugin_template_metabox_nonce'] ) || ! isset( $_POST['dtcore_plugin_template_metabox_nonce'] ) ) {
				return;
			}
		
			if ( ! wp_verify_nonce( $_POST['dtcore_plugin_template_metabox_nonce'], 'dtcore_plugin_template_metabox' ) || ! wp_verify_nonce( $_POST['dtcore_plugin_template_metabox_nonce'], 'dtcore_plugin_template_metabox' ) ) {
				return;
			}
		
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
		
			if ( isset( $_POST['post_type'] ) && 'dt_templates' == $_POST['post_type'] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}
			
			if ( (key_exists('post_type', $_POST)) && ('dt_templates' == $_POST['post_type']) ) :
			
				// General Settings
				$general_settings = array ();
				$general_settings['enable-general-settings'] = isset($_POST['dttheme-enable-general-settings']) ? $_POST ['dttheme-enable-general-settings'] : '';
				$general_settings['template-logo'] = isset($_POST['dttheme-template-logo']) ? painting_wp_kses($_POST ['dttheme-template-logo']) : '';
				$general_settings['template-retina-logo'] = isset($_POST['dttheme-template-retina-logo']) ? painting_wp_kses($_POST ['dttheme-template-retina-logo']) : '';
				$general_settings['template-retina-logo-width'] = isset($_POST['dttheme-template-retina-logo-width']) ? painting_wp_kses($_POST ['dttheme-template-retina-logo-width']) : '';
				$general_settings['template-retina-logo-height'] = isset($_POST['dttheme-template-retina-logo-height']) ? painting_wp_kses($_POST ['dttheme-template-retina-logo-height']) : '';
				$general_settings['header-type'] = isset($_POST['dttheme-header-type']) ? $_POST ['dttheme-header-type'] : '';
				$general_settings['header-leftcontent'] = isset($_POST['dttheme-header-leftcontent']) ? $_POST ['dttheme-header-leftcontent'] : '';
				$general_settings['header-rightcontent'] = isset($_POST['dttheme-header-rightcontent']) ? $_POST ['dttheme-header-rightcontent'] : '';
				$general_settings['enable-topbar'] = isset($_POST['dttheme-enable-topbar']) ? $_POST ['dttheme-enable-topbar'] : '';
				
				update_post_meta($post_id, "_template_general_settings", array_filter($general_settings));
				
			endif;
				
		}
		
	}
}
?>