var dtMetabox = {
	dtInit : function() {
		dtMetabox.dtLayoutSelect();
		dtMetabox.dtCustomSwitch();
		dtMetabox.dtImageUploader();
		dtMetabox.dtImageHolder();
		dtMetabox.dtAddVideo();
		dtMetabox.dtToggleContent();
	},

	dtLayoutSelect : function() {
		jQuery(".dtPortfolio.dt-bpanel-layout-set").each(function() {
			jQuery(this).find("a").on("click", function(e) {

				var $parent = jQuery(this).parents(".dt-bpanel-layout-set");
				var $input = $parent.next(":input");

				if (jQuery(this).hasClass("selected")) {
					jQuery(this).removeClass("selected");
					$input.val("");
				} else {
					$parent.find("a.selected").removeClass("selected");
					$input.val(jQuery(this).attr("rel"));
					jQuery(this).addClass("selected");
				}

				e.preventDefault();
			});
		});
	},

	dtCustomSwitch : function() {
		jQuery("div.dt-checkbox-switch").each(function() {
			jQuery(this).on("click", function() {
				
				var $ele = '#' + jQuery(this).attr("data-for");

				jQuery(this).toggleClass('checkbox-switch-off checkbox-switch-on');

				if (jQuery(this).hasClass('checkbox-switch-on')) {
					jQuery($ele).attr("checked", "checked");
				} else {
					jQuery($ele).removeAttr("checked");
				}
				
				if(jQuery($ele).hasClass('dt-toggle-content')) jQuery($ele).trigger('click');
				
			});
		});
	},
	
	dtImageUploader: function(){
		var file_frame = "";
		jQuery(".dt-open-media").live('click',function(e){
			e.preventDefault();
			
			// If the media frame already exists, reopen it.
		    if ( file_frame ) {
		      file_frame.open();
		      return;
		    }
		    
		    file_frame = wp.media.frames.file_frame = wp.media({
		    	multiple: true,
		    	title : "Upload / Select Media",
		    	button :{
		    		text : "Insert Image"
		    	}
		    });
		    
		    // When an image is selected, run a callback.
		    file_frame.on( 'select', function() {
		    	// We set multiple to false so only get one image from the uploader
		        var attachments = file_frame.state().get('selection').toJSON();
		        var  holder = "";
		        jQuery.each( attachments,function(key,value){
					var full = value.sizes.full.url;
					var name = value.name;
					var id = value.id;
					var thumbnail = "";
										 
					if(jQuery.type(value.sizes.thumbnail) != "undefined") {
					   thumbnail =  value.sizes.thumbnail.url;
					} else {
					   thumbnail =  full;
					}
					 
		        	 holder += "<li>" +
		        	 		"<img src='"+thumbnail+"'  alt=''/>" +
		        	 		"<span class='dt-image-name' >"+name+"</span>" +
		        	 		"<input type='hidden' class='dt-image-name' name='items_name[]' value='"+name+"' />" +
		        	 		"<input type='hidden' name='items[]' value='"+full+"' />" +
		        	 		"<input type='hidden' name='items_thumbnail[]' value='"+thumbnail+"' />" +
							"<input type='hidden' name='items_id[]' value='"+id+"' />" +
		        	 		"<span class='my_delete'></span>" +
		        	 		"</li>";
		        });
		        
		        jQuery("ul.dt-items-holder").append(holder);
		        
		    });
		    
		    // Finally, open the modal
		    file_frame.open();
		});
	},
	
	dtImageHolder: function() {
		
		jQuery('ul.dt-items-holder').sortable({
			placeholder: 'sortable-placeholder',
			forcePlaceholderSize: true,
			cancel: '.my_delete, input, textarea, label'
		});
		
		jQuery('body').delegate('span.my_delete','click', function(){
			jQuery(this).parent('li').remove();
		});
		
	},
	
	dtAddVideo : function() {
		
		jQuery(".dt-add-video").on("click", function(e){
			var $video_id = parseInt(jQuery(this).parent().find('#dt-video-id').val())+1;
			jQuery(this).parent().find('#dt-video-id').val($video_id);
			var $video =  "<li>" +
					"<span class='dt-video'></span>" +
					"<input type='text' name='items[]' value='https://vimeo.com/46926279'/>" +
					"<input type='hidden' class='dt-image-name' name='items_name[]' value='video' />" +
					"<input type='hidden' name='items_thumbnail[]' value='https://vimeo.com/46926279' />" +
					"<input type='hidden' name='items_id[]' value='"+$video_id+"' />" +
					"<span class='my_delete'></span>" +
					"</li>";
			jQuery('ul.dt-items-holder').append($video);
			e.preventDefault();
		});
		
	},
	
	dtToggleContent : function() {
		
		jQuery('.dt-toggle-content').on("click", function(e){
			jQuery('.footer-options').slideUp();
			if(jQuery(this).attr('checked') == 'checked') jQuery('#dt-footer-shortcode').slideDown();
			else jQuery('#dt-footer-column').slideDown();
			e.preventDefault();
		});
		
	},
		
};

jQuery(document).ready(function() {

	dtMetabox.dtInit();
	
});