<?php 
get_header();
$portfolio_settings = get_post_meta ( $post->ID, '_portfolio_settings', TRUE );
$portfolio_settings = is_array ( $portfolio_settings ) ? $portfolio_settings : array ();

$layout = isset( $portfolio_settings['layout'] ) ? $portfolio_settings['layout'] : 'single-portfloio-layout-one';
$container_start =  $container_middle =  $container_end = "";

if( $layout === "single-portfloio-layout-two" ) {
  $container_start	 =	'<div class="column dt-sc-two-third first">';
  $container_middle	 =	'</div>';
  $container_middle .=	'<div class="column dt-sc-one-third">'; 
  $container_end	 =	'</div>';
}elseif( $layout === "single-portfloio-layout-three" ){
  $container_start	 =	'<div class="column dt-sc-two-third right-gallery">';
  $container_middle	 =	'</div>';
  $container_middle .=	'<div class="column dt-sc-one-third first">'; 
  $container_end	 =	'</div>';
}elseif( $layout === "single-portfloio-layout-one" ) {
  $container_start	 =	'<div class="column dt-sc-one-column first">';
  $container_middle	 =	'</div>';
  $container_middle .=	'<div class="dt-sc-margin30"></div>'; 
}
?>
<!-- **Primary Section** -->
<section id="primary" class="content-full-width">

	<?php
    if( have_posts() ):
		while( have_posts() ):
			the_post();
			?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('gallery-single'); ?>>
            
            	<?php echo painting_wp_kses($container_start); ?>
                
                    <div class="recent-gallery-container">
                        <ul class="recent-gallery">
                        
							<?php
                            if( array_key_exists("items_name",$portfolio_settings) ) {
                                foreach( $portfolio_settings["items_name"] as $key => $item ){
                                    $current_item = $portfolio_settings["items"][$key];
                                    if( "video" === $item ) {
                                        echo '<li><div class="dt-video-wrap">'.wp_oembed_get( $current_item ).'</div></li>';
                                    } else {
										if(isset($portfolio_settings['items_id'][$key])) {
											$attachment_id = $portfolio_settings['items_id'][$key];
											$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
											echo '<li><img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
										}
                                    }
                                }
                            } else {
                                echo '<li><img src="http'.painting_ssl().'://placehold.it/1200x800&text='.get_the_title().'"  alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
                            }
							?>
                    
                        </ul>
                    </div>
                    
               <?php echo painting_wp_kses($container_middle); ?>    
               
				   <?php if($layout === 'single-portfloio-layout-one') echo '<div class="column dt-sc-two-third first">'; ?>
                   
					<?php if( array_key_exists("sub-title",$portfolio_settings) ) echo '<h3>'.esc_html($portfolio_settings["sub-title"]).'</h3>'; ?>                    
                    <?php the_content(); ?>
                    <div class="dt-sc-hr-invisible-very-small"></div>  
                    
				   <?php if($layout === 'single-portfloio-layout-one') echo '</div><div class="column dt-sc-one-third">'; ?> 
                      
                        <div class="project-details">
                            <h6><?php echo esc_html__('Details', 'dt_plugins'); ?></h6>
                            <ul class="client-details">
                                <li>
                                    <p><i class="fa fa-calendar-o"></i><span><?php echo esc_html__('Date : ', 'dt_plugins'); ?></span> <?php the_date("d M Y");?></p>
                                </li>
                                <li>
                                    <p><i class="fa fa-globe"></i><span><?php echo esc_html__('Author : ', 'dt_plugins'); ?></span> <a href="<?php echo get_author_posts_url(get_the_author_meta('ID'));?>" title="<?php esc_html_e('View all posts by ', 'dt_plugins').get_the_author();?>"><?php echo get_the_author();?></a></p>
                                </li>
                                <?php the_terms($id,'portfolio_entries','<li><p><i class="fa fa-tags"></i><span>'.esc_html__('Category : ','dt_plugins').'</span>',', ','</p></li>'); ?>
                                <?php
                                $custom_fields_icon = dttheme_option("pageoptions","portfolio-custom-fields-icon");
                                $custom_fields_link = dttheme_option("pageoptions","portfolio-custom-fields-link");
                                $custom_fields = dttheme_option("pageoptions","portfolio-custom-fields");
                                $custom_fields = is_array($custom_fields) ? array_filter($custom_fields) : array();
                                $custom_fields = array_unique( $custom_fields);
                                foreach( $custom_fields as $key => $field ){ 
                                    $field_id = str_replace(' ', '-', strtolower(trim($field)));
                                    if(isset($portfolio_settings[$field_id])) {
										$icon = $custom_fields_icon[$key];
                                        ?>
                                        <li>
                                            <p>
                                                <i class="fa <?php echo esc_attr($icon);?>"></i>
                                                <span><?php esc_html_e($field,'dt_plugins');?></span> 
                                                <?php if($custom_fields_link[$key] == 'link') { ?> <a target="_blank" href="<?php echo esc_url($custom_fields_icon[$key]); ?>"><?php } ?>
                                                    <?php echo esc_html($portfolio_settings[$field_id]);?>
                                                <?php if($custom_fields_link[$key] == 'link') { ?> </a> <?php } ?>
                                            </p>
                                        </li>
                                        <?php
                                    }
                                }
                                ?>
                            </ul>
                            <?php if(isset($portfolio_settings["show-social-share"])) { ?>
                                <div class="dt-sc-hr-invisible-small"></div>
                                <h6><?php echo esc_html__('Share this Project', 'dt_plugins'); ?></h6>
                                <ul class="dt-sc-social-icons">
                                     <?php 
                                     $sstitle = get_the_title();
                                     $ssurl = get_permalink();
                                     if(isset($portfolio_settings["socialshare-facebook"])) echo '<li class="facebook"> <a href="//www.facebook.com/sharer.php?u='.$ssurl.'&amp;t='.urlencode($sstitle).'" title="facebook" target="_blank"> <span class="fa fa-facebook"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-delicious"])) echo '<li class="delicious"> <a href="//del.icio.us/post?url='.$ssurl.'&amp;title='.urlencode($sstitle).'" title="delicious" target="_blank"> <span class="fa fa-delicious"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-digg"])) echo '<li class="digg"> <a href="//digg.com/submit?phase=2&amp;url='.$ssurl.'&amp;title='.urlencode($sstitle).'" title="digg" target="_blank"> <span class="fa fa-digg"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-stumbleupon"])) echo '<li class="stumbleupon"> <a href="//www.stumbleupon.com/submit?url='.$ssurl.'&amp;title='.urlencode($sstitle).'" title="stumbleupon" target="_blank"> <span class="fa fa-stumbleupon"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-twitter"])) echo '<li class="twitter"> <a href="//twitter.com/home/?status='.$ssurl.':'.urlencode($sstitle).'" title="twitter" target="_blank"> <span class="fa fa-twitter"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-googleplus"])) echo '<li class="googleplus"> <a href="//plus.google.com/share?url='.$ssurl.'" title="googleplus" target="_blank" onclick="javascript:window.open(this.href,\"\",\"menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600\");return false;"> <span class="fa fa-google-plus"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-linkedin"])) echo '<li class="linkedin"> <a href="//www.linkedin.com/shareArticle?mini=true&amp;title='.urlencode($sstitle).'&amp;url='.$ssurl.'" title="linkedin" target="_blank"> <span class="fa fa-linkedin"></span>  </a> </li>';
                                     if(isset($portfolio_settings["socialshare-pinterest"])) { 
                                        $media = isset($portfolio_settings['items'][0]) ? $portfolio_settings['items'][0] : ''; 
                                        echo '<li class="pinterest"> <a href="//pinterest.com/pin/create/button/?url='.$ssurl.'&amp;media='.$media.'" title="pinterest" target="_blank"> <span class="fa fa-pinterest"></span>  </a> </li>'; 
                                    }
                                     
                                    ?>
                                </ul>
                            <?php } ?>
                        </div>
                        
                    <?php if($layout === 'single-portfloio-layout-one') echo '</div>'; ?>  
                    
                <?php echo painting_wp_kses($container_end); ?>
                
                <div class="dt-sc-margin50"></div> 
                <?php if(dttheme_option("pageoptions","single-portfolio-comments") == 'true') { comments_template('', true); echo '<div class="dt-sc-margin50"></div>'; } ?>
                <div class="post-nav-container">
                	<div class="post-prev-link"><?php previous_post_link('%link','<i class="fa fa-angle-left"></i>%title');?></div>
                    <div class="post-next-link"><?php next_post_link('%link','%title<i class="fa fa-angle-right"></i>');?></div>
                </div>
                
         </article>    
		<?php  
		endwhile;
	endif;
	?>
    
    <?php if(dttheme_option("pageoptions","single-portfolio-related") == 'true') { ?>
    	<div class="dt-sc-clear"></div> 
    	<div class="dt-sc-hr-invisible"></div> 
        <div class="recent-portfolio">
            <div class="hr-title">
                <h3><?php esc_html_e('Related Portfolio','dt_plugins');?></h3>
                <div class="title-sep-container"><div class="title-sep"> </div></div>
            </div>
            <div class="portfolio-carousel-wrapper">
                <div class="portfolio-carousel">
                
					<?php 
                    $category_ids = array();
                    
                    $input  = wp_get_object_terms( $post->ID, 'portfolio_entries');
                    
                    foreach($input as $category) $category_ids[] = $category->term_id;
                    
                    $args = array('orderby' => 'rand', 'showposts' => '-1', 'post__not_in' => array($post->ID), 'tax_query' => array( array( 'taxonomy'=>'portfolio_entries', 'field'=>'id', 'operator'=>'IN', 'terms'=>$category_ids )));
                    
                    $the_query = new WP_Query($args);
                    if($the_query->have_posts()):
						while($the_query->have_posts()): 
							$the_query->the_post();
							$the_id = get_the_ID();
							
							$portfolio_item_meta = get_post_meta($the_id,'_portfolio_settings',TRUE);
							$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();
							
							 $hover_color = array_key_exists('hover-color', $portfolio_item_meta) ? $portfolio_item_meta['hover-color'] : '';
							 $hover_style = '';
							 
							 if($hover_color != '') {
								 
								$hover_color_opacity = array_key_exists('hover-color-opacity', $portfolio_item_meta) ? $portfolio_item_meta['hover-color-opacity'] : '';
								
								$rgb = painting_hex2rgb($hover_color); 
								$hover_style = 'style="background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$hover_color_opacity.');"';
								
							 }
							
							?>
                            <div class="portfolio dt-sc-one-third no-space column">
                                <figure>
                                    <?php 
                                    $popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title();
                                    if( array_key_exists('items_name', $portfolio_item_meta) ) {
                                        $item =  $portfolio_item_meta['items_name'][0];
                                        $popup = $portfolio_item_meta['items'][0];
                                        if( "video" === $item ) {
                                            $items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
                                            if( !empty($items) ) {
                                                echo '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';	
                                            } else {
                                                echo '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title().'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                                            }
                                        } else {
                                            $attachment_id = $portfolio_item_meta['items_id'][0];
                                            $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
                                            echo '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                                        }
                                        
                                    } else {
                                        echo '<img src="'.esc_attr($popup).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                                    }
                                    ?>
                                    <figcaption <?php echo esc_attr($hover_style); ?>>
                                        <div class="fig-content-wrapper">
                                            <div class="fig-content">
                                                <h5><a href="<?php the_permalink();?>"><?php echo get_the_title(); ?></a></h5>
                                                <?php echo get_the_term_list($post->ID, 'portfolio_entries', '<p>', ', ', '</p>'); ?>     
                                                <div class="fig-overlay">
                                                    <a class="zoom" href="<?php echo esc_url($popup);?>" data-gal="prettyPhoto[gallery]" title="<?php echo get_the_title(); ?>"> <span class="fa fa-plus"> </span> </a>
                                                    <a class="link" href="<?php the_permalink();?>" title="<?php echo get_the_title(); ?>"> <span class="fa fa-link"> </span> </a>
                                                </div>
                                            </div>
                                        </div>  
                                    </figcaption>
                                </figure>             
                            </div>
							<?php 			
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    
                 </div>
                 <div class="product-carousel">
                    <a class="portfolio-prev" href="#"><span class="fa fa-angle-left"></span></a>
                    <a class="portfolio-next" href="#"><span class="fa fa-angle-right"></span></a>
                 </div>
             </div>
        </div>
    <?php } ?>
    <div class="dt-sc-margin80"></div>
            
</section><!-- **Primary Section** -->
<?php get_footer();?>