<?php
/*
 * Plugin Name:		BuddhaThemes Appointment Addon
 * URI: 			http://wedesignthemes.com/plugins/buddhathemes-appointment-addon
 * Description: 	A simple wordpress plugin designed to implement <strong>appointment (reservation) features</strong> 
 * Version: 		1.5
 * Author: 			BuddhaThemes 
 * Author URI:		http://themeforest.net/user/buddhathemes
 */
  
if (! class_exists ( 'DTAppointmentAddon' )) {
	
	/**
	 * Basic class to load Appointment Custom Posts
	 *
	 * @author iamdesigning
	 */
	class DTAppointmentAddon {

		function __construct() {
			
			// Add Hook into the 'plugins_loaded()' action
			add_action ( 'plugins_loaded', array ( $this,'dtLoadPluginTextDomain') );
			
			// Add Hook into the 'admin_init()' action
			add_action ( 'admin_init', array ( $this, 'dtAppointmentAdminScripts') );
			
			// Add Hook into the 'wp_enqueue_scripts()' action
			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtAppointmentScripts') );
			
			// Register Staff Custom Post
			require_once plugin_dir_path ( __FILE__ ) . '/dt-staff-post-type.php';
			if( class_exists('DTStaffPostType') ){
				$dt_staff_post_type = new DTStaffPostType();
			}

			// Register Services Custom Post
			require_once plugin_dir_path ( __FILE__ ) . '/dt-service-post-type.php';
			if( class_exists('DTServicePostType') ){
				$dt_service_post_type = new DTServicePostType();
			}

			// Register Customers Custom Post
			require_once plugin_dir_path ( __FILE__ ) . '/dt-customer-post-type.php';
			if( class_exists('DTCustomerPostType') ){
				$dt_customer_post_type = new DTCustomerPostType();
			}

			//Register Calender Menu
			require_once plugin_dir_path ( __FILE__ ) . '/dt-calender-menu.php';
			if( class_exists('DTCalenderMenu')) {
				$dt_calender_menu = new DTCalenderMenu();
			}

			require_once plugin_dir_path ( __FILE__ ) . 'functions.php';
									
		}
			
		/**
		 * To load text domain
		 */
		function dtLoadPluginTextDomain() {
			load_plugin_textdomain ( 'dt_plugins_appointment', false, dirname ( plugin_basename ( __FILE__ ) ) . '/languages/' );
		}
			
		/**
		 * To load admin script files
		 */
		function dtAppointmentAdminScripts() {
			wp_enqueue_script('dt-appointment-admin-script', plugin_dir_url ( __FILE__ ) . 'js/dt.admin.js', array (), false, true);
		}
			
		/**
		 * To load css and script files
		 */
		function dtAppointmentScripts() {
			wp_enqueue_style('dt-appointment', plugin_dir_url ( __FILE__ ) . 'css/styles.css' );
			wp_enqueue_script ( 'dt-sc-datepicker', plugin_dir_url ( __FILE__ ) . 'js/datepicker.js', array(), false, true);
			wp_enqueue_script('dt-appointment-public-script', plugin_dir_url ( __FILE__ ) . 'js/dt.public.js', array (), false, true);
			wp_localize_script('dt-appointment-public-script', 'dtAppointmentCustom', array(
				'plugin_url' => plugin_dir_url ( __FILE__ ),
				'erAboutYourProject' => esc_html__('Please tell us about your project!','dt_plugins_appointment'),
				));
		}
				
		/**
		 */
		public static function dtAppointmentAddonActivate() {
			//Shell script file for agenda
			$sh = plugin_dir_path( __FILE__ ).'cron/send_agenda_cron.sh';
			$php = plugin_dir_path( __FILE__ ).'cron/send_agenda_cron.php';

			$sh_content = file_get_contents($sh);

			if ( preg_match( '/doc_root/', $sh_content ) ) {
                $sh_content = preg_replace( '/doc_root/', $_SERVER[ 'DOCUMENT_ROOT' ], $sh_content );
            }
            if ( preg_match( '/full_path/', $sh_content ) ) {
                $sh_content = preg_replace( '/full_path/', $php, $sh_content );
            }
            file_put_contents( $sh, $sh_content );
		}
		
		/**
		 */
		public static function dtAppointmentAddonDectivate() {
			$sh = plugin_dir_path( __FILE__ ).'cron/send_agenda_cron.sh';
			file_put_contents( $sh, "#!/bin/sh\ncd doc_root\nphp -f full_path" );
		}
	}
}

if (class_exists ( 'DTAppointmentAddon' )) {
	
	register_activation_hook ( __FILE__, array (
			'DTAppointmentAddon',
			'dtAppointmentAddonActivate' 
	) );
	register_deactivation_hook ( __FILE__, array (
			'DTAppointmentAddon',
			'dtAppointmentAddonDectivate' 
	) );
	
	$dt_property_addon = new DTAppointmentAddon ();
}

?>