<?php
if ( !class_exists( 'DTServicePostType' ) ) {

	class DTServicePostType {
		function __construct() {
			add_action ( 'init', array (
				$this,
				'dt_init'
			) );

			add_action( 'admin_init', array(
				$this,
				'dt_admin_init'
			) );
		}

		function dt_init() {
			$labels = array(
				'name' => esc_html__('Services', 'dt_plugins_appointment' ),
				'singular_name' => esc_html__('Service', 'dt_plugins_appointment' ),
				'menu_name' => esc_html__('Services', 'dt_plugins_appointment' ),
				'add_new' => esc_html__('Add Service', 'dt_plugins_appointment' ),
				'add_new_item' => esc_html__('Add New Service', 'dt_plugins_appointment' ),
				'edit' => esc_html__('Edit Service', 'dt_plugins_appointment' ),
				'edit_item' => esc_html__('Edit Service', 'dt_plugins_appointment' ),
				'new_item' => esc_html__('New Service', 'dt_plugins_appointment' ),
				'view' => esc_html__('View Service', 'dt_plugins_appointment' ),
				'view_item' => esc_html__('View Service', 'dt_plugins_appointment' ),
				'search_items' => esc_html__('Search Services', 'dt_plugins_appointment' ),
				'not_found' => esc_html__('No Services found', 'dt_plugins_appointment' ),
				'not_found_in_trash' => esc_html__('No Services found in Trash', 'dt_plugins_appointment' ),
				'parent_item_colon' => esc_html__('Parent Service:', 'dt_plugins_appointment' ),
			);

			$args = array(
				'labels' => $labels,
				'hierarchical' => false,
				'description' => esc_html__('This is Custom Post type named as Services','dt_plugins_appointment'),
				'supports' => array('title', 'editor', 'thumbnail'),
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'menu_position' => 30,
				'menu_icon' => 'dashicons-awards',
			);

			register_post_type('dt_services', $args );
		}

		function dt_admin_init() {

			add_action ( 'add_meta_boxes', array (
				$this,
				'dt_add_service_meta_box' 
			) );

			add_action ( 'save_post', array (
				$this,
				'save_service_post_meta' 
			) );
			
			add_action ( 'pre_post_update', array (
				$this,
				'save_service_post_meta' 
			) );

			add_filter ( "manage_edit-dt_services_columns", array(
				$this,
				"dt_services_edit_columns"
			) );

			add_action ( "manage_posts_custom_column", array (
				$this,
				"dt_services_columns_display" 
			), 10, 2 );

		}

		function dt_services_edit_columns( $columns ) {

			$newcolumns = array (
					"cb" => "<input type=\"checkbox\" />",
					"title" => esc_html__("Title",'dt_plugins_appointment'),
					"details" => esc_html__("Details",'dt_plugins_appointment'),
					"author" => esc_html__("Author",'dt_plugins_appointment'),
			);
			$columns = array_merge ( $newcolumns, $columns );
			return $columns;
		}

		function dt_services_columns_display( $columns, $id ) {
			global $post;
			switch ($columns) {
				case 'details':
					$info = get_post_meta( $post->ID, "_info", true );
					$info = is_array( $info ) ? $info : array();

					$duration = array_key_exists('duration', $info) ? $info['duration'] : "";
					$duration = !empty($duration) ?'<p>'. esc_html__("Duration",'dt_plugins_appointment').' - '.painting_durationtostring($duration).'</p>' : "";
					echo painting_wp_kses($duration);
				break;
			}
		}

		function dt_add_service_meta_box() {
			add_meta_box( 'dt-services-metabox', esc_html__('Set Default Options', 'dt_plugins_appointment'), array( $this, 'dt_services_metabox'), 'dt_services', "normal","default");
		}

		function dt_services_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_services_metabox.php';
		}

		function save_service_post_meta( $id ) {

			if ( ! isset( $_POST['dtappointment_addon_services_metabox_nonce'] ) || ! isset( $_POST['dtappointment_addon_services_metabox_nonce'] ) ) {
				return;
			}
		
			if ( ! wp_verify_nonce( $_POST['dtappointment_addon_services_metabox_nonce'], 'dtappointment_addon_services_metabox' ) || ! wp_verify_nonce( $_POST['dtappointment_addon_services_metabox_nonce'], 'dtappointment_addon_services_metabox' ) ) {
				return;
			}
		
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
		
			if ( isset( $_POST['post_type'] ) && 'dt_services' == $_POST['post_type'] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			if ( (key_exists('post_type', $_POST)) && ('dt_services' == $_POST['post_type']) ) :
			
				if ( isset($_POST['_info']) ):
					$info = painting_wp_kses(array_unique(array_filter($_POST['_info'])));
					update_post_meta ( $id, "_info", array_filter ( $info ) );
				endif;
			
			endif;
			
		}

	}
}?>
