<div class="wrap">
	<h2><?php esc_html_e('Calender','dt_plugins_appointment');?></h2>
	<span><?php esc_html_e('Appointment System','dt_plugins_appointment');?></span>

	<div id="dt-calendar-wrapper"><?php
		$cp_members = get_posts( array('post_type'=>'dt_staffs','posts_per_page'=>'-1', 'orderby'=>'title' , 'order'=>'asc' ) );

		if( $cp_members ){ ?>
			<ul id="dt-members-list"><?php
				foreach( $cp_members as $i => $cp_member ) {
					$id = $cp_member->ID; 
					$name = $cp_member->post_title;
					$class = ( $i == 0 ) ? 'active' : '';?>
					<li><a href="#" data-memberid="<?php echo esc_attr($id); ?>" class="<?php echo esc_attr($class); ?>"><?php echo esc_html($name); ?></a></li><?php
				}?>
			</ul><?php
		}?>

		<!-- Calender -->
		<div class="dt-calendar">
		</div><!-- Calender End -->

		<!-- Event Add Form -->
		<div id="event_edit_container">
			<form>
				<input type="hidden" name="member_id" />
				<ul>
					<li>
						<span><?php esc_html_e('Date','dt_plugins_appointment');?></span>
						<span class="date_holder"></span>
					</li>

					<li>
						<label for="start"><?php esc_html_e('Start Time','dt_plugins_appointment');?></label>
						<select name="start">
							<option value=""><?php esc_html_e('Select Start Time','dt_plugins_appointment');?></option>
						</select>
					</li>

					<li>
						<label for="end"><?php esc_html_e('End Time','dt_plugins_appointment');?></label>
						<select name="end">
							<option value=""><?php esc_html_e('Select End Time','dt_plugins_appointment');?></option>
						</select>
					</li>

					<li>
						<label for="services"><?php esc_html_e('Service','dt_plugins_appointment');?></label>
						<select name="service"></select>
					</li>

					<li>
						<label for="customer"><?php esc_html_e('Customer','dt_plugins_appointment');?></label>
						<select name="customer">
							<option value=""><?php esc_html_e('Select','dt_plugins_appointment');?></option><?php
							$cp_customers = get_posts(array('post_type'=>'dt_customers','posts_per_page'=>'-1','orderby'=>'title','order'=>'asc'));
							if( $cp_customers ) {
								foreach( $cp_customers as $i => $cp_customer ) {
									$id = $cp_customer->ID; 
									$name = $cp_customer->post_title;
									echo "<option value='{$id}'>{$name}</option>";
								}
							}?></select>
					</li>

					<li>
						<label for="title"><?php esc_html_e('Title','dt_plugins_appointment');?></label>
						<input type="text" name="title" />
					</li>

					<li>
						<label for="body"><?php esc_html_e('Body','dt_plugins_appointment');?></label>
						<textarea name="body"></textarea>
					</li>
				</ul>
			</form>
		</div><!-- Event Add Form End -->
	</div>
</div>