<?php
if (! class_exists ( 'DTPortfolioPostType' )) {
	class DTPortfolioPostType {
		
		/**
		 */
		function __construct() {
			// Add Hook into the 'init()' action
			add_action ( 'init', array (
					$this,
					'dt_init' 
			) );
			
			// Add Hook into the 'admin_init()' action
			add_action ( 'admin_init', array (
					$this,
					'dt_admin_init' 
			) );
			
			add_filter ( 'template_include', array (
					$this,
					'dt_template_include' 
			) );
		}
		
		/**
		 * A function hook that the WordPress core launches at 'init' points
		 */
		function dt_init() {
			$this->createPostType ();
			add_action ( 'save_post', array (
					$this,
					'save_post_meta' 
			) );
			
			add_action ( 'pre_post_update', array (
					$this,
					'save_post_meta' 
			) );
		}
		
		/**
		 * A function hook that the WordPress core launches at 'admin_init' points
		 */
		function dt_admin_init() {
			wp_enqueue_script ( 'jquery-ui-sortable' );
			remove_filter( 'manage_posts_custom_column', 'likeThisDisplayPostLikes');
			remove_filter( 'manage_posts_columns', 'likeThisAddColumns');
			
			add_action ( 'add_meta_boxes', array (
					$this,
					'dt_add_portfolio_meta_box' 
			) );
			
			add_filter ( "manage_edit-dt_portfolios_columns", array (
					$this,
					"dt_portfolios_edit_columns" 
			) );
			
			add_action ( "manage_posts_custom_column", array (
					$this,
					"dt_portfolios_columns_display" 
			), 10, 2 );
		}
		
		/**
		 */
		function createPostType() {
			
			if(dttheme_option('pageoptions','single-portfolio-slug') != '') $pf_slug = trim(stripslashes(dttheme_option('pageoptions','single-portfolio-slug')));
			else $pf_slug = 'portfolios';
			
			if(dttheme_option('pageoptions','portfolio-category-slug') != '') $pf_cat_slug = trim(stripslashes(dttheme_option('pageoptions','portfolio-category-slug')));
			else $pf_cat_slug = 'portfolio-categories';
			
			$labels = array (
					'name' => esc_html__( 'Portfolios', 'dt_plugins' ),
					'all_items' => esc_html__( 'All Portfolios', 'dt_plugins' ),
					'singular_name' => esc_html__( 'Portfolio', 'dt_plugins' ),
					'add_new' => esc_html__( 'Add New', 'dt_plugins' ),
					'add_new_item' => esc_html__( 'Add New Portfolio', 'dt_plugins' ),
					'edit_item' => esc_html__( 'Edit Portfolio', 'dt_plugins' ),
					'new_item' => esc_html__( 'New Portfolio', 'dt_plugins' ),
					'view_item' => esc_html__( 'View Portfolio', 'dt_plugins' ),
					'search_items' => esc_html__( 'Search Portfolios', 'dt_plugins' ),
					'not_found' => esc_html__( 'No portfolios found', 'dt_plugins' ),
					'not_found_in_trash' => esc_html__( 'No portfolios found in Trash', 'dt_plugins' ),
					'parent_item_colon' => esc_html__( 'Parent Portfolio:', 'dt_plugins' ),
					'menu_name' => esc_html__( 'Portfolios', 'dt_plugins' ) 
			);
			
			$args = array (
					'labels' => $labels,
					'hierarchical' => false,
					'description' => 'This is custom post type portfolios',
					'supports' => array (
							'title',
							'editor',
							'excerpt',
							'comments' 
					),
					
					'public' => true,
					'show_ui' => true,
					'show_in_menu' => true,
					'menu_position' => 5,
					'menu_icon' => 'dashicons-format-gallery',
					
					'show_in_nav_menus' => true,
					'publicly_queryable' => true,
					'exclude_from_search' => false,
					'has_archive' => true,
					'query_var' => true,
					'can_export' => true,
					'rewrite' => array( 'slug' => $pf_slug, 'hierarchical' => true, 'with_front' => false ),
					'capability_type' => 'page' 
			);
			
			register_post_type ( 'dt_portfolios', $args );
			
			register_taxonomy ( "portfolio_entries", array (
					"dt_portfolios" 
			), array (
					"hierarchical" => true,
					"label" => "Categories",
					"singular_label" => "Category",
					"show_admin_column" => true,
					"rewrite" => array( 'slug' => $pf_cat_slug, 'hierarchical' => true, 'with_front' => false ),
					"query_var" => true 
			) );
		}
		
		/**
		 */
		function dt_add_portfolio_meta_box() {
			add_meta_box ( "dt-portfolio-default-metabox", esc_html__( 'Portfolio Options', 'dt_plugins' ), array (
					$this,
					'dt_default_metabox' 
			), 'dt_portfolios', "normal", "default" );
		}
		
		/**
		 */
		function dt_default_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_portfolio_default_metabox.php';
		}
		
		/**
		 *
		 * @param unknown $columns        	
		 * @return multitype:
		 */
		function dt_portfolios_edit_columns($columns) {
			$newcolumns = array (
					"cb" => "<input type=\"checkbox\" />",
					"thumb column-comments" => "Image",
					"title" => "Title",
					"portfolio_entries"=>"Categories",
					"likes"	=> "Likes",		
					"author" => "Author",
			);
			$columns = array_merge ( $newcolumns, $columns );
			return $columns;
		}
		
		/**
		 *
		 * @param unknown $columns        	
		 * @param unknown $id        	
		 */
		function dt_portfolios_columns_display($columns, $id) {
			global $post;
			switch ($columns) {
				
				case "thumb column-comments" :
					$portfolio_settings = get_post_meta ( $post->ID, '_portfolio_settings', TRUE );
					$portfolio_settings = is_array ( $portfolio_settings ) ? $portfolio_settings : array ();
					
					if (array_key_exists ( "items_thumbnail", $portfolio_settings )) {
						$item = $portfolio_settings ['items_thumbnail'] [0];
						$name = $portfolio_settings ['items_name'] [0];
						
						if ("video" === $name) {
							echo '<span class="dt-video"></span>';
						} else {
							echo "<img src='{$item}' height='60px' width='60px' alt='' />";
						}
					}
				break;
					
				case "portfolio_entries":
					echo get_the_term_list($post->ID, 'portfolio_entries', '', ', ','');
				break;
					
				case "likes":
					$likes = get_post_meta($post->ID, "_likes");
					if ($likes) {
					  echo esc_html($likes[0]);
					} else {
					  echo 0;
					}
				break;

			}
		}
		
		/**
		 */
		function save_post_meta($post_id) {
			if ( ! isset( $_POST['dtcore_plugin_portfolio_metabox_nonce'] ) || ! isset( $_POST['dtcore_plugin_portfolio_metabox_nonce'] ) ) {
				return;
			}
		
			if ( ! wp_verify_nonce( $_POST['dtcore_plugin_portfolio_metabox_nonce'], 'dtcore_plugin_portfolio_metabox' ) || ! wp_verify_nonce( $_POST['dtcore_plugin_portfolio_metabox_nonce'], 'dtcore_plugin_portfolio_metabox' ) ) {
				return;
			}
		
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
		
			if ( isset( $_POST['post_type'] ) && 'dt_portfolios' == $_POST['post_type'] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			if ( (key_exists('post_type', $_POST)) && ('dt_portfolios' == $_POST['post_type']) ) :
			
				if(isset($_POST['layout'])) :
				
					$settings = array ();
					
					$settings ['sub-title'] = isset ( $_POST ['sub-title'] ) ? stripslashes ( painting_wp_kses($_POST ['sub-title']) ) : "";
					
					$settings ['layout'] = isset ( $_POST ['layout'] ) ? $_POST ['layout'] : "";
					$settings ['show-social-share'] = isset ( $_POST ['dttheme-social-share'] ) ? $_POST ['dttheme-social-share'] : "";
					
					$settings ['socialshare-facebook'] = isset ( $_POST ['dttheme-socialshare-facebook'] ) ? $_POST ['dttheme-socialshare-facebook'] : "";
					$settings ['socialshare-delicious'] = isset ( $_POST ['dttheme-socialshare-delicious'] ) ? $_POST ['dttheme-socialshare-delicious'] : "";
					$settings ['socialshare-digg'] = isset ( $_POST ['dttheme-socialshare-digg'] ) ? $_POST ['dttheme-socialshare-digg'] : "";
					$settings ['socialshare-stumbleupon'] = isset ( $_POST ['dttheme-socialshare-stumbleupon'] ) ? $_POST ['dttheme-socialshare-stumbleupon'] : "";
					$settings ['socialshare-twitter'] = isset ( $_POST ['dttheme-socialshare-twitter'] ) ? $_POST ['dttheme-socialshare-twitter'] : "";
					$settings ['socialshare-googleplus'] = isset ( $_POST ['dttheme-socialshare-googleplus'] ) ? $_POST ['dttheme-socialshare-googleplus'] : "";
					$settings ['socialshare-linkedin'] = isset ( $_POST ['dttheme-socialshare-linkedin'] ) ? $_POST ['dttheme-socialshare-linkedin'] : "";
					$settings ['socialshare-pinterest'] = isset ( $_POST ['dttheme-socialshare-pinterest'] ) ? $_POST ['dttheme-socialshare-pinterest'] : "";
					
					$settings ['items'] = isset ( $_POST ['items'] ) ? painting_wp_kses($_POST ['items']) : "";
					$settings ['items_thumbnail'] = isset ( $_POST ['items_thumbnail'] ) ? painting_wp_kses($_POST ['items_thumbnail']) : "";
					$settings ['items_name'] = isset ( $_POST ['items_name'] ) ? painting_wp_kses($_POST ['items_name']) : "";
					$settings ['items_id'] = isset ( $_POST ['items_id'] ) ? $_POST ['items_id'] : "";
					
					$settings ['dt-video-id'] = isset ( $_POST ['dt-video-id'] ) ? $_POST ['dt-video-id'] : "";
					
					$settings ['hover-color'] = isset ( $_POST ['dttheme-hover-color'] ) ? $_POST ['dttheme-hover-color'] : "";
					$settings ['hover-color-opacity'] = isset ( $_POST ['dttheme-hover-color-opacity'] ) ? $_POST ['dttheme-hover-color-opacity'] : "";
					
					$custom_fields = dttheme_option("pageoptions","portfolio-custom-fields");
					$custom_fields = is_array($custom_fields) ? array_filter($custom_fields) : array();
					$custom_fields = array_unique( $custom_fields);
					foreach( $custom_fields as $field ){ 
						$field_id = str_replace(' ', '-', strtolower(trim($field)));
						$settings [$field_id] = isset ( $_POST [$field_id] ) ? painting_wp_kses($_POST [$field_id]) : '';
					}
	
					update_post_meta ( $post_id, "_portfolio_settings", array_filter ( $settings ) );
					
				endif;
			
			endif;
			
		}
		
		/**
		 * To load portfolio pages in front end
		 *
		 * @param string $template        	
		 * @return string
		 */
		function dt_template_include($template) {
			if (is_singular () && 'dt_portfolios' === get_post_type ()) {
				
				if (! file_exists ( get_stylesheet_directory () . '/single-dt_portfolios.php' )) {
					$template = plugin_dir_path ( __FILE__ ) . 'templates/single-dt_portfolios.php';
				}
			} elseif (is_tax ( 'portfolio_entries' )) {
				if (! file_exists ( get_stylesheet_directory () . '/taxonomy-portfolio_entries.php' )) {
					$template = plugin_dir_path ( __FILE__ ) . 'templates/taxonomy-portfolio_entries.php';
				}
			} elseif( is_post_type_archive( 'dt_portfolios' ) ) {
				if (! file_exists ( get_stylesheet_directory () . '/archive-dt_portfolios.php' )) {
					$template = plugin_dir_path ( __FILE__ ) . 'templates/archive-dt_portfolios.php';
				}
			}
			
			return $template;
		}
	}
}
?>