<?php
global $post;
$portfolio_settings = get_post_meta ( $post->ID, '_portfolio_settings', TRUE );
$portfolio_settings = is_array ( $portfolio_settings ) ? $portfolio_settings : array ();

wp_nonce_field( 'dtcore_plugin_portfolio_metabox', 'dtcore_plugin_portfolio_metabox_nonce' );
?>

<!-- Sub Title -->
<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Sub Title','dt_plugins');?></label>
	</div>

	<div class="column five-sixth last">
	<?php $subtitle = array_key_exists ( "sub-title", $portfolio_settings ) ? $portfolio_settings ['sub-title'] : '';?>
    
		<input id="sub-title" name="sub-title" type="text" class="widefat" 	value="<?php echo esc_attr($subtitle);?>" />
		<p class="note"> <?php esc_html_e("If you wish! You can add sub title.",'dt_plugins');?> </p>
        <div class="clear"></div>
	</div>
</div><!-- Sub Title End -->

<!-- Layout -->
<div class="custom-box ">
	<div class="column one-sixth">
		<label><?php esc_html_e('Layout','dt_plugins');?> </label>
	</div>
	<div class="column five-sixth last">
		<ul class="dtPortfolio dt-bpanel-layout-set"><?php
		
		$layouts = array (
				'single-portfloio-layout-one' => 'portfolio-fullwidth',
				'single-portfloio-layout-two' => 'portfolio-with-left-gallery',
				'single-portfloio-layout-three' => 'portfolio-with-right-gallery' 
		);
		
		$v = array_key_exists ( "layout", $portfolio_settings ) ? $portfolio_settings ['layout'] : 'single-portfloio-layout-one';
		foreach ( $layouts as $key => $value ) {
			$class = ($key == $v) ? " class='selected' " : "";
			echo "<li><a href='#' rel='{$key}' {$class}><img src='" . plugin_dir_url ( __FILE__ ) . "images/columns/".esc_attr($value).".png' alt='' /></a></li>";
		}
		?></ul>
		<?php $v = array_key_exists("layout",$portfolio_settings) ? $portfolio_settings['layout'] : 'single-portfloio-layout-one';?>
		<input id="dttheme-portfolio-layout" name="layout" type="hidden" value="<?php echo esc_attr($v); ?>" />
		<p class="note"> <?php esc_html_e("You can choose between a left, right or full width.",'dt_plugins');?> </p>
	</div>

</div>
<!-- Layout End-->

<?php 
$custom_fields = dttheme_option("pageoptions","portfolio-custom-fields");
$custom_fields = is_array($custom_fields) ? array_filter($custom_fields) : array();
$custom_fields = array_unique( $custom_fields);
foreach( $custom_fields as $field ){ 
	$field_id = str_replace(' ', '-', strtolower(trim($field)));
	?>
	<div class="custom-box">
	
		<div class="column one-sixth">
			<label><?php esc_html_e($field,'dt_plugins');?></label>
		</div>
	
		<div class="column five-sixth last">
			<?php $field_value = array_key_exists ($field_id, $portfolio_settings) ? $portfolio_settings[$field_id] : '';?>
			<input id="<?php echo esc_attr($field_id); ?>" name="<?php echo esc_attr($field_id); ?>" type="text" class="widefat" value="<?php echo esc_attr($field_value);?>" />
			<p class="note"><?php echo sprintf( esc_html__('If you wish! You can add %s here.', 'dt_plugins'), $field ) ?></p>
			<div class="clear"></div>
		</div>
		
	</div>
	<?php
}
?>

<!-- Show Social Share -->
<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Show Social Share','dt_plugins');?></label>
	</div>
	<div class="column five-sixth last"><?php
	$switchclass = array_key_exists ( "show-social-share", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
	$checked = array_key_exists ( "show-social-share", $portfolio_settings ) ? ' checked="checked"' : '';
	?><div data-for="dttheme-social-share"
			class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
		<input id="dttheme-social-share" class="hidden" type="checkbox"
			name="dttheme-social-share" value="true" <?php echo esc_attr($checked);?> />
		<p class="note"> <?php esc_html_e('Would you like to show the social share at the bottom','dt_plugins');?> </p>
	</div>
</div>

<div class="custom-box">
	<div class="column one-half">
        <div class="column one-fourth">
            <label><?php esc_html_e('Facebook','dt_plugins');?></label>
        </div>
        <div class="column one-fourth">
            <?php
            $switchclass = array_key_exists ( "socialshare-facebook", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-facebook", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-facebook" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-facebook" class="hidden" type="checkbox" name="dttheme-socialshare-facebook" value="true" <?php echo esc_attr($checked);?> />
        </div>
        <div class="column one-fourth">
            <label><?php esc_html_e('Delicious','dt_plugins');?></label>
        </div>
        <div class="column one-fourth last">
            <?php
            $switchclass = array_key_exists ( "socialshare-delicious", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-delicious", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-delicious" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-delicious" class="hidden" type="checkbox" name="dttheme-socialshare-delicious" value="true" <?php echo esc_attr($checked);?> />
        </div>
    </div>
	<div class="column one-half last">
        <div class="column one-fourth">
            <label><?php esc_html_e('Digg','dt_plugins');?></label>
        </div>
        <div class="column one-fourth">
            <?php
            $switchclass = array_key_exists ( "socialshare-digg", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-digg", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-digg" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-digg" class="hidden" type="checkbox" name="dttheme-socialshare-digg" value="true" <?php echo esc_attr($checked);?> />
        </div>
        <div class="column one-fourth">
            <label><?php esc_html_e('StumbleUpon','dt_plugins');?></label>
        </div>
        <div class="column one-fourth last">
            <?php
            $switchclass = array_key_exists ( "socialshare-stumbleupon", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-stumbleupon", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-stumbleupon" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-stumbleupon" class="hidden" type="checkbox" name="dttheme-socialshare-stumbleupon" value="true" <?php echo esc_attr($checked);?> />
        </div>
    </div>
</div>

<div class="custom-box">
	<div class="column one-half">
        <div class="column one-fourth">
            <label><?php esc_html_e('Twitter','dt_plugins');?></label>
        </div>
        <div class="column one-fourth">
            <?php
            $switchclass = array_key_exists ( "socialshare-twitter", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-twitter", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-twitter" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-twitter" class="hidden" type="checkbox" name="dttheme-socialshare-twitter" value="true" <?php echo esc_attr($checked);?> />
        </div>
        <div class="column one-fourth">
            <label><?php esc_html_e('Google Plus','dt_plugins');?></label>
        </div>
        <div class="column one-fourth last">
            <?php
            $switchclass = array_key_exists ( "socialshare-googleplus", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-googleplus", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-googleplus" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-googleplus" class="hidden" type="checkbox" name="dttheme-socialshare-googleplus" value="true" <?php echo esc_attr($checked);?> />
        </div>
    </div>
    <div class="column one-half last">
        <div class="column one-fourth">
            <label><?php esc_html_e('LinkedIn','dt_plugins');?></label>
        </div>
        <div class="column one-fourth">
            <?php
            $switchclass = array_key_exists ( "socialshare-linkedin", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-linkedin", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-linkedin" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-linkedin" class="hidden" type="checkbox" name="dttheme-socialshare-linkedin" value="true" <?php echo esc_attr($checked);?> />
        </div>
        <div class="column one-fourth">
            <label><?php esc_html_e('Pintrest','dt_plugins');?></label>
        </div>
        <div class="column one-fourth last">
            <?php
            $switchclass = array_key_exists ( "socialshare-pinterest", $portfolio_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
            $checked = array_key_exists ( "socialshare-pinterest", $portfolio_settings ) ? ' checked="checked"' : '';
            ?>
            <div data-for="dttheme-socialshare-pinterest" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
            <input id="dttheme-socialshare-pinterest" class="hidden" type="checkbox" name="dttheme-socialshare-pinterest" value="true" <?php echo esc_attr($checked);?> />
        </div>
    </div>
</div>
<!-- Show Social Share End -->

<!-- Medias -->
<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Images','dt_plugins');?> </label>
	</div>
	<div class="column five-sixth last">
		<div class="dt-media-btns-container">
			<a href="#" class="dt-open-media custom-button-style"><?php esc_html_e( 'Click Here to Add Images', 'dt_plugins' );?> </a>
			<a href="#" class="dt-add-video custom-button-style"><?php esc_html_e( 'Click Here to Add Video', 'dt_plugins' );?> </a>
            <?php $dt_video_id = array_key_exists ( "dt-video-id", $portfolio_settings ) ? $portfolio_settings ['dt-video-id'] : 0;?>
            <input type="hidden" name="dt-video-id" id="dt-video-id" value="<?php echo esc_attr($dt_video_id); ?>" />
		</div>
		<div class="clear"></div>

		<div class="dt-media-container">
			<ul class="dt-items-holder"><?php
			if (array_key_exists ( "items", $portfolio_settings )) {
				foreach ( $portfolio_settings ["items_thumbnail"] as $key => $thumbnail ) {
					$item = $portfolio_settings ['items'] [$key];
					$items_id = isset($portfolio_settings ['items_id'] [$key]) ? $portfolio_settings ['items_id'] [$key] : 0;
					
					$name = "";
					$foramts = array (
							'jpg',
							'jpeg',
							'gif',
							'png' 
					);
					$parts = explode ( '.', $item );
					$ext = strtolower ( $parts [count ( $parts ) - 1] );
					if (in_array ( $ext, $foramts )) {
						$name = $portfolio_settings ['items_name'] [$key];
						echo "<li>";
						echo "<img src='".esc_attr($thumbnail)."' alt='' />";
						echo "<span class='dt-image-name'>".esc_html($name)."</span>";
						echo "<input type='hidden' name='items[]' value='".esc_html($item)."' />";
					} else {
						$name = "video";
						echo "<li>";
						echo "<span class='dt-video'></span>";
						echo "<input type='text' name='items[]' value='".esc_html($item)."' />";
					}
					
					echo "<input class='dt-image-name' type='hidden' name='items_name[]' value='".esc_html($name)."' />";
					echo "<input type='hidden' name='items_thumbnail[]' value='".esc_html($thumbnail)."' />";
					echo "<input type='hidden' name='items_id[]' value='".esc_html($items_id)."' />";
					echo "<span class='my_delete'></span>";
					echo "</li>";
				}
			}
			?></ul>
		</div>
	</div>
</div>
<!-- Medias End -->


<div class="custom-box">
	<div class="column one-half">
        <div class="column one-half">
            <label><?php esc_html_e('Hover Color','dt_plugins');?></label>
        </div>
        <div class="column one-half last">
			<?php
            $name  =  "dttheme-hover-color";
            $value =  array_key_exists ( "hover-color", $portfolio_settings ) ? $portfolio_settings["hover-color"] :"#";
            painting_admin_color_picker_two($name, $value);
            ?>
            <p class="note"><?php esc_html_e('Choose hover color for your portfolio items.', 'painting');?></p>
        </div>
    </div>
	<div class="column one-half last">
        <div class="column one-half">
            <label><?php esc_html_e('Hover Color Opacity','dt_plugins');?></label>
        </div>
        <div class="column one-half last">
			<?php $hover_color_opacity = array_key_exists ( 'hover-color-opacity', $portfolio_settings ) ? $portfolio_settings ['hover-color-opacity'] : '';?>
            <input id="dttheme-hover-color-opacity" name="dttheme-hover-color-opacity" type="text" class="widefat" 	value="<?php echo esc_attr($hover_color_opacity);?>" />
            <p class="note"> <?php esc_html_e("Choose hover color opacity for your portfolio items.",'dt_plugins');?> </p>
        </div>
    </div>
</div>
