<?php
class DTCoreShortcodesDefination {
	
	function __construct() {
		
		/* Accordion Shortcode */
		add_shortcode ( "dt_sc_accordion_group", array ( $this, "dt_sc_accordion_group" ) );
		add_shortcode ( "dt_sc_accordion_frame", array ( $this, "dt_sc_accordion_frame" ) );

		/* Button Shortcode */
		add_shortcode ( "dt_sc_button", array ( $this, "dt_sc_button" ) );

		/* BlockQuotes Shortcode */
		add_shortcode ( "dt_sc_blockquote", array ( $this, "dt_sc_blockquote" ) );

		/* Intro Box Shortcode */
		add_shortcode ( "dt_sc_intro_box", array ( $this, "dt_sc_intro_box" ));

		/* Columns Shortcode */
		add_shortcode ( "dt_sc_full_width", array ( $this, "dt_sc_columns" ) );
		
		add_shortcode ( "dt_sc_one_column", array ( $this, "dt_sc_columns" ) );
		
		add_shortcode ( "dt_sc_one_half", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_one_third", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_one_fourth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_one_fifth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_one_sixth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_two_sixth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_two_third", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_fourth", array ( $this, "dt_sc_columns") );

		add_shortcode ( "dt_sc_two_fifth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_fifth", array ( $this,"dt_sc_columns" ) );

		add_shortcode ( "dt_sc_four_fifth", array ( $this,"dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_sixth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_four_sixth", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_five_sixth", array ( $this, "dt_sc_columns" ) );

		/* Column with inner */
		add_shortcode ( "dt_sc_one_half_inner", array ( $this, "dt_sc_columns") );

		add_shortcode ( "dt_sc_one_third_inner", array ( $this, "dt_sc_columns") );

		add_shortcode ( "dt_sc_one_fourth_inner", array ( $this, "dt_sc_columns") );

		add_shortcode ( "dt_sc_one_fifth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_one_sixth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_two_sixth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_two_third_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_fourth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_two_fifth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_fifth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_four_four_inner", array (  $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_three_sixth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_four_sixth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_five_sixth_inner", array ( $this, "dt_sc_columns" ) );

		add_shortcode ( "dt_sc_four_fifth_inner", array (  $this, "dt_sc_columns" ) );

		/* Patners Shortcode */
		add_shortcode ( "dt_sc_patners_carousel", array ( $this, "dt_sc_patners_carousel") );

		/* Donutchart Start */
		add_shortcode ( "dt_sc_donutchart_small", array ( $this,"dt_sc_donutchart") );
		add_shortcode ( "dt_sc_donutchart_medium", array ( $this, "dt_sc_donutchart") );
		/* Donutchart End */
		
		/* Dividers */
		add_shortcode ( "dt_sc_clear", array ( $this,"dt_sc_clear") );
		add_shortcode ( 'dt_sc_margin', array ( $this, "dt_sc_margin" ));
		add_shortcode ( 'dt_sc_space', array ( $this, "dt_sc_space" ));
		add_shortcode ( "dt_sc_hr_line", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_line_white", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_border", array ( $this,"dt_sc_hr_border") );
		add_shortcode ( "dt_sc_hr", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_medium", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_large", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_top", array( $this, "dt_sc_hr_top" ) );
		add_shortcode ( "dt_sc_hr_invisible", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_invisible_small", array ( $this, "dt_sc_dividers" ) );
		add_shortcode ( "dt_sc_hr_invisible_very_small", array ( $this, "dt_sc_dividers" ) );

		/* Dividers End */
		
		/* Icon Boxes Shortcode */
		add_shortcode ( "dt_sc_icon_box", array ( $this,"dt_sc_icon_box" ) );
		add_shortcode ( "dt_sc_icon_box_wrapper", array ( $this,"dt_sc_icon_box_wrapper" ) );
		
		/* Colored Boxes Shortcode */
		add_shortcode ( "dt_sc_colored_box", array ( $this, "dt_sc_colored_box" ) );
		
		/* Code Shortcode */
		add_shortcode ( "dt_sc_code", array ( $this, "dt_sc_code" ) );

		/* Ordered List Shortcode */
		add_shortcode ( "dt_sc_fancy_ol", array ( $this, "dt_sc_fancy_ol" ) );
		
		/* Unordered List Shortcode */
		add_shortcode ( "dt_sc_fancy_ul", array ( $this, "dt_sc_fancy_ul" ) );

		/* Pricing Table */
		add_shortcode ( "dt_sc_pricing_table_item", array ( $this, "dt_sc_pricing_table_item" ) );

		/* Progress Bar Shortcode */
		add_shortcode ( "dt_sc_progressbar", array ( $this, "dt_sc_progressbar" ) );

		/* Tabs */
		add_shortcode ( "dt_sc_tab", array ( $this, "dt_sc_tab" ) );
		
		add_shortcode ( "dt_sc_tabs_horizontal", array ( $this, "dt_sc_tabs_horizontal") );
		
		add_shortcode ( "dt_sc_tabs_vertical", array ( $this, "dt_sc_tabs_vertical" ) );

		/* Testimonial Shortcode */
		add_shortcode ( "dt_sc_testimonial", array ( $this, "dt_sc_testimonial" ) );
		
		/* Testimonial Carousel / wrapper Shortcode */
		add_shortcode ( "dt_sc_testimonial_carousel", array ( $this, "dt_sc_testimonial_carousel") );

		/* Title Shortcode */
		add_shortcode ( "dt_sc_title", array ( $this, "dt_sc_title") );

		/* Toggle Shortcode */
		add_shortcode ( "dt_sc_toggle_group", array ( $this, "dt_sc_toggle_group" ) );
		add_shortcode ( "dt_sc_toggle_frame", array ( $this, "dt_sc_toggle_frame" ) );
		
		/* Titles Box Shortcode */
		add_shortcode ( "dt_sc_titled_box", array ( $this, "dt_sc_titled_box" ) );
		
		/* Tooltip Shortcode */
		add_shortcode ( "dt_sc_tooltip", array ( $this, "dt_sc_tooltip" ) );
		
		/* PullQuotes Shortcode */
		add_shortcode ( "dt_sc_pullquote", array ( $this, "dt_sc_pullquote" ) );

		/* Portfolio Shortcode */

		add_shortcode( "dt_sc_portfolio_item", array( $this, "dt_sc_portfolio_item" ));

		add_shortcode( "dt_sc_portfolios", array( $this, "dt_sc_portfolios" ));

		/* Full width Shortcode*/
		add_shortcode("dt_sc_fullwidth_section", array ( $this, "dt_sc_fullwidth_section" ) );

		/* Animation */
		add_shortcode("dt_sc_animation", array ( $this, "dt_sc_animation" ) );

		/* Post And Recent Posts */
		add_shortcode("dt_sc_post", array ( $this, "dt_sc_post" ) );
		add_shortcode("dt_sc_recent_post", array ( $this, "dt_sc_recent_post" ) );
		add_shortcode("dt_sc_post_carousel", array ( $this, "dt_sc_post_carousel" ) );
		
		/* Widget Shortcodes */
		add_shortcode ( "dt_sc_widgets", array ( $this, "dt_sc_widgets" ) );
		
		/* Do Shortcodes */
		add_shortcode ( "dt_sc_doshortcode", array ( $this, "dt_sc_doshortcode" ) );
	
		/* Resizable Column */
		add_shortcode ( "dt_sc_resizable", array ( $this, "dt_sc_resizable" ) );

		add_shortcode ( "dt_sc_resizable_inner", array ( $this, "dt_sc_resizable" ) );
		
		/* Social Links */	
		add_shortcode('dt_sc_social_links', array ( $this, "dt_sc_social_links" ));	
		
		/* Team */
		add_shortcode('dt_sc_team', array ( $this, "dt_sc_team" ));
		add_shortcode('dt_sc_team_carousel', array ( $this, "dt_sc_team_carousel" ));
		
		/* Image */
		add_shortcode('dt_sc_image', array ( $this, "dt_sc_image" ));
		
		/* Newsletter Section */
		add_shortcode('dt_sc_newsletter_section', array ( $this, "dt_sc_newsletter_section" ));
		
		/* Animate Number */
		add_shortcode('dt_sc_animate_number', array ( $this, "dt_sc_animate_number" ));
						
		/* Woocommerce Products */
		add_shortcode('dt_sc_woo_products', array ( $this, "dt_sc_woo_products" ));
		add_shortcode('dt_sc_woo_featured_product', array ( $this, "dt_sc_woo_featured_product" ));
		
		/* Custom Menus */	
		add_shortcode('dt_sc_custom_menus', array ( $this, "dt_sc_custom_menus" ));	
		add_shortcode('dt_sc_custom_menu_item', array ( $this, "dt_sc_custom_menu_item" ));		
		add_shortcode('dt_sc_custom_menu_location', array ( $this, "dt_sc_custom_menu_location" ));		
		
		/* Contact Details */
		add_shortcode('dt_sc_contact_details', array ( $this, "dt_sc_contact_details" ));	
		add_shortcode('dt_sc_contact_form_wrapper', array ( $this, "dt_sc_contact_form_wrapper" ));	
		add_shortcode('dt_sc_contact_info', array ( $this, "dt_sc_contact_info" ));	
		add_shortcode('dt_sc_support_info', array ( $this, "dt_sc_support_info" ));	

		/* Search & Cart */
		add_shortcode('dt_sc_search_cart', array ( $this, "dt_sc_search_cart" ));	
		
		/* Popup Video */
		add_shortcode('dt_sc_popup_video', array ( $this, "dt_sc_popup_video" ));	
		
		/* Map Adress Wrapper */
		add_shortcode('dt_sc_map_address_wrapper', array ( $this, "dt_sc_map_address_wrapper" ));	
	
		/* Content Carousel */
		add_shortcode('dt_sc_content_carousel', array ( $this, "dt_sc_content_carousel" ));	
		
		/* Schedule Appointment */
		add_shortcode('dt_sc_schedule_appointment', array ( $this, "dt_sc_schedule_appointment" ));	
		
		/* GDPR Privacy Shortcodes */
		add_shortcode("dt_sc_privacy_link", array(
			$this,
			"dt_sc_privacy_policy_link"
		) );

		add_shortcode("dt_sc_privacy_google_tracking", array(
			$this,
			"dt_sc_privacy_disable_google_tracking"
		) );

		add_shortcode("dt_sc_privacy_google_webfonts", array(
			$this,
			"dt_sc_privacy_disable_google_webfonts"
		) );

		add_shortcode("dt_sc_privacy_google_maps", array(
			$this,
			"dt_sc_privacy_disable_google_maps"
		) );

		add_shortcode("dt_sc_privacy_video_embeds", array(
			$this,
			"dt_sc_privacy_disable_video_embeds"
		) );

	}
	
	/**
	 *
	 * @param string $content        	
	 * @return string
	 */
	function dtShortcodeHelper($content = null) {
		$content = do_shortcode ( shortcode_unautop ( $content ) );
		$content = preg_replace ( '#^<\/p>|^<br \/>|<p>$#', '', $content );
		return trim ( $content );
	}
	
	/**
	 *
	 * @param string $dir        	
	 * @return multitype:
	 */
	function dtListImages($dir = null) {
		$images = array ();
		$icon_types = array ( 'jpg','jpeg','gif','png');
		
		if (is_dir ( $dir )) {
			$handle = opendir ( $dir );
			while ( false !== ($dirname = readdir ( $handle )) ) {
				
				if ($dirname != "." && $dirname != "..") {
					$parts = explode ( '.', $dirname );
					$ext = strtolower ( $parts [count ( $parts ) - 1] );
					
					if (in_array ( $ext, $icon_types )) {
						$option = $parts [count ( $parts ) - 2];
						$images [$dirname] = str_replace ( ' ', '', $option );
					}
				}
			}
			closedir ( $handle );
		}
		
		return $images;
	}
	
	function getTimeDifference($time) {
		$currentTime = date('Y-m-d H:i:s');
		$toTime = strtotime($currentTime);
		$fromTime = strtotime($time);
		$timeDiff = floor(abs($toTime - $fromTime) / 60);
		if ($timeDiff < 2) {
			$timeDiff = esc_html__('Just now', 'dt_plugins');
		} elseif ($timeDiff > 2 && $timeDiff < 60) {
			$timeDiff = esc_html__('about ','dt_plugins').floor(abs($timeDiff)) . esc_html__(' minutes ago', 'dt_plugins');
		} elseif ($timeDiff > 60 && $timeDiff < 120) {
			$timeDiff = esc_html__('about ','dt_plugins').floor(abs($timeDiff / 60)) . esc_html__(' hour ago', 'dt_plugins');
		} elseif ($timeDiff < 1440) {
			$timeDiff = esc_html__('about ','dt_plugins').floor(abs($timeDiff / 60)) . esc_html__(' hours ago', 'dt_plugins');
		} elseif ($timeDiff > 1440 && $timeDiff < 2880) {
			$timeDiff = esc_html__('about ','dt_plugins').floor(abs($timeDiff / 1440)) . esc_html__(' day ago', 'dt_plugins');
		} elseif ($timeDiff > 2880) {
			$timeDiff = esc_html__('about ','dt_plugins').floor(abs($timeDiff / 1440)) . esc_html__(' days ago', 'dt_plugins');
		}
		return $timeDiff;
	}
	
	function hex2rgb($hex) {
		$hex = str_replace ( "#", "", $hex );
		
		if (strlen ( $hex ) == 3) :
			$r = hexdec ( substr ( $hex, 0, 1 ) . substr ( $hex, 0, 1 ) );
			$g = hexdec ( substr ( $hex, 1, 1 ) . substr ( $hex, 1, 1 ) );
			$b = hexdec ( substr ( $hex, 2, 1 ) . substr ( $hex, 2, 1 ) );
		 else :
			$r = hexdec ( substr ( $hex, 0, 2 ) );
			$g = hexdec ( substr ( $hex, 2, 2 ) );
			$b = hexdec ( substr ( $hex, 4, 2 ) );
		endif;
		$rgb = array ( $r,$g,$b);
		return $rgb;
	}
	
	function dt_sc_accordion_group($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'class' => '' ), $attrs ) );
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<div class="dt-sc-toggle-frame-set '.esc_attr($class).' '.esc_attr($type).'">'.$content.'</div>';
		return $out;
	}


	function dt_sc_accordion_frame($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'title' => '' ), $attrs ) );
		$out  = '<h5 class="dt-sc-toggle-accordion"><a href="#">'.$title.'</a></h5>';
		$out .= '<div class="dt-sc-toggle-content" style="display: none;">';
		$out .= '	<div class="block">';
		$out .= 		DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out .= '	</div>';
		$out .= '</div>';
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_button($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'icon' =>'', 'size' => '', 'link' => '#',  'target' => '', 'variation' => '', 'align' => '', 'class' =>'' ), $attrs ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$target = empty($target) ? 'target="_blank"' : 'target="'.$target.'"';
		
		if(preg_match('#^{{#', $link) === 1) {
			$link =  str_replace ( '{{', '[', $link );
			$link =  str_replace ( '}}', '/]', $link );
			$link = do_shortcode($link);
		} else {
			$link = esc_url($link);
		}		
		
		if($icon != '' && $type != 'type4' && $type != 'type5') { $icon = '<span class="fa '.$icon.'"></span>'; } else { $icon = ''; }
		if($variation != '' && ($type == 'type6' || $type == 'type7')) { $variation = ''; }
		
		$out = '<a href="'.$link.'" '.$target.' class="dt-sc-button '.$type.' '.$size.' '.$variation.' '.$align.' '.$class.'">'.$icon.$content.'</a>';
		
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_blockquote($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'textcolor' => '', 'class'=> ''), $attrs ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = ! empty ( $content ) ? '<q>'.strip_tags($content).'</q>' : "";
		
		$style = ( $textcolor ) ? ' style="color:' . $textcolor . ';"' : '';
		
		$out = '<blockquote class="'.$class.'" '.$style.'>';
		$out .= $content;
		$out .= '</blockquote>';
		return $out;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_intro_box($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'background_image' => '', 'background_position' => '', 'background_repeat' => '', 'background_color' => '', 'animation' => '', 'animation_delay' => '', 'class' => '' ), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$animation_cls = $data_animation = $data_delay = '';
		if($animation != '' && $animation != 'None') {
			$animation_cls = 'animate';
			$data_animation = 'data-animation="'.$animation.'"';
			$data_delay = 'data-delay="'.$animation_delay.'"';
		}
		
		if($background_image != '') {
			if($background_position != '') $bgposition = $background_position; else $bgposition = 'left top';
			if($background_repeat != '') $bgrepeat = $background_repeat; else $bgrepeat = 'no-repeat';
			$introbg = 'style="background:url('.$background_image.') '.$bgposition.' '.$bgrepeat.';"';
		} else if($background_color != '') $introbg = 'style="background:'.$background_color.';"';
		else $introbg = '';

		$out = '<div class="intro-text '.$type.' '.$class.' '.$animation_cls.'" '.$introbg.' '.$data_animation.' '.$data_delay.'>
					<div class="container">
						'.$content.'
					</div>
				</div>';
					
		return $out;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @param string $shortcodename        	
	 * @return string
	 */
	function dt_sc_columns($attrs, $content = null, $shortcodename = "") {
		extract ( shortcode_atts ( array ( 'class' => '', 'type' => '', 'bgcolor' => '', 'bgcoloropacity' => '', 'borderradius' => '', 'bgimageurl' => '', 'bgimageposition' => '', 'bgimagerepeat' => '', 'textcolor' => '', 'padding' => '', 'borderwidth' => '', 'borderstyle' => '', 'bordercolor' => '', 'alignment' => '', 'animation' => '', 'animation_delay' => '' ), $attrs ) );
		
		$shortcodename = str_replace ( "_", "-", $shortcodename );
		$shortcodename = str_replace ( "-inner", "", $shortcodename );
		
		$danimation = $ddelay = $danimate = '';
		if($animation != '' && $animation != 'None') {
			$danimation = 'data-animation="'.$animation.'"';
			$ddelay = 'data-delay="'.$animation_delay.'"';
			$danimate = 'animate';
		}
		
		if($bgcolor != '') {
			if($bgcoloropacity != '') {
				$rgb = painting_hex2rgb($bgcolor); 
				$bgcolor = 'background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$bgcoloropacity.');';
			} else $bgcolor = 'background-color:'.$bgcolor.';';
		}
		if($borderradius != '') { $borderradius = 'border-radius:'.$borderradius.';'; }
		if($bgimageurl != '') { $bgimageurl = 'background-image:url('.$bgimageurl.');'; }
		if($bgimageposition != '') { $bgimageposition = 'background-position:'.$bgimageposition.';'; }
		if($bgimagerepeat != ''){  $bgimagerepeat = 'background-repeat:'.$bgimagerepeat.';'; }
		if($textcolor != '') { $textcolor = 'color:'.$textcolor.';'; }
		if($padding != '') { $padding = 'padding:'.$padding.';'; }
		if($borderwidth != '') { $borderwidth = 'border-width:'.$borderwidth.';'; }
		if($borderstyle != '') { $borderstyle = 'border-style:'.$borderstyle.';'; }
		if($bordercolor != '') { $bordercolor = 'border-color:'.$bordercolor.';'; }
		$style = 'style="'.$bgcolor.' '.$borderradius.' '.$bgimageurl.' '.$bgimageposition.' '.$bgimagerepeat.' '.$textcolor.' '.$padding.' '.$borderwidth.' '.$borderstyle.' '.$bordercolor.'"';
		
		if($alignment != '') { $alignment = 'text-'.$alignment; }
		
		$type = ( trim($type) === 'type2' ) ? "no-space" : "";
		$first = (isset ( $attrs [0] ) && trim ( $attrs [0] == 'first' )) ? 'first' : '';
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<div class="column '.$shortcodename.' '.$class.' '.$type.' '.$danimate.' '.$first.' '.$alignment.'" '.$danimation.' '.$ddelay.' '.$style.'>'.$content.'</div>';
		return $out;
	}

	/* Client Carousel */
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_patners_carousel($attrs, $content = null) {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = str_replace( '<ul>', '<ul class="dt-sc-partner-carousel">', $content );
		
		$out = '<div class="dt-sc-partner-carousel-wrapper">';
			$out .= $content;
		$out .= '</div>';
					
		return $out;
		
	}

	/* Client Carousel End */
	
	/* Dividers */
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_clear($attrs, $content = null) {
		return '<div class="dt-sc-clear"></div>';
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_hr_border($attrs, $content = null) {
		return '<div class="dt-sc-hr-image"></div>';
	}


	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @param string $shortcodename        	
	 * @return string
	 */
	function dt_sc_donutchart($attrs, $content = null, $shortcodename = "") {
		extract ( shortcode_atts ( array ( 'title' => '', 'notes' => '', 'bgcolor' => '', 'fgcolor' => '', 'percent' =>'30' ), $attrs ) );
		
		$size = "120";
		$size = ("dt_sc_donutchart_medium" === $shortcodename) ? "160" : $size;
		
		$shortcodename = str_replace ( "_", "-", $shortcodename );
		$out = '<div class="'.$shortcodename.'">';
		$out .= '<div class="dt-sc-donutchart" data-size="'.$size.'" data-percent="'.$percent.'" data-bgcolor="'.$bgcolor.'" data-fgcolor="'.$fgcolor.'"></div>';
		if($title != '') $out .= '<h6 class="dt-sc-donutchart-title">'.$title.'</h6>';
		if($notes != '') $out .= '<p>'.$notes.'</p>';
		$out .= '</div>';

		return $out;
	}

	// Added for page builder
	function dt_sc_hr_top( $attrs, $content = null, $shortcode = "" ){
		return do_shortcode("[dt_sc_hr top]");
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @param string $shortcodename        	
	 * @return string
	 */
	function dt_sc_dividers($attrs, $content = null, $shortcodename = "") {
		extract ( shortcode_atts ( array ( 'class' => '', 'top' => '' ), $attrs ) );
		
		$shortcodename = trim($shortcodename);
		if ("dt_sc_hr" === $shortcodename || "dt_sc_hr_medium" === $shortcodename || "dt_sc_hr_large" === $shortcodename) {
			
			$shortcodename = str_replace ( "_", "-", $shortcodename );
			
			$out = "<div class='{$shortcodename} {$class}'>";
			
			if ((isset ( $attrs [0] ) && trim ( $attrs [0] == 'top' ))) {
				
				$out = "<div class='{$shortcodename} top {$class}'>";
				$out .= "<a href='#top' class='scrollTop'><span class='fa fa-angle-up'></span>" . esc_html__( "top", 'dt_plugins' ) . "</a>";
			}
			
			$out .= "</div>";
		} else {
			$shortcodename = str_replace ( "_", "-", $shortcodename );
			$out = "<div class='{$shortcodename}  {$class}'></div>";
		}
		return $out;
	}
	/* Dividers End*/
	
	/* Icon Boxes Shortcode */
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @param string $shortcodename        	
	 * @return string
	 */
	function dt_sc_icon_box($attrs, $content = null, $shortcodename = "") {
		extract ( shortcode_atts ( array ( 'type' => '', 'fontawesome_icon' => '', 'stroke_icon' => '', 'custom_icon' => '', 'title_icon' => '', 'title' => '', 'link' => '#', 'span_text' => '', 'readmore_title' => '', 'variation' => '', 'alignright' => 'false', 'alignment' => '', 'animation' => '', 'animation_delay' => '', 'class' => ''), $attrs ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = strip_tags($content);
		$content = ($content != '') ? '<p>'.$content.'</p>' : '';
		
		if($animation != '' && $animation != 'None') { $animation_cls = 'animate'; $data_animation = 'data-animation="'.$animation.'"'; $data_animation_delay = 'data-delay="'.$animation_delay.'"'; }
		else { $animation_cls = $data_animation = $data_animation_delay = ''; }
		
		$icon = '';
		if(!empty($fontawesome_icon)) $icon = '<div class="icon-wrapper"><span class="fa '.esc_attr($fontawesome_icon).'"></span></div>';
		elseif(!empty($stroke_icon)) $icon = '<div class="icon-wrapper"><span class="icon '.esc_attr($stroke_icon).'"></span></div>';
		elseif($custom_icon != '') $icon = '<div class="icon-wrapper"><span><img src="'.$custom_icon.'" title="'.$title.'" alt="'.$title.'" /></span></div>';
		
		if($title_icon != '') $title_icon = '<i class="fa '.$title_icon.'"></i>';
		if($span_text != '') $span_text = '<span>'.$span_text.'</span>';
		
		if($alignright == 'true') $alignright = 'icon-content-right'; else $alignright = '';
		
		if($type == 'type9') {
			$out = '<li class="column dt-sc-one-third">
						<div class="dt-sc-ico-content '.$type.' '.$variation.' '.$animation_cls.' '.$alignright.' '.$alignment.' '.$class.'" '.$data_animation.' '.$data_animation_delay.'>
							<div class="inner-content">
								'.$icon.'
								<h4><a href="'.esc_url($link).'">'.$title_icon.esc_html($title).'</a></h4>
								'.$content.'
							</div>
						</div>
					</li>';
		} else {
			$out = '<div class="dt-sc-ico-content '.$type.' '.$variation.' '.$animation_cls.' '.$alignright.' '.$alignment.' '.$class.'" '.$data_animation.' '.$data_animation_delay.'>
						'.$icon.'
						<h4><a href="'.esc_url($link).'">'.$title_icon.esc_html($title).'</a></h4>';
						if($type == 'type12') {
							$out .= '<a href="'.esc_url($link).'">'.esc_html($readmore_title).'<span class="fa fa-long-arrow-right"></span></a>';
						} else {
							$out .= $span_text.$content;
						}
			$out .= '</div>';
		}
		
		return $out;
	}
	
	function dt_sc_icon_box_wrapper($attrs, $content = null, $shortcodename = "") {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<ul class="dt-sc-icon-content-shape">'.do_shortcode($content).'</ul>';
		return $out;
		
	}
	
	/* Icon Boxes Shortcode End*/

	/* Icon Boxes Colored Shortcode */
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @param string $shortcodename        	
	 * @return string
	 */
	function dt_sc_colored_box($attrs, $content = null, $shortcodename = "") {
		extract ( shortcode_atts ( array ( 'icon' => '', 'title' => '', 'backgroundcolor' => '', 'button_title' => '', 'button_link' => '' ), $attrs ) );
		
		if($backgroundcolor != '') {
			$bgcolor = 'style="background-color:'.$backgroundcolor.'"';
			$icon_bgcolor = 'style="color:'.$backgroundcolor.'; border-color:'.$backgroundcolor.';"';
		} else {
			$bgcolor = $icon_bgcolor = '';
		}
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		if($icon != '') $icon = '<span class="fa '.esc_attr($icon).'" '.$icon_bgcolor.'> </span>';
		
		$out = '<div class="dt-sc-colored-box" '.$bgcolor.'>
					'.$icon.'
					<h5>'.esc_attr($title).'</h5>
					'.$content;
					if($button_title != '') $out .= '<a class="dt-sc-button type7 small" target="_blank" href="'.$button_link.'">'.$button_title.'</a>';
		$out .= '</div>';		
				

		return $out;
	}
	/* Icon Boxes Colored Shortcode End*/


	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_code($attrs, $content = null) {
		$array = array ( '[' => '&#91;', ']' => '&#93;', '/' => '&#47;', '<' => '&#60;', '>' => '&#62;', '<br />' => '&nbsp;');
		$content = strtr ( $content, $array );
		$out = "<pre>{$content}</pre>";
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return mixed
	 */
	function dt_sc_fancy_ol($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'style' => '', 'variation' => '', 'class' => '' ), $attrs ) );
		
		$style = ($style) ? trim ( $style ) : 'decimal';
		$class = ($class) ? trim ( $class ) : '';
		$variation = ($variation) ? ' ' . trim ( $variation ) : '';
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = str_replace ( '<ol>', "<ol class='dt-sc-fancy-list {$variation} {$class} {$style}'>", $content );
		$content = str_replace ( '<li>', '<li><span>', $content );
		$content = str_replace ( '</li>', '</span></li>', $content );
		return $content;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return mixed
	 */
	function dt_sc_fancy_ul($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'style' => '', 'variation' => '', 'class' => ''), $attrs ) );
		$style = ($style) ? trim ( $style ) : '';
		$class = ($class) ? trim ( $class ) : '';
		$variation = ($variation) ? ' ' . trim ( $variation ) : '';
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = str_replace ( '<ul>', "<ul class='dt-sc-fancy-list {$variation} {$class} {$style}'>", $content );
		return $content;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_pricing_table_item($attrs, $content = null) {
		extract ( shortcode_atts ( array (
				'heading' => esc_html__( "Heading", 'dt_plugins' ),
				'price' => '',
				'price_text' => '',
				'note' => '',
				'button_link' => '#',
				'button_text' => esc_html__( 'Buy Service', 'dt_plugins' ),
				'button_size' => 'medium',
				'selected' => 'false',
				'variation' => '',
				'class' => '',
		), $attrs ) );
		
		$selected = ($selected == 'true') ? 'selected' : '';
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = str_replace ( '<ul>', '<ul class="dt-sc-tb-content">', $content );
		$content = str_replace ( '<ol>', '<ul class="dt-sc-tb-content">', $content );
		$content = str_replace ( '</ol>', '</ul>', $content );
		
		$out = '<div class="dt-sc-pr-tb-col '.$selected.' '.$variation.' '.$class.'">
					<div class="dt-sc-tb-header">
						<div class="dt-sc-tb-title">
							<h5> '.$heading.' </h5>
						</div> 
						<div class="dt-sc-price">';
							if($price != '') $out .= '<h2> '.$price.' </h2>';
							if($price_text != '') $out .= '<span> '.$price_text.' </span>';
							if($note != '') $out .= '<p> '.$note.' </p>';
				$out .= '</div> 
					</div>';
					if($button_text != '') {
						$out .= '<div class="dt-sc-buy-now">
									<a class="dt-sc-button type4 '.$button_size.'" href="'.$button_link.'"> <span class="fa fa-gear"></span> '.$button_text.' </a>
								</div>';
					}
			$out .= $content.'
				</div>';		
		
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_progressbar($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'title' => '', 'value' => '55', 'variation' => '', 'animation' => '', 'animation_delay' => ''), $attrs ) );
		
		$animation_cls = $data_animation = $data_delay = '';
		if($animation != '' && $animation != 'None') {
			$animation_cls = 'animate';
			$data_animation = 'data-animation="'.$animation.'"';
			$data_delay = 'data-delay="'.$animation_delay.'"';
		}
		
		$out = '<div class="dt-sc-progress '.$variation.' '.$animation_cls.'" '.$data_animation.' '.$data_delay.'>
					<div data-value="'.$value.'" class="dt-sc-bar">
						<div class="dt-sc-bar-text"> '.$title.' <span> '.$value.'% </span></div>
					 </div>
				</div>';
								
		return $out;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_tab($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'title' => '' ), $attrs ) );
		$out = '<li class="tab_head"><a href="#">' . $title . '</a></li><div class="tabs_content">' . DTCoreShortcodesDefination::dtShortcodeHelper ( $content ) . '</div>';
		return $out;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_tabs_horizontal($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'animation' => '', 'animation_delay' => '' ), $attrs ) );
		
		$animation_cls = $data_animation = $data_delay = '';
		if($animation != '' && $animation != 'None') {
			$animation_cls = 'animate';
			$data_animation = 'data-animation="'.$animation.'"';
			$data_delay = 'data-delay="'.$animation_delay.'"';
		}
		
		preg_match_all("/(.?)\[(dt_sc_tab)\b(.*?)(?:(\/))?\](?:(.+?)\[\/dt_sc_tab\])?(.?)/s", $content, $matches);

		for($i = 0; $i < count($matches[0]); $i++) {
			$matches[3][$i] = shortcode_parse_atts( $matches[3][$i] );
		}
		
		$out = '<ul class="dt-sc-tabs-frame">';
			for($i = 0; $i < count($matches[0]); $i++) {
				$out .= '<li><a href="#">' . $matches[3][$i]['title'] . '</a></li>';
			}
		$out .= '</ul>';
		
		for($i = 0; $i < count($matches[0]); $i++) {
			$out .= '<div class="dt-sc-tabs-frame-content">' . DTCoreShortcodesDefination::dtShortcodeHelper($matches[5][$i]) . '</div>';
		}		
		return '<div class="dt-sc-tabs-container '.$type.' '.$animation_cls.'" '.$data_animation.' '.$data_delay.'>'.$out.'</div>';
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_tabs_vertical($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'animation' => '', 'animation_delay' => '' ), $attrs ) );
		
		$animation_cls = $data_animation = $data_delay = '';
		if($animation != '' && $animation != 'None') {
			$animation_cls = 'animate';
			$data_animation = 'data-animation="'.$animation.'"';
			$data_delay = 'data-delay="'.$animation_delay.'"';
		}
		
		preg_match_all("/(.?)\[(dt_sc_tab)\b(.*?)(?:(\/))?\](?:(.+?)\[\/dt_sc_tab\])/", $content, $matches);
		for($i = 0; $i < count($matches[0]); $i++) {
			$matches[3][$i] = shortcode_parse_atts( $matches[3][$i] );
		}
		
		$out = '<ul class="dt-sc-tabs-vertical-frame">';
		for($i = 0; $i < count($matches[0]); $i++) {
			$out .= '<li><a href="#">' . $matches[3][$i]['title'] . '<span></span></a></li>';
		}
		$out .= "</ul>";

		for($i = 0; $i < count($matches[0]); $i++) {
			$out .= '<div class="dt-sc-tabs-vertical-frame-content">' . DTCoreShortcodesDefination::dtShortcodeHelper($matches[5][$i]) . '</div>';
		}		
		return '<div class="dt-sc-tabs-vertical-container '.$type.' '.$animation_cls.'" '.$data_animation.' '.$data_delay.'>'.$out.'</div>';		
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_testimonial($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'name' => '', 'image' => '', 'cite' => '', 'cite2' => ''), $attrs ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = strip_tags($content);
		
		if($image != '') $image = '<div class="author"><img src="'.$image.'" alt="'.esc_html__('Author', 'dt_plugins').'" title="'.esc_html__('Author', 'dt_plugins').'" /></div>';
		if($name != '') $name = '<p>'.$name.'</p>';
		if($cite != '') {
			$cite = '<span>'.$cite;
			if($cite2 != '') $cite .= ' / '.$cite2;
			$cite .= '</span>';
		}
		
		$out = '<div class="dt-sc-testimonial">
					<blockquote> " <q>'.$content.'</q> " </blockquote>
					<div class="dt-sc-margin20"></div>
					'.$image.'
					<div class="author-detail">
						'.$name.'
						'.$cite.'
					</div>
				</div>';
		
		return $out;
	}
	
	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_testimonial_carousel($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => ''), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = str_replace( '<ul>', '<ul class="dt-sc-testimonial-carousel">', $content );
		
		$out = '<div class="dt-sc-testimonial-wrapper '.$type.'">';
			$out .= $content;
			if($type != 'type4') {
				$out .= 	'<div class="carousel-arrows">	
								<a href="#" class="testimonial-prev"> <span class="fa fa-angle-left"> </span> </a>
								<a href="#" class="testimonial-next"> <span class="fa fa-angle-right"> </span> </a>
							</div>';
			}
		$out .= '</div>';
		
		return $out;
	}

	function dt_sc_title( $attrs,$content = null , $shortcodename = "" ){
		
		extract ( shortcode_atts ( array ( 
			'type' => 'h1',
			'style' => '',
			'span_text' => '',
			'text' => '',
			'link' => '',
			'align' => '',
			'color' => '',
			'bold' => 'false',
			'disable_margin' => 'false',
			'link_class' => '',
			'class' => '',
			), $attrs ) );
		
		$out = '';
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		if($bold == 'true') $content = '<b>'.$content.'</b>';
		if($link != '') {
			if($link_class != '') $link_class = 'class="'.$link_class.'"';
			$content = '<a href="'.$link.'" '.$link_class.'>'.$content.'</a>';
		}
		if($span_text != '') { $span_text = '<span class="wlast">'.$span_text.'</span>'; }
		
		$styles_arr = array();
		if($disable_margin == 'true') { $styles_arr[] = 'margin:0;'; }
		if($color) { $styles_arr[] = 'color:' . $color . ';'; }
		$cssstyle = join('', array_unique( $styles_arr ) );
		$cssstyle = !empty( $cssstyle ) ? ' style="' . $cssstyle . '"': '' ;
		
		if($type == '') { $type = 'h2'; }
		
		if($style == 'border-title') {
			$out .= '<div class="'.$align.' border-title '.$class.'"><'.esc_attr($type).' '.$cssstyle.'>'.$content.$span_text.'</'.esc_attr($type).'></div>';
		} elseif($style == 'border-title2') {
			$out .= '<div class="'.$align.' border-title type2 '.$class.'"><'.esc_attr($type).' '.$cssstyle.'>'.$content.$span_text.'</'.esc_attr($type).'></div>';
		} elseif($style == 'border-title3') {
			$out .= '<div class="'.$align.' border-title type3 '.$class.'"><'.esc_attr($type).' '.$cssstyle.'>'.$content.$span_text.'</'.esc_attr($type).'></div>';
		} elseif($style == 'small-title') {
			$out .= '<'.esc_attr($type).' class="small-title '.$align.' '.$class.'" '.$cssstyle.'>'.$content.'</'.esc_attr($type).'>';
		} elseif($style == 'medium-title') {
			$out .= '<'.esc_attr($type).' class="medium-title '.$align.' '.$class.'" '.$cssstyle.'>'.$content.'</'.esc_attr($type).'>';
		} elseif($style == 'large-title') {
			$out .= '<'.esc_attr($type).' class="large-title '.$align.' '.$class.'" '.$cssstyle.'>'.$content.'</'.esc_attr($type).'>';
		} else {
			$out .= '<'.esc_attr($type).' class="'.$align.' '.$class.'" '.$cssstyle.'>'.$content.'</'.esc_attr($type).'>';
		}
		
		return $out;
			
	}

	function dt_sc_toggle_group($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => '', 'class' => '' ), $attrs ) );
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<div class="dt-sc-toggle-frame-set '.esc_attr($class).' '.esc_attr($type).'">'.$content.'</div>';
		return $out;
	}

	function dt_sc_toggle_frame($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'title' => '' ), $attrs ) );
		
		$out = '<h5 class="dt-sc-toggle"><a href="#">'.$title.'</a></h5>';
		$out .= '<div class="dt-sc-toggle-content" style="display: none;">';
		$out .= '<div class="block">';
		$out .= DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out .= '</div>';
		$out .= '</div>';
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_titled_box($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'title' => '', 'icon' => '', 'type'	=> '', 'variation' => '', 'bgcolor' => '', 'textcolor' => ''), $attrs ) );
		
		$type = (empty($type)) ? 'dt-sc-titled-box' :"dt-sc-$type";
		$variation = ( ( $variation ) && ( empty( $bgcolor ) ) ) ? ' ' . $variation : '';
		$content = DTCoreShortcodesDefination::dtShortcodeHelper( $content );
		
		$styles = array();
		if($bgcolor) $styles[] = 'background-color:' . $bgcolor . ';border-color:' . $bgcolor . ';';
		if($textcolor) $styles[] = 'color:' . $textcolor . ';';
		$style = join('', array_unique( $styles ) );
		$style = !empty( $style ) ? ' style="' . $style . '"': '' ;
		
		if($type == 'dt-sc-titled-box') :
			$icon = ( empty($icon) ) ? "" : "<span class='fa {$icon} '></span>";
			$title = "<h4 class='{$type}-title' {$style}> {$icon} {$title}</h4>";
			$out = "<div class='{$type} {$variation}'>";
			$out .= $title;
			$out .=	"<div class='{$type}-content'>{$content}</div>";
			$out .= "</div>";
		else :
			$content = str_replace('<p>', '', $content);
			$content = str_replace('</p>', '', $content);
			$out = "<div class='{$type}'>{$content}</div>";
		endif;
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_tooltip($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => 'default', 'tooltip' => '', 'position' => 'top', 'href' => '', 'target' => '','bgcolor' => '','textcolor' => ''), $attrs ) );
		
		$class  = " class=' ";
		$class .=  ( $type == "boxed" ) ? "dt-sc-boxed-tooltip" : "";
		$class .= " dt-sc-tooltip-{$position}'";
		
		$href = " href='{$href}' ";
		$title = " title = '{$tooltip}' ";
		$target = empty($target) ? 'target="_blank"' : "target='{$target}' ";
		
		$styles = array();
		if($bgcolor) $styles[] = 'background-color:' . $bgcolor . ';border-color:' . $bgcolor . ';';
		if($textcolor) $styles[] = 'color:' . $textcolor . ';';
		$style = join('', array_unique( $styles ) );
		$style = !empty( $style ) ? ' style="' . $style . '"': '' ;
		$style = ( $type == "boxed" ) ? $style : "";
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper( $content );
		$out = "<a {$href} {$title} {$class} {$style} {$target}>{$content}</a>";
		return $out;
	}

	/**
	 *
	 * @param array $attrs        	
	 * @param string $content        	
	 * @return string
	 */
	function dt_sc_pullquote($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'type' => 'pullquote1', 'align' => '', 'textcolor' => ''	), $attrs ) );
		
		$class = array();
		if( isset($type) )
			$class[] = "dt-sc-{$type}";
			
		if( preg_match( '/left|right|center/', trim( $align ) ) )
			$class[] = 'align' . $align;
			
		$style = ( $textcolor != '' && $textcolor != '#' ) ? ' style="color:' . $textcolor . ';"' : '';
		$class = join( ' ', array_unique( $class ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = "<span class='{$class}' {$style}> {$content} </span>";
		
		return $out;
	}


	/**
	 * [dt_sc_portfolio_item description]
	 * @param  [type] $attrs         [description]
	 * @param  [type] $content       [description]
	 * @param  string $shortcodename [description]
	 * @return [type]                [description]
	 */
	function dt_sc_portfolio_item( $attrs, $content = null, $shortcodename= "" ){
		extract( shortcode_atts( array( 'id' => '', 'portfolio_type' => '' ), $attrs ));
		$out = ''; 
		if( !empty( $id ) ){
			
			$p = get_post( $id );
			if( $p->post_type === "dt_portfolios" ):
				$permalink = get_permalink($id);
				$title = get_the_title($id);
				$portfolio_item_meta = get_post_meta($id,'_portfolio_settings',TRUE);
				$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();

				$out .= '<div class="portfolio-container '.$portfolio_type.'">
							<div class="portfolio portfolio-'.$id.'">
								<figure>';
									$popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.$title;
									if( array_key_exists('items_name', $portfolio_item_meta) ) {
									
										$item =  $portfolio_item_meta['items_name'][0];
										$popup = $portfolio_item_meta['items'][0];
									
										if( "video" === $item ) {
											$items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
											if( !empty($items) ) {
												$out .= '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.$title.'" title="'.$title.'" />';	
											} else {
												$out .= '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.$title.'" width="1170" height="800" alt="'.$title.'" title="'.$title.'" />';
											}
										} else {
											$attachment_id = $portfolio_item_meta['items_id'][0];
											$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
											$out .= '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.$title.'" title="'.$title.'" />';
										}
										
									} else {
										$out .= '<img src="'.esc_attr($popup).'" alt="" />';
									}
							$out .= '<figcaption>
										<div class="fig-content-wrapper">
											<div class="fig-content">
												<h5><a href="'.$permalink.'">'.$title.'</a></h5>'
												.get_the_term_list($id, 'portfolio_entries', '<p>', ', ', '</p>').'    
												<div class="fig-overlay">
													<a class="zoom" href="'.esc_url($popup).'" data-gal="prettyPhoto[gallery]" title="'.$title.'"> <span class="fa fa-plus"> </span> </a>
													<a class="link" href="'.$permalink.'" title="'.$title.'"> <span class="fa fa-link"> </span> </a>
												</div>
											</div>
										</div>  
									</figcaption>
								</figure>
							</div>
						</div>';
				
			else:
				$out .="<p>".esc_html__("There is no portfolio item with id :","dt_plugins").$id."</p>";
			endif;

		} else {
			$out .="<p>".esc_html__("Please give portfolio post id","dt_plugins")."</p>";
		}
		return $out;
	}


	function dt_sc_portfolios( $attrs, $content = null ){
		extract( shortcode_atts( array( 'category_id' => '','column'=>'3','count'=>'-1','show_filter'=>'false','disable_isotope'=>'false','show_ajaxpagination'=>'false', 'portfolio_type' => ''), $attrs ));
		
		$out = '';
		$post_class = '';
		switch ( $column ) {
			case '1': 
				$post_class = 'dt-sc-one-column';
				$post_layout = 'one-column';
				break;
			
			case '2': 
				$post_class = 'dt-sc-one-half';
				$post_layout = 'one-half-column';
				break;
			
			case '3':
				$post_class = 'dt-sc-one-third';
				$post_layout = 'one-third-column';
				break;

			case '4': 
				$post_class = 'dt-sc-one-fourth';
				$post_layout = 'one-fourth-column';
				break;
		}

		$categos = array();
		if($category_id == '') {
			$categories = get_categories('taxonomy=portfolio_entries&hide_empty=1');	
			$terms = array();
			foreach($categories as $cat) {
				$terms[] = $cat->term_id;
			}
		} else {
			$args = array('taxonomy'=>'portfolio_entries','hide_empty'=>1,'include'=>$category_id);
			$categories = get_categories($args);
			$terms = explode(',', $category_id);
		}
		
		if($disable_isotope == 'false') $isotope = 'apply-isotope-portfolio'; else $isotope = '';
		
		if($show_filter == 'true') {
			$post_class .= ' all-sort ';
			$out .= '<div class="sorting-container">
						<a href="#" class="active-sort" title="" data-filter=".all-sort">'.esc_html__('All','dt_plugins').'</a>';
						foreach( $categories as $category ) { 
							$cat_name = str_replace(' ', '-', $category->cat_name);
							$out .= '<a href="#" data-filter=".'.esc_attr($cat_name).'-sort">'.esc_html($category->cat_name).'</a>';
						}
			$out .= '</div>
					<div class="dt-sc-hr-invisible-small"></div>';	
		}
		
		if( is_array($terms) && !empty($terms) ){
			$args = array( 'orderby' => 'ID',
				'order' => 'ASC',
				'paged' => get_query_var( 'paged' ),
				'posts_per_page' => $count,
				'tax_query' => array( array( 'taxonomy'=>'portfolio_entries', 'field'=>'id', 'operator'=>'IN', 'terms'=>$terms ) ) );

				$the_query = new WP_Query($args);
				if($the_query->have_posts()):
					$i = 1;
					$out .= '<div class="portfolio-container '.$isotope.' '.$portfolio_type.'">';
					while($the_query->have_posts()): 
						$the_query->the_post();

						$portfolio_id = get_the_ID();
						$permalink = get_permalink($portfolio_id);
						$title = get_the_title($portfolio_id);

						$portfolio_item_meta = get_post_meta($portfolio_id,'_portfolio_settings',TRUE);
						$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();

						$temp_class = "";
						if($i == 1) $temp_class = $post_class." first"; else $temp_class = $post_class;
						if($i == $column) $i = 1; else $i = $i + 1;

						$sort = '';
						if($show_filter == 'true') {
							$item_categories = get_the_terms( $portfolio_id, 'portfolio_entries' );
							if(is_object($item_categories) || is_array($item_categories)):
								foreach ($item_categories as $category):
									$cat_slug = str_replace(' ', '-', $category->name);
									$sort .= $cat_slug.'-sort ';
								endforeach;
							endif;
						}

						$hover_color = array_key_exists('hover-color', $portfolio_item_meta) ? $portfolio_item_meta['hover-color'] : '';
						 $hover_style = '';
						 
						 if($hover_color != '') {
							 
							$hover_color_opacity = array_key_exists('hover-color-opacity', $portfolio_item_meta) ? $portfolio_item_meta['hover-color-opacity'] : '';
							
							$rgb = painting_hex2rgb($hover_color); 
							$hover_style = "background-color:rgba($rgb[0],$rgb[1],$rgb[2],$hover_color_opacity) !important;";
							
						 }

						
						$out .= '<div class="column portfolio portfolio-'.$portfolio_id.' '.$temp_class.' '.$sort.'">
									<figure>';
										$popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.$title;
										if( array_key_exists('items_name', $portfolio_item_meta) ) {
										
											$item =  $portfolio_item_meta['items_name'][0];
											$popup = $portfolio_item_meta['items'][0];
										
											if( "video" === $item ) {
												$items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
												if( !empty($items) ) {
													$out .= '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.$title.'" title="'.$title.'" />';	
												} else {
													$out .= '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.$title.'" width="1170" height="800" alt="'.$title.'" title="'.$title.'" />';
												}
											} else {
												$attachment_id = $portfolio_item_meta['items_id'][0];
												$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
												$out .= '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.$title.'" title="'.$title.'" />';
											}
											
										} else {
											$out .= '<img src="'.esc_attr($popup).'" alt="" />';
										}
								$out .= '<figcaption style="'.$hover_style.'">
											<div class="fig-content-wrapper">
												<div class="fig-content">
													<h5><a href="'.$permalink.'">'.$title.'</a></h5>'
													.get_the_term_list($portfolio_id, 'portfolio_entries', '<p>', ', ', '</p>').'    
													<div class="fig-overlay">
														<a class="zoom" href="'.esc_url($popup).'" data-gal="prettyPhoto[gallery]" title="'.$title.'"> <span class="fa fa-plus"> </span> </a>
														<a class="link" href="'.$permalink.'" title="'.$title.'"> <span class="fa fa-link"> </span> </a>
													</div>
												</div>
											</div>  
										</figcaption>
									</figure>
								</div>';
						
					endwhile;
					$out .= '</div>';
					
					if($show_ajaxpagination == 'true') {
						$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
						$paged = $paged+1;				
						$out .= '<div class="portfolio-load-more-container">
									<a class="dt-sc-button type7 portfolio-load-more" data-post-per-page="'.esc_attr($count).'" data-page="'.esc_attr($paged).'" data-post-layout="'.esc_attr($post_layout).'" data-taxonomy="'.esc_attr($category_id).'" data-filter="'.esc_attr($show_filter).'" data-portfolio-type="'.esc_attr($portfolio_type).'" >'.esc_html__('Load More', 'dt_plugins').'</a>
								</div>';
					}
				
				endif;
				wp_reset_postdata();
		} else {
			$out .= "<p>".esc_html__("No portfolios in given category","dt_plugins")."</p>";
		}

		return $out;
	}


	function dt_sc_fullwidth_section($attrs, $content = null) {
		extract ( shortcode_atts ( array ( 'videosrc' => '', 'videowidth' => '', 'videoheight' => '', 'backgroundimage' => '', 'backgroundrepeat' => '', 'backgroundposition' => '', 'backgroundattachment' => '', 'backgroundsize' => '', 'backgroundparallax' => '', 'backgroundimagesecondary' => '', 'backgroundrepeatsecondary' => '', 'backgroundpositionsecondary' => '', 'backgroundparallaxsecondary' => '', 'backgroundcolor' => '', 'opacity' => '', 'backgroundcolorsecondary' => '', 'opacitysecondary' => '', 'parallax' => 'no', 'padding' => '', 'textcolor' =>'', 'topbordercolor' =>'', 'bottombordercolor' =>'', 'type' => '', 'gradientvalue' => '', 'gradientvaluesecondary' => '', 'gradientdegree' => '', 'radialgradientposition' => '', 'applywhitecolor' => 'no', 'align' => '', 'disablecontainer' => '', 'responsivecolumn' => 'false', 'responsivealigncenter' => 'false', 'class' =>'' ), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		if($type == 'select') { $type = ''; }

		$first_styles = $second_styles = $third_styles = array();
		$first_parallaxclass = $second_parallaxclass = $third_parallaxclass = $first_class = $second_class = $third_class = $first_attribute = $second_attribute = $third_attribute = '';
		$second_div = $third_div = false;

		if(!empty($backgroundcolor) && !empty($opacity)) { $rgb = painting_hex2rgb($backgroundcolor); $bgcolorfirst = 'rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$opacity.')'; }
		else if(!empty($backgroundcolor)) $bgcolorfirst = $backgroundcolor;
		else $bgcolorfirst = '';
		
		if(!empty($backgroundcolorsecondary) && !empty($opacitysecondary)) { $rgbsecondary = painting_hex2rgb($backgroundcolorsecondary); $bgcolorsecond = 'rgba('.$rgbsecondary[0].','.$rgbsecondary[1].','.$rgbsecondary[2].','.$opacitysecondary.')'; }
		else if(!empty($backgroundcolorsecondary)) $bgcolorsecond = $backgroundcolorsecondary;
		else $bgcolorsecond = '';

		if($bgcolorfirst != '') {
			
			if($bgcolorsecond == '') $bgcolorsecond_var = 'transparent'; else $bgcolorsecond_var = $bgcolorsecond;
			if($gradientvalue != '') { $gradientvalue_radial = $gradientvalue.'%'; $gradientvalue = $gradientvalue.'%'; }
			else $gradientvalue_radial = '0%';
			if($gradientvaluesecondary != '') { $gradientvalue_radial_secondary = $gradientvaluesecondary.'%'; $gradientvaluesecondary = $gradientvaluesecondary.'%'; }
			else { $gradientvalue_radial_secondary = '100%'; $gradientvaluesecondary = $gradientvalue; }
			
			(int) $linear_gradientdegree = (int)90-(int)$gradientdegree;
			
			if($type == 'half-overlay') 
				$backgroundcolor = 'background: linear-gradient(to left, '.$bgcolorsecond_var.' '.$gradientvalue.', '.$bgcolorfirst.' '.$gradientvaluesecondary.'); background:-webkit-linear-gradient(right, '.$bgcolorsecond_var.' '.$gradientvalue.', '.$bgcolorfirst.' '.$gradientvaluesecondary.'); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='.$backgroundcolor.', endColorstr='.$backgroundcolorsecondary.',GradientType=1) \0/IE9;';
			elseif($type == 'half-overlay-top-bottom') 
				$backgroundcolor = 'background:linear-gradient(to bottom, '.$bgcolorfirst.' '.$gradientvalue.', '.$bgcolorsecond_var.' '.$gradientvaluesecondary.'); background:-webkit-linear-gradient(top, '.$bgcolorfirst.' '.$gradientvalue.', '.$bgcolorsecond_var.' '.$gradientvaluesecondary.'); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='.$backgroundcolor.', endColorstr='.$backgroundcolorsecondary.',GradientType=0) \0/IE9;';
			elseif($type == 'diagonal-gradient') 
				$backgroundcolor = 'background:-webkit-linear-gradient('.$linear_gradientdegree.'deg, '.$bgcolorfirst.' '.$gradientvalue.', '.$bgcolorsecond_var.' '.$gradientvaluesecondary.');background:linear-gradient('.$gradientdegree.'deg, '.$bgcolorfirst.' '.$gradientvalue.', '.$bgcolorsecond_var.' '.$gradientvaluesecondary.');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='.$backgroundcolor.', endColorstr='.$backgroundcolorsecondary.',GradientType=1) \0/IE9;';
			elseif($type == 'radial-gradient')
				$backgroundcolor = 'background:-webkit-radial-gradient('.$radialgradientposition.', ellipse cover, '.$bgcolorfirst.' '.$gradientvalue_radial.', '.$bgcolorsecond_var.' '.$gradientvalue_radial_secondary.');background:radial-gradient(ellipse at '.$radialgradientposition.', '.$bgcolorfirst.' '.$gradientvalue_radial.', '.$bgcolorsecond_var.' '.$gradientvalue_radial_secondary.');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='.$backgroundcolor.', endColorstr='.$backgroundcolorsecondary.',GradientType=1) \0/IE9;';
			else 
				$backgroundcolor = 'background-color:'.$bgcolorfirst.';';
			
		}
				
		$backgroundimage = !empty($backgroundimage) ? 'background-image:url('.$backgroundimage.');' : '';
		$backgroundrepeat = !empty($backgroundrepeat) ? 'background-repeat:'.$backgroundrepeat.';' : '';
		$backgroundposition_org = !empty($backgroundposition) ? $backgroundposition : '';
		$backgroundposition = !empty($backgroundposition) ? 'background-position:'.$backgroundposition.';' : '';
		$backgroundattachment = !empty($backgroundattachment) ? 'background-attachment:'.$backgroundattachment.';' : '';
		$backgroundsize = !empty($backgroundsize) ? 'background-size:'.$backgroundsize.'%;' : '';
						
		$backgroundimagesecondary = !empty($backgroundimagesecondary) ? 'background-image:url('.$backgroundimagesecondary.');' : '';
		$backgroundrepeatsecondary = !empty($backgroundrepeatsecondary) ? 'background-repeat:'.$backgroundrepeatsecondary.';' : '';
		$backgroundpositionsecondary_org = !empty($backgroundpositionsecondary) ? $backgroundpositionsecondary : '';
		$backgroundpositionsecondary = !empty($backgroundpositionsecondary) ? 'background-position:'.$backgroundpositionsecondary.';' : '';
		
				
		if($type == 'color-overlay' || $type == 'half-overlay' || $type == 'half-overlay-top-bottom' || $type == 'diagonal-gradient' || $type == 'radial-gradient') {
			
			if(!empty($backgroundimage)) {
				$first_styles[] = $backgroundimage;
				$first_styles[] = $backgroundrepeat;
				$first_styles[] = $backgroundposition;
				$first_styles[] = $backgroundsize;
				$first_class .= ' '.$type;
				if($backgroundparallax === 'yes') {
					$first_parallaxclass = 'dt-sc-parallax';
					$first_styles[] = 'background-attachment:fixed;';
					$first_attribute = 'data-position="'.$backgroundposition_org.'"';
				} else {
					$first_styles[] = $backgroundattachment;
				}
			}
			
			if(empty($first_styles)) {
				$first_class .= ' '.$type;
				$first_styles[] = $backgroundcolor;
			} else { 
				$first_class = '';
				$second_class .= ' '.$type;
				$second_styles[] = $backgroundcolor; 
				$second_div = true; 
			}
			
			if(!empty($backgroundimagesecondary)) {
				if(empty($second_styles)) {
					$second_styles[] = $backgroundimagesecondary;
					$second_styles[] = $backgroundrepeatsecondary;
					$second_styles[] = $backgroundpositionsecondary;
					$second_div = true;
					$first_class = '';
					$second_class .= ' '.$type;
					if($backgroundparallaxsecondary === 'yes') {
						$second_parallaxclass = 'dt-sc-parallax-second';
						$second_styles[] = 'background-attachment:fixed;';
						$second_attribute = 'data-position="'.$backgroundpositionsecondary_org.'"';
					} else {
						$second_styles[] = $backgroundattachment;
					}
				} else {
					$third_styles[] = $backgroundimagesecondary;
					$third_styles[] = $backgroundrepeatsecondary;
					$third_styles[] = $backgroundpositionsecondary;
					$third_div = true;
					$first_class = '';
					$second_class = '';
					$third_class .= ' '.$type;
					if($backgroundparallaxsecondary === 'yes') {
						$third_parallaxclass = 'dt-sc-parallax-second';
						$third_styles[] = 'background-attachment:fixed;';
						$third_attribute = 'data-position="'.$backgroundpositionsecondary_org.'"';
					} else {
						$third_styles[] = $backgroundattachment;
					}
				}
			}
			
		} else {
			
			if(!empty($backgroundimage)) {
				$first_styles[] = $backgroundimage;
				$first_styles[] = $backgroundrepeat;
				$first_styles[] = $backgroundposition;
				$first_styles[] = $backgroundsize;
				if($backgroundparallax === 'yes') {
					$first_parallaxclass = 'dt-sc-parallax';
					$first_styles[] = 'background-attachment:fixed;';
					$first_attribute = 'data-position="'.$backgroundposition_org.'"';
				} else {
					$first_styles[] = $backgroundattachment;
				}
			}
			if(!empty($backgroundcolor)) $first_styles[] = $backgroundcolor;
						
			if(!empty($backgroundimagesecondary)) {
				$second_styles[] = $backgroundimagesecondary;
				$second_styles[] = $backgroundrepeatsecondary;
				$second_styles[] = $backgroundpositionsecondary;
				$second_div = true;
				if($backgroundparallaxsecondary === 'yes') {
					$second_parallaxclass = 'dt-sc-parallax-second';
					$second_styles[] = 'background-attachment:fixed;';
					$second_attribute = 'data-position="'.$backgroundpositionsecondary_org.'"';
				} else {
					$second_styles[] = $backgroundattachment;
				}
			}
			$backgroundcolorsecondary = !empty($backgroundcolorsecondary) ? 'background-color:'.$bgcolorsecond.';' : '';
			if(!empty($backgroundcolorsecondary)) {
				$second_styles[] = $backgroundcolorsecondary;
				$second_div = true;
			}
				
			if($type == 'skin-color-overlay' || $type == 'grey' || $type == 'origin-bottom-image' || $type == 'origin-top-image' || $type == 'half-overlay-bg-content') {
				$second_class .= ' '.$type;
				$second_div = true;
			}
				
		}
				
		if($third_div) {
			$third_styles[] = !empty($padding) ? 'padding:'.$padding.';' : '';
		} else if($second_div) {
			$second_styles[] = !empty($padding) ? 'padding:'.$padding.';' : '';
		} else {
			$first_styles[] = !empty($padding) ? 'padding:'.$padding.';' : '';
		}
		
		$first_styles[] = !empty($textcolor) ? 'color:'.$textcolor.';' : '';
		$first_styles[] = !empty($topbordercolor) ? 'border-top:1px solid '.$topbordercolor.';' : '';
		$first_styles[] = !empty($bottombordercolor) ? 'border-bottom:1px solid '.$bottombordercolor.';' : '';
		
		if($applywhitecolor == 'yes') $first_class .= ' dark-parallax-content';
		
		$first_style = join('', array_unique(array_filter($first_styles)));
		$first_style = !empty($first_style) ? 'style="'.$first_style.'"' : '';
		
		$second_style = join('', array_unique(array_filter($second_styles)));
		$second_style = !empty($second_style) ? 'style="'.$second_style.'"' : '';
		
		$third_style = join('', array_unique(array_filter($third_styles)));
		$third_style = !empty($third_style) ? 'style="'.$third_style.'"' : '';
		
		if($responsivecolumn == 'true') { $class .= ' dt-responsive-column'; }
		if($responsivealigncenter == 'true') { $class .= ' dt-responsive-aligncenter'; }
		
		
		$out = '';
		
		if($videosrc != '') {
			$out .= '<div class="fullwidth-section-video-container">';
						$out .= '<div class="fullwidth-section-video">'.wp_video_shortcode(array('src' => $videosrc, 'width' => $videowidth, 'height' => $videoheight, 'autoplay' => true, 'loop' => true)).'</div>';
		}
				
			$out .= '<div class="full-width-section '.$first_parallaxclass.' '.$first_class.' '.$class.' '.$align.'" '.$first_style.' '.$first_attribute.'>';
				if($second_div) { $out .= '<div class="full-width-section-inner  '.$second_parallaxclass.' '.$second_class.'" '.$second_style.' '.$second_attribute.'>'; }
					if($third_div) { $out .= '<div class="full-width-section-inner-second  '.$third_parallaxclass.' '.$third_class.'" '.$third_style.' '.$third_attribute.'>'; }
						if($type != 'half-overlay-bg-content' && $disablecontainer != 'yes') { $out .= '<div class="container">'; }
								$out .= $content;
						if($type != 'half-overlay-bg-content' && $disablecontainer != 'yes') { $out .= '</div>'; }
					if($third_div) { $out .= '</div>'; }
				if($second_div) { $out .= '</div>'; }
			$out .= '</div>';
		
		if($videosrc != '') {
			$out .= '</div>';
		}
		
		return $out;
	}

	function dt_sc_animation( $attrs, $content = null ){
		extract ( shortcode_atts ( array ( 'effect' => '','delay'=>''), $attrs ) );
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		return "<div class='animate' data-animation='{$effect}' data-delay='{$delay}'>{$content}</div>";
	}


	function dt_sc_post( $attrs, $content = null ) {
		extract(shortcode_atts(array( 'id'=>'1', 'excerpt_length'=>10), $attrs));
		
		$p = get_post($id,'ARRAY_A');
		$link = get_permalink($id);
		$format = get_post_format($id);
		$title = $p['post_title'];
		$author_id = $p['post_author'];

		$out = '';

		$format = get_post_format($id);
		$blog_overlay = '<div class="blog-overlay"><a href="'.$link.'" title="'.$title.'" class="entry_format"></a></div>';

		$excerpt_str = '';
		$excerpt = explode(' ', do_shortcode($p['post_content']), $excerpt_length);
		$excerpt = array_filter($excerpt);
		if (!empty($excerpt)) {
			if (count($excerpt) >= $excerpt_length) {
				array_pop($excerpt);
				$excerpt = implode(" ", $excerpt).'...';
			} else {
				$excerpt = implode(" ", $excerpt);
			}
			$excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
			$excerpt_str = strip_tags($excerpt);	
		}						

		if($title == '') {
			$single_page_link_start = '<a href="'.get_permalink().'">';
			$single_page_link_end = '</a>';
		} else {
			$single_page_link_start = '';
			$single_page_link_end = '';
		}
		
		$post_meta = get_post_meta($id ,'_dt_post_settings',TRUE);
		$post_meta = is_array( $post_meta ) ? $post_meta  : array(); 
		
		$category_color = array_key_exists('categories-variation', $post_meta) ? $post_meta['categories-variation'] : '';

		$out .= '<article class="'.implode(' ',get_post_class(array('blog-post'), $id)).'">
		
					<div class="entry-thumb-meta">';
						if($format === "image" || empty($format) ):
							if( has_post_thumbnail($id) ):
								$out .= '<div class="entry-thumb">
											<a href="'.$link.'" title="'.$title.'">'.get_the_post_thumbnail($id, 'painting-1170x800').'</a>';
											$out .= $blog_overlay;
								$out .= '</div>';
							endif;
						elseif($format === "gallery" && array_key_exists("items", $post_meta)):
							$out .= '<ul class="recent-gallery">';
								foreach ( $post_meta['items'] as $key => $item ) {
									$attachment_id = $post_meta['items_id'][$key];
									$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
									$out .= '<li><img src="'.esc_url($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
								}
							$out .= '</ul>';	
						elseif( $format === "video" && ( array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta) ) ):
							$out .= '<div class="entry-thumb">';
								if( array_key_exists('oembed-url', $post_meta) ):
									$out .= "<div class='dt-video-wrap'>".wp_oembed_get($post_meta['oembed-url']).'</div>';
								elseif( array_key_exists('self-hosted-url', $post_meta) ):
									$out .= "<div class='dt-video-wrap'>".wp_video_shortcode( array('src' => $post_meta['self-hosted-url']) ).'</div>';
								endif;
							$out .= '</div>';
						elseif( $format === "audio" && (array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta)) ):
							$out .= '<div class="entry-thumb">';
								if( array_key_exists('oembed-url', $post_meta) ):
									$out .= wp_oembed_get($post_meta['oembed-url']);
								elseif( array_key_exists('self-hosted-url', $post_meta) ):
									$out .= wp_audio_shortcode( array('src' => $post_meta['self-hosted-url']) );
								endif;
							$out .= '</div>';
						else:
							if( has_post_thumbnail($id) ):
								$out .= '<div class="entry-thumb">
											<a href="'.$link.'" title="'.$title.'">'.get_the_post_thumbnail($id, 'painting-1170x800').'</a>';
											$out .= $blog_overlay;
								$out .= '</div>';
							endif;
						endif;
			$out .= '</div>
					<div class="entry-detail">';
							if(is_sticky()) {
								$out .= '<div class="featured-post"><span class="fa fa-trophy"></span><span class="text">'.esc_html__('Featured','dt_plugins').'</span></div>';
							}
				$out .= '<div class="entry-title">
							<h4><a href="'.$link.'" title="'.$title.'">'.$title.'</a></h4>
						</div>
						<div class="entry-body">
							<p>'.$excerpt_str.'</p>
						</div>
						<div class="entry-meta">
							<div class="category '.$category_color.'">
								'.get_the_category_list(', ', '', $id).'
							</div>
							<div class="date">
								'.$single_page_link_start.get_the_date('d M Y').$single_page_link_end.'
							</div>
							<div class="post-comments">
								<a href="'.get_comments_link($id).'" title="'.$title.'">'.get_comments_number( $id ).' '.esc_html__('Comment', 'dt_plugins').'</a>
							</div>
						</div>
					</div>';
				
		$out .= '</article>';
		
		return $out;
		
	}
		
	function dt_sc_recent_post( $attrs, $content = null ) {
		
		extract( shortcode_atts( array( 'categories'=>'', 'columns'=>'3', 'count'=>'3', 'excerpt_length'=>10, 'grid_layout'=>'false', 'animation' => '', 'animation_delay' => ''), $attrs ));
		
		$out = '';
		$post_class = $container_class = '';
		switch( $columns ) :
			case '1':
				$post_class = 'column dt-sc-one-column';
			break;
		
			case '2':
				$post_class = 'column dt-sc-one-half';
				$container_class = 'apply-isotope';
			break;

			default:
			case '3':
				$post_class = 'column dt-sc-one-third';
				$container_class = 'apply-isotope';
			break;
		endswitch;

		$animation_cls = $data_animation = $data_delay = '';
		if($animation != '' && $animation != 'None') {
			$animation_cls = ' animate';
			$data_animation = 'data-animation="'.$animation.'"';
			$data_delay = 'data-delay="'.$animation_delay.'"';
		}
		$post_class .= $animation_cls;

		if(empty($categories)):
			$rposts = new WP_Query( array( 'posts_per_page' => $count, 'orderby' => 'date', 'post_type'=> 'post' ) );
		else:
			$rposts = new WP_Query( array( 'posts_per_page' => $count, 'orderby' => 'date', 'post_type'=> 'post', 'cat'=>$categories ) );
		endif;

		if ( $rposts->have_posts() ):
			$i = 1; $init = 0;
			if($grid_layout != 'true') { $out .= '<div class="blog-items '.esc_html($container_class).'">'; }
			while( $rposts->have_posts() ):
				$rposts->the_post();

				$the_id = get_the_ID();
				$permalink = get_permalink($the_id);
				$title = get_the_title($the_id);

				$temp_class = "";
				if($i == 1) { 
					$temp_class = $post_class." first";
					if($grid_layout == 'true' && $init != 0) { $out .= '<div class="dt-sc-clear"></div>'; }
				} else $temp_class = $post_class;
				if($i == $columns) $i = 1; else $i = $i + 1;
				$init++;
				
				$format = get_post_format(  $the_id );

				$out .= '<div class="'.$temp_class.'" '.$data_animation.' '.$data_delay.'>';
				$sc = '[dt_sc_post id="'.$the_id.'" excerpt_length="'.$excerpt_length.'" /]';
				$out .= do_shortcode($sc);
				$out .= '</div>';
			endwhile;
			if($grid_layout != 'true') { $out .= '</div>'; }
			wp_reset_postdata();
		endif;
		return $out;
	}
		
	function dt_sc_post_carousel($attrs, $content = null) {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$out = '<div class="blog-carousel-wrapper">
					<div class="blog-carousel">
						'.do_shortcode($content).'
					</div>
					<div class="blog-carousel-arrows">
						<a href="#" class="prev"><span class="fa fa-angle-left"></span></a>
						<a href="#" class="next"><span class="fa fa-angle-right"></span></a>
					</div>';
		$out .= '</div>';
		
		return $out;

	}
		
	function dt_sc_counter( $atts, $content = null ) {
		extract(shortcode_atts(array(
			'title' => 'Title Comes Here',
			'number' => 2000,
			'symbol' => '',
			'fontawesome_icon' => '',
		), $atts));

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$out = '<div class="dt-sc-counter" data-counter="'.$number.'">
					<div class="dt-sc-counter-border">
						<div class="dt-sc-counter-number">'.$number.'</div>';
						if($symbol != '')	$out .= '<span> '.$symbol.' </span>';
			$out .= '</div>';
					if($fontawesome_icon != '') {
						$out .= '<div class="icon">
									<span class="fa '.$fontawesome_icon.'"></span>
								</div>';
					}
			$out .= '<div class="dt-sc-hr-invisible-very-small"></div>
					<h6>'.$title.'</h6>
				</div>';
		
		return $out;
	}
			
	function dt_sc_widgets($attrs, $content = null) {
		extract ( shortcode_atts ( array (
				'widget_name' => '',
				'widget_wpname' => '',
				'widget_wpid' => ''
		), $attrs ) );
		
		if($widget_name != ''):	
			
			foreach($attrs as $key=>$value):
				$instance[$key] = $value;			
			endforeach;
			
			$instance = array_filter($instance);
			
			//Event Widgets
			if($widget_name == 'Tribe__Events__Pro__Countdown_Widget') {
				$eventid = $instance['event_id'];	
				$eventid = explode('|', $eventid);
				$instance['event_ID'] = $eventid[0];
				$instance['event_date'] = $eventid[1];
			}
			
			if($widget_name == 'Tribe__Events__Pro__Venue_Widget') {
				$venueid = $instance['venue_id'];	
				$instance['venue_ID'] = $venueid;
			}

			if(($widget_name == 'Tribe__Events__Pro__Advanced_List_Widget' || $widget_name == 'Tribe__Events__Pro__Mini_Calendar_Widget') && isset($instance['selector'])) {
				$instance['filters'] = '{"tribe_events_cat":["'.$instance['selector'].'"]}';
			}
			
			if(class_exists('Tribe__Events__Pro__Main')) {
				wp_enqueue_style( 'tribe-events-full-pro-calendar-style', Tribe__Events__Pro__Main::instance()->pluginUrl . 'src/resources/css/tribe-events-pro-full.css', array(), apply_filters( 'tribe_events_pro_css_version', Tribe__Events__Pro__Main::VERSION ) );
				wp_enqueue_style( 'widget-calendar-pro-style', Tribe__Events__Pro__Main::instance()->pluginUrl . 'src/resources/css/widget-calendar-full.css', array(), apply_filters( 'tribe_events_pro_css_version', Tribe__Events__Pro__Main::VERSION ) );
			}
			//Event Widgets End
			
			unset($instance['widget_name'], $instance['widget_wpname'], $instance['widget_wpid']);
			
			ob_start();
			the_widget($widget_name, $instance, 'before_widget=<aside id="'.$widget_wpid.'" class="widget '.$widget_wpname.'">&after_widget=</aside>&before_title=<h3 class="widget-title">&after_title=<span class="small-line"> </span></h3>&widget_id='.$widget_wpid);
			$output = ob_get_contents();
			ob_end_clean();
			
			return $output;
							
		endif;

	}

	function dt_sc_doshortcode($attrs, $content = null) {
		extract ( shortcode_atts ( array (
				'width' => '100',
				'animation' => '',
				'animation_delay' => ''
		), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$danimation = !empty( $animation ) ? " data-animation='{$animation}' ": "";
		$ddelay = ( !empty( $animation ) && !empty( $animation_delay )) ? " data-delay='{$animation_delay}' " : "";
		$danimate = !empty( $animation ) ? "animate": "";

		$first = (isset ( $attrs [0] ) && trim ( $attrs [0] == 'first' )) ? 'first' : '';

		$out = '<div class="column '.$danimate.' '.$first.'" style="width:'.$width.'%;" '.$danimation.' '.$ddelay.'>';
		$cont = do_shortcode($content);
		if(isset($cont))
			$out .= $cont;
		else
			$out .= $content;
		$out .= '</div>';
		return $out;
	}

	function dt_sc_resizable($attrs, $content = null) {		
		
		extract ( shortcode_atts ( array ( 'width' => '', 'class' => '', 'bgcolor' => '', 'bgcoloropacity' => '', 'borderradius' => '', 'bgimageurl' => '', 'bgimageposition' => '', 'bgimagerepeat' => '', 'textcolor' => '', 'padding' => '', 'borderwidth' => '', 'borderstyle' => '', 'bordercolor' => '', 'alignment' => '', 'animation' => '', 'animation_delay' => '' ), $attrs ) );
		
		$danimation = $ddelay = $danimate = '';
		if($animation != '' && $animation != 'None') {
			$danimation = 'data-animation="'.$animation.'"';
			$ddelay = 'data-delay="'.$animation_delay.'"';
			$danimate = 'animate';
		}
		
		if($bgcolor != '') {
			if($bgcoloropacity != '') {
				$rgb = painting_hex2rgb($bgcolor); 
				$bgcolor = 'background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$bgcoloropacity.');';
			} else $bgcolor = 'background-color:'.$bgcolor.';';
		}
		if($borderradius != '') { $borderradius = 'border-radius:'.$borderradius.';'; }
		if($bgimageurl != '') { $bgimageurl = 'background-image:url('.$bgimageurl.');'; }
		if($bgimageposition != '') { $bgimageposition = 'background-position:'.$bgimageposition.';'; }
		if($bgimagerepeat != ''){  $bgimagerepeat = 'background-repeat:'.$bgimagerepeat.';'; }
		if($textcolor != '') { $textcolor = 'color:'.$textcolor.';'; }
		if($padding != '') { $padding = 'padding:'.$padding.';'; }
		if($borderwidth != '') { $borderwidth = 'border-width:'.$borderwidth.';'; }
		if($borderstyle != '') { $borderstyle = 'border-style:'.$borderstyle.';'; }
		if($bordercolor != '') { $bordercolor = 'border-color:'.$bordercolor.';'; }
		$style = 'style="width:'.$width.'%; '.$bgcolor.' '.$borderradius.' '.$bgimageurl.' '.$bgimageposition.' '.$bgimagerepeat.' '.$textcolor.' '.$padding.' '.$borderwidth.' '.$borderstyle.' '.$bordercolor.'"';
		
		if($alignment != '') { $alignment = 'text-'.$alignment; }
		
		$first = (isset ( $attrs [0] ) && trim ( $attrs [0] == 'first' )) ? 'first' : '';
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<div class="column '.$class.' '.$danimate.' '.$first.' '.$alignment.'" '.$danimation.' '.$ddelay.' '.$style.'>'.$content.'</div>';
		
		return $out;
		
	}	
				
	function dt_sc_social_links($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'show_tooltip' => 'false',
				'tooltip_position' => 'top',
				'align' => '',
				'class' => '',
				'target' => ''
		), $attrs ) );
				
		$attributes = array();
		
		$sociables =  array('fa-delicious' => 'delicious', 'fa-deviantart' => 'deviantart', 'fa-digg' => 'digg', 'fa-facebook' => 'facebook', 'fa-facebook-square' => 'facebooksquare', 'fa-twitter' => 'twitter', 'fa-google-plus' => 'googleplus', 'fa-google' => 'google', 'fa-weibo' => 'weibo', 'fa-pinterest' => 'pinterest', 'fa-reddit' => 'reddit', 'fa-behance' => 'behance', 'fa-yahoo' => 'yahoo', 'fa-vimeo-square' => 'vimeosquare', 'fa-stumbleupon' => 'stumbleupon', 'fa-vine' => 'vine', 'fa-linkedin' => 'linkedin', 'fa-skype' => 'skype', 'fa-youtube' => 'youtube', 'fa-picture-o' => 'picture', 'fa-dribbble' => 'dribbble', 'fa-flickr' => 'flickr', 'fa-tumblr' => 'tumblr', 'fa-rss' => 'rss', 'fa-instagram' => 'instagram');
		foreach ( $sociables as $sociable ) {
			$attributes [$sociable] = '';
		}

		extract ( shortcode_atts ( $attributes, $attrs ) );
		
		if($tooltip_position == 'left') $position = 'dt-sc-tooltip-left';
		elseif($tooltip_position == 'right') $position = 'dt-sc-tooltip-right';
		elseif($tooltip_position == 'bottom') $position = 'dt-sc-tooltip-bottom';
		else $position = 'dt-sc-tooltip-top';
		
		$s = "";
		foreach ( $sociables as $sociable_key => $sociable ) {
			if($show_tooltip == 'true') $tp_class = 'class="'.$position.' '.$sociable.'"'; else $tp_class = 'class="'.$sociable.'"';
			$s .= empty ( $$sociable ) ? '' : '<li class="'.$sociable.'"><a href="'.$$sociable.'" target="'.$target.'" title="'.$sociable.'" '.$tp_class.'><i class="fa '.$sociable_key.'"></i></a></li>';
		}
											
		$s = ! empty ( $s ) ? '<ul class="dt-sc-social-icons '.$class.'">'.$s.'</ul>' : '';
		
		if($align == 'left') $out = '<div class="alignleft">'.$s.'</div>';
		elseif($align == 'right') $out = '<div class="alignright">'.$s.'</div>';
		elseif($align == 'center') $out = '<div class="aligncenter">'.$s.'</div>';
		else $out = $s;

		return $out;

	}
			
	
	function dt_sc_space($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'space' => 10,
		), $attrs ) );
		
		if(isset($space) && $space != '') $space = 'style="margin:'.$space.'px 0px 0px"'; else $space = '';
		$out = '<div class="dt-sc-space" '.$space.'></div>';
		
		return $out;

	}
	
	function dt_sc_margin($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'margin' => 10,
		), $attrs ) );
		
		$out = '<div class="dt-sc-margin'.$margin.'"></div>';
		
		return $out;

	}
		
	function dt_sc_team($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'type' => '',
				'image' => '',
				'name' => '',
				'role' => '',
				'link' => '#',
		), $attrs ) );
		
		$attributes = array();
		
		$sociables =  array('fa-delicious' => 'delicious', 'fa-deviantart' => 'deviantart', 'fa-digg' => 'digg', 'fa-facebook' => 'facebook', 'fa-facebook-square' => 'facebooksquare', 'fa-twitter' => 'twitter', 'fa-google-plus' => 'googleplus', 'fa-google' => 'google', 'fa-weibo' => 'weibo', 'fa-pinterest' => 'pinterest', 'fa-reddit' => 'reddit', 'fa-behance' => 'behance', 'fa-yahoo' => 'yahoo', 'fa-vimeo-square' => 'vimeosquare', 'fa-stumbleupon' => 'stumbleupon', 'fa-linkedin' => 'linkedin', 'fa-skype' => 'skype', 'fa-youtube' => 'youtube', 'fa-dribbble' => 'dribbble', 'fa-flickr' => 'flickr', 'fa-tumblr' => 'tumblr');
		foreach ( $sociables as $sociable ) {
			$attributes [$sociable] = '';
		}

		extract ( shortcode_atts ( $attributes, $attrs ) );
		
		$s = '';
		foreach ( $sociables as $sociable_key => $sociable ) {
			$s .= empty ( $$sociable ) ? '' : '<li class="'.$sociable.'"><a href="'.$$sociable.'" target="_blank" title="'.$sociable.'"><i class="fa '.$sociable_key.'"></i></a></li>';
		}
											
		$s = ! empty ( $s ) ? '<ul>'.$s.'</ul>' : '';
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		if($image != '') $image = '<div class="image"><img src="'.$image.'" alt="'.esc_html__('Team Image', 'dt_plugins').'" title="'.esc_html__('Team Image', 'dt_plugins').'" /></div>';
		if($name != '') $name = '<h5><a href="'.$link.'">'.$name.'</a></h5>';
		if($type != 'type2' && $role != '') $role = '<h6>'.$role.'</h6>'; else $role = '';
		
		$out = '<div class="dt-sc-team '.$type.'">';
					if($type == 'type3') $out .= '<div class="inner">';
						$out .= $image;
					if($type == 'type3') $out .= '</div>';		
			$out .= '<div class="team-details">
						'.$name.'
						'.$role.'
						'.$content.'
						<div class="dt-sc-social-icons">
							'.$s.'
						</div>
					</div>
				</div>';
				
		return $out;

	}
			
	function dt_sc_team_carousel($attrs, $content = null) {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$out = '<div class="dt-sc-team-carousel-wrapper">
					<div class="dt-sc-team-carousel">
						'.do_shortcode($content).'
					</div>
					<div class="carousel-arrows">
						<a href="#" class="prev"><span class="fa fa-angle-left"></span></a>
						<a href="#" class="next"><span class="fa fa-angle-right"></span></a>
					</div>
				</div>';
		
		return $out;

	}
		
	function dt_sc_image($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'title' => '',
				'src' => '',
				'class' => '',
		), $attrs ) );
		
		$out = '<img class="'.$class.'" src="'.$src.'" alt="'.$title.'" title="'.$title.'" />';
		
		return $out;

	}
	
	function dt_sc_newsletter_section($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'type' => '',
				'title_text1' => '',
				'title_text2' => '',
		), $attrs ) );
		
		$mcapi_key = dttheme_option('general','mailchimp-key');
		$mcapi_listid = dttheme_option('general','mailchimp-listid');
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = strip_tags($content);

		$privacy = $attrs = '';	
		
		if($type == 'type3') {
			
			$out = '<div class="dt-sc-subscribe-wrapper type3">
						<div class="dt-sc-subscribe-container">
							<div class="column dt-sc-one-fourth first">
								<h2> '.$title_text1.' </h2>
							</div>
							<div class="column dt-sc-one-fourth">
								<div class="offer-text">
									<h2>'.$title_text2.'</h2>
								</div>
							</div>
							<div class="column dt-sc-one-half">
								<form method="post" name="frmNewsletter" class="dt-sc-subscribe-frm">
									<input type="email" placeholder="'.esc_html__('Email','dt_plugins').'" name="dt_mc_emailid" id="dt_mc_emailid" required />
									<input type="hidden" name="dt_mc_apikey" id="dt_mc_apikey" value="'.$mcapi_key.'" />
									<input type="hidden" name="dt_mc_listid" id="dt_mc_listid" value="'.$mcapi_listid.'" />
									<input type="submit" value="'.esc_html__('Subscribe', 'dt_plugins').'" name="submit">';
									
			
			$out .= '<p>'.apply_filters('dt_sc_mailchimp_form_elements', $privacy, $attrs ).'</p>';								

			$out .= '</form>
								<div id="ajax_newsletter_msg"></div>
							</div>
						</div>
					</div>';
			
		} else if($type == 'type2') {
			
			$out = '<div class="dt-sc-subscribe-wrapper type2">
						<div class="dt-sc-subscribe-container">
							<div class="column dt-sc-one-half dt-sc-highlight-left no-space first">
								<h2>'.$title_text1.'</h2>
								<p>'.$title_text2.'</p>
							</div>
							<div class="column dt-sc-one-half no-space">
								<form method="post" name="frmNewsletter" class="dt-sc-subscribe-frm">
									<input type="email" placeholder="'.esc_html__('Email','dt_plugins').'" name="dt_mc_emailid" id="dt_mc_emailid" required />
									<input type="hidden" name="dt_mc_apikey" id="dt_mc_apikey" value="'.$mcapi_key.'" />
									<input type="hidden" name="dt_mc_listid" id="dt_mc_listid" value="'.$mcapi_listid.'" />
									<input type="submit" value="'.esc_html__('Subscribe', 'dt_plugins').'" name="submit">';
									
			
			$out .= '<p>'.apply_filters('dt_sc_mailchimp_form_elements', $privacy, $attrs ).'</p>';								

			$out .= '
								</form>
								<div id="ajax_newsletter_msg"></div>
							</div>
						</div>
					</div>';
			
		} else {
			
			$out = '<div class="dt-sc-subscribe-wrapper">
						<div class="dt-sc-subscribe-container">
							<div class="aligncenter border-title">
								<h3> '.$title_text1.' <span class="wlast"> '.$title_text2.' </span></h3>
							</div>
							<div class="dt-sc-margin10"></div>
							<form method="post" name="frmNewsletter" class="dt-sc-subscribe-frm">
								<input type="text" placeholder="'.esc_html__('Name','dt_plugins').'" name="dt_mc_name" id="dt_mc_name" required />
								<input type="email" placeholder="'.esc_html__('Email','dt_plugins').'" name="dt_mc_emailid" id="dt_mc_emailid" required />
								<input type="hidden" name="dt_mc_apikey" id="dt_mc_apikey" value="'.$mcapi_key.'" />
								<input type="hidden" name="dt_mc_listid" id="dt_mc_listid" value="'.$mcapi_listid.'" />
								<input type="submit" value="'.esc_html__('Subscribe', 'dt_plugins').'" name="submit">';
									
			
			$out .= '<p>'.apply_filters('dt_sc_mailchimp_form_elements', $privacy, $attrs ).'</p>';								

			$out .= '
							</form>
							<div id="ajax_newsletter_msg"></div>
						</div>
					</div>';
				
		}
					
		return $out;

	}
				
	function dt_sc_animate_number($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'type' => '',
				'fontawesome_icon' => '',
				'stroke_icon' => '',
				'custom_image' => '',
				'variation' => '',
				'number' => '',
				'title' => '',
		), $attrs ) );
		
		if($type == 'type2' || $type == 'type3') {
			if($fontawesome_icon != '') $icon = '<span class="fa '.$fontawesome_icon.'"></span>';
			elseif($stroke_icon != '') $icon = '<span class="icon '.$stroke_icon.'"></span>';
			elseif($custom_image != '') $icon = '<img src="'.$custom_image.'" title="'.$title.'" alt="'.$title.'" />';
			else $icon = '';
			$icon_wrapper = '<div class="icon-wrapper">
								'.$icon.'
							</div>';	
		} else $icon_wrapper = '';
		
		$out = '<div class="dt-sc-animate-num '.$type.' '.$variation.'">
					'.$icon_wrapper.'
					<div class="dt-sc-num-count" data-value="'.$number.'">'.$number.'</div>
					<h6>'.$title.'</h6>
				</div>';
						
		return $out;		
	
	}
				
	function dt_sc_woo_products($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'column' => 4,
				'posts_per_page' => -1,
				'orderby' => 'date',
				'order' => 'desc',
				'carousel' => 'false',
				'category_ids' => '',
				'class' => '',
		), $attrs ) );
		
		$out = '';
		
		if(class_exists('woocommerce'))	{
			
			if($carousel == 'true') {
				if($column == 2) $shop_column = 'column dt-sc-one-half';
				elseif($column == 3) $shop_column = 'column dt-sc-one-third';
				elseif($column == 4) $shop_column = 'column dt-sc-one-fourth';
				else $shop_column = 'column dt-sc-one-fourth';
			} else {
				if($column == 2) $shop_column = 'product-wrapper product-two-column';
				elseif($column == 3) $shop_column = 'product-wrapper product-three-column';
				elseif($column == 4) $shop_column = 'product-wrapper product-four-column';
				else $shop_column = 'product-wrapper product-four-column';
			}
						
			$args = array(
				'post_type'				=> 'product',
				'post_status'			=> 'publish',
				'posts_per_page' 		=> $posts_per_page,
				'orderby' 				=> $orderby,
				'order' 				=> $order,
			);
	
			if($category_ids != '') {
				$terms = explode(',', $category_ids);
				$args['tax_query'] = array( array( 'taxonomy'=>'product_cat', 'field'=>'id', 'operator'=>'IN', 'terms'=>$terms ) );
			}
	
			$products = new WP_Query($args);
			if($products->have_posts()):
			
				$i = 1;
				if($carousel == 'true') $out .= '<div class="product-carousel-wrapper" data-column="'.$column.'"><div class="products feature-product-carousel">';
				else $out .= '<ul class="products">';
				
				while($products->have_posts()): $products->the_post();
					global $product, $post;
					
					$product_id = $product->id;
					$permalink = get_permalink($product_id);
					$title = get_the_title($product_id);
					
					if($i == $column) { $position_class = 'class="last"'; $i = 0; } else $position_class = '';
					$post_class = get_post_class($shop_column, $product_id);
					$post_class = implode(' ', $post_class);
					
					$featureimg_id = get_post_thumbnail_id($product_id);
					$featureimg_attrs = wp_get_attachment_image_src($featureimg_id, 'shop_catalog');
					
					$attachment_ids = $product->get_gallery_attachment_ids();
					
					if( ! $product->is_in_stock() || in_array( $product->product_type, array('external','grouped','variable') ) ){
						$add_to_cart = '<a href="'. get_permalink() .'" rel="nofollow" data-product_id="'.$product_id.'" class="product_type_'.$product->product_type.'"><span class="fa fa-sliders"></span> '.esc_html__('View Details', 'dt_plugins').'</a>';
					} else {
						$add_to_cart = '<a href="'. apply_filters( 'add_to_cart_url', esc_url( $product->add_to_cart_url() ) ) .'" rel="nofollow" data-product_id="'.$product_id.'" class="add_to_cart_button product_type_'.$product->product_type.'"><span class="fa fa-shopping-cart"></span> '.esc_html__('Add to Cart', 'dt_plugins').'</a>';
					}
					
					if (shortcode_exists('yith_wcwl_add_to_wishlist')) $wishlist = do_shortcode('[yith_wcwl_add_to_wishlist /]');
					else $wishlist = '';
					
					$price_html = $product->get_price_html();
					
					if($carousel == 'true') $out .= '<div class="'.$post_class.'"><div class="product-wrapper">';
					else $out .= '<li '.$position_class.'><div class="'.$post_class.'">';
					
					$out .= '<div class="product-container '.$class.'">
								<a href="'.$permalink.'">';
									if($product->is_featured()) $out .= apply_filters( 'woocommerce_sale_flash', '<div class="featured-tag"><div><i class="fa fa-thumb-tack"></i><span>'.esc_html__( 'Featured', 'dt_plugins' ).'</span></div></div>', $post, $product ); 
									if($product->is_on_sale() and $product->is_in_stock()) $out .= apply_filters('woocommerce_sale_flash', '<span class="onsale"><span>'.esc_html__( 'Sale!', 'dt_plugins' ).'</span></span>', $post, $product);
									elseif(!$product->is_in_stock()) $out .= apply_filters( 'woocommerce_sale_flash', '<span class="out-of-stock"><span>'.esc_html__( 'Out of Stock', 'dt_plugins' ).'</span></span>', $post, $product );
							$out .= '<div class="product-thumb">
										<img src="'.$featureimg_attrs[0].'" alt="'.$title.'" title="'.$title.'" class="primary-image" />';
										if(isset($attachment_ids[0])) {
											$attachmentimg_attrs = wp_get_attachment_image_src($attachment_ids[0], 'shop_catalog');
											$out .= '<img src="'.$attachmentimg_attrs[0].'" alt="'.$title.'" title="'.$title.'" class="secondary-image" />';
										}
							$out .= '</div>
								</a>
								<div class="product-title"> 
									'.$add_to_cart.$wishlist.'
								</div>
							</div>
							<div class="product-details"> 
								<h5> <a href="'.$permalink.'">'.$title.'</a> </h5>
								<span class="price">'.$price_html.'</span>
							</div>';
					
					if($carousel == 'true') $out .= '</div></div>';
					else $out .= '</div></li>';
					
					$i++;
					
				endwhile;
					
				if($carousel == 'true') $out .= '</div>
												<div class="product-carousel">
													<a class="prev" href="#"><span class="fa fa-angle-left"></span> </a>
													<a class="next" href="#"><span class="fa fa-angle-right"></span> </a>
												</div>
											</div>';
				else $out .= '</ul>';
				
			endif;
			wp_reset_postdata();
		
		} else {
			$out .= '<div class="dt-sc-info-box">'.esc_html__('Please install and activate the woocommerce plugin!', 'dt_plugins').'</div>';	
		}
		
		return $out;		
	
	}
	
	function dt_sc_woo_featured_product($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'product_id' => '',
		), $attrs ) );
		
		$out = '';
		
		if(class_exists('woocommerce'))	{
			
			if($product_id != '') {
				
				$args = array(
					'post_type'				=> 'product',
					'post_status'			=> 'publish',
					'p' 					=> $product_id,
				);
		
				$products = new WP_Query($args);
				if($products->have_posts()):
					while($products->have_posts()): $products->the_post();
						global $product;
						
						$product_id = $product->id;
						$permalink = get_permalink($product_id);
						$title = get_the_title($product_id);
						
						$post_class = get_post_class($product_id);
						$post_class = implode(' ', $post_class);
						
						$featureimg_id = get_post_thumbnail_id($product_id);
						$featureimg_attrs = wp_get_attachment_image_src($featureimg_id, 'shop_catalog');
						
						$attachment_ids = $product->get_gallery_attachment_ids();
						
						$add_to_cart = '<a href="'. apply_filters( 'add_to_cart_url', esc_url( $product->add_to_cart_url() ) ) .'" rel="nofollow" data-product_id="'.$product_id.'" class="add_to_cart_button product_type_'.$product->product_type.'"><span class="fa fa-shopping-cart"></span> '.esc_html__('Add to Cart', 'dt_plugins').'</a>';
						
						if (shortcode_exists('yith_wcwl_add_to_wishlist')) $wishlist = do_shortcode('[yith_wcwl_add_to_wishlist /]');
						else $wishlist = '';
						
						$price_html = $product->get_price_html();
						
						$out .= '<div class="products">
									<div class="product-wrapper '.$post_class.'">
										<div class="product-container">
											<a href="'.$permalink.'">
												<div class="product-thumb">
													<img src="'.$featureimg_attrs[0].'" alt="'.$title.'" title="'.$title.'" class="primary-image" />';
													if(isset($attachment_ids[0])) {
														$attachmentimg_attrs = wp_get_attachment_image_src($attachment_ids[0], 'shop_catalog');
														$out .= '<img src="'.$attachmentimg_attrs[0].'" alt="'.$title.'" title="'.$title.'" class="secondary-image" />';
													}
										$out .= '</div>
											</a>
											<div class="product-title"> 
												'.$add_to_cart.$wishlist.'
											</div>
										</div>
										<div class="product-details"> 
											<h5> <a href="'.$permalink.'">'.$title.'</a> </h5>
											<span class="price">'.$price_html.'</span>
										</div>
									</div>
								</div>';
								
					endwhile;
				endif;
				wp_reset_postdata();
					
			} else {
				$out .= '<div class="dt-sc-info-box">'.esc_html__('Please enter product id to display!', 'dt_plugins').'</div>';	
			}
			
		} else {
			$out .= '<div class="dt-sc-info-box">'.esc_html__('Please install and activate the woocommerce plugin!', 'dt_plugins').'</div>';	
		}
		
		return $out;
		
	}
		
	function dt_sc_custom_menus($attrs, $content = null) {

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$out = '<ul class="top-menu">'.$content.'</ul>';
		
		return $out;
	}
	
	function dt_sc_custom_menu_item($attrs, $content = null) {
		extract ( shortcode_atts ( array (
				'fontawesome_icon' => '',
				'span_text' => '',
				'link_text' => '',
				'link' => '#',
				'link_type' => '',
		), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );

		if($fontawesome_icon != '') $fontawesome_icon = '<i class="fa '.$fontawesome_icon.'"></i>';
		$out = '<li>';
			$out .= $fontawesome_icon;
			if($link_text != '') {
				if($link_type == 'mail') $link = 'mailto:'.$link_text;
				$out .= '<a href="'.$link.'" title="'.strtolower($link_text).'">'.$link_text.'</a>';
			} elseif($span_text != '') $out .= '<span>'.$span_text.'</span>';
		$out .= '</li>';
		
		return $out;
	}
	
	function dt_sc_custom_menu_location($attrs, $content = null) {
		extract ( shortcode_atts ( array (
				'title' => '',
				'title_icon' => '',
				'bgimage' => '',
				'title_secondary' => '',
				'phone_icon' => '',
				'phone_text' => '',
				'text' => '',
		), $attrs ) );

		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		$content = strip_tags($content);
		
		$search_text = empty($_GET['s']) ? '' : get_search_query();
		if($bgimage != '') $bgimage = 'style="background:#fff url('.$bgimage.') no-repeat center center"';
		$out = '<li class="location-options"> <i class="fa '.$title_icon.'"></i> <a href="#"> '.$title.' </a> 
					<div class="location-details" '.$bgimage.'>
						<h4><b>'.$title_secondary.'</b></h4>
						<form method="get" class="searchform" action="'.esc_url( home_url('/')).'">
							<input type="text" placeholder="'.esc_html__('Enter Location', 'dt_plugins').'" value="'.esc_attr($search_text).'" name="s" />
							<input type="submit" class="search-button" value="'.esc_html__('Find Us', 'dt_plugins').'">
						</form>
						<p>'.$content.'</p>
						<div class="dt-sc-margin20"></div>';
						if($phone_text != '') $out .= '<h3> <i class="fa '.$phone_icon.'"></i> <b> '.$phone_text.' </b> </h3>';
						if($text != '') $out .= '<h5>'.$text.'</h5>';
			$out .= '</div>
				</li>';
						
		return $out;
	}
	
	function dt_sc_contact_details($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'text' => '',
				'icon' => '',
				'type' => '',
		), $attrs ) );
		
		if(trim($type) == 'email') {
			$out = '<p><i class="fa '.$icon.'"></i><a href="mailto:'.$text.'">'.$text.'</a></p>';
		} elseif(trim($type) == 'web') {
			if (false === strpos($text, '://')) $text2 = 'http://'.$text; else $text2 = $text;
			$out = '<p><i class="fa '.$icon.'"></i><a href="'.$text2.'">'.$text.'</a></p>';
		} else {
			$out = '<p><i class="fa '.$icon.'"></i> '.$text.'</p>';
		}
		
		return $out;

	}
	
	function dt_sc_contact_form_wrapper($attrs, $content = null) {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
		
		$out = '<div class="dt-sc-contact-form-wrapper">'.do_shortcode($content).'</div>';
		
		return $out;

	}
	
	function dt_sc_contact_info($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'icon' => '',
				'text1' => '',
				'text2' => '',
		), $attrs ) );
		
		$out = '<div class="dt-sc-contact-info">';
					if($icon != '') $out .= '<i class="fa '.$icon.'"></i>';
					if($text1 != '') $out .= '<h4> '.$text1.' </h4>';
					if($text2 != '') $out .= '<p> '.$text2.' </p>';
		$out .= '</div>';
		
		return $out;

	}
	
	function dt_sc_support_info($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'icon' => '',
				'title' => '',
				'link' => '',
				'variation' => '',
		), $attrs ) );
		
		$out = '<div class="dt-sc-support-info '.$variation.'">
					<div class="support-icon">
						<i class="fa '.$icon.'"></i>
					</div>
					<h4> <a href="'.$link.'"> '.$title.' </a> </h4>
				</div>';
		
		return $out;

	}

	function dt_sc_search_cart($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'enable_search' => 'true',
				'search_icon' => 'fa-search',
				'enable_cart' => 'false',
				'cart_icon' => 'fa-shopping-cart',
		), $attrs ) );
		
		$out = '<ul class="top-shop-cart">';
			
			if($enable_search == 'true') {
				$search_text = empty($_GET['s']) ? '' : get_search_query();
				$out .= '<li class="search">
							<a href="#" class="show-box"><i class="fa '.$search_icon.'"></i></a>
							<div class="search-form-box" style="display:none;">
								 <form method="get" class="searchform" action="'.esc_url( home_url('/')).'">
									<input name="s" type="text" value="'.esc_attr($search_text).'" class="search-text-box" placeholder="'.esc_html__('Search', 'dt_plugins').'" />
								 </form>
								 <span class="dt-searchform-close"></span>
							 </div>
						</li>';
			}
			
			if($enable_cart == 'true') {
				$out .= '<li class="dt-sc-cart">
							<a href="#"><i class="fa '.$cart_icon.'"></i></a>';
							$out .= '<div class="shopping-cart">';
							if( function_exists( 'is_woocommerce' ) ){
								$woo_cart_list = WC()->cart->get_cart();
								if(!empty($woo_cart_list)) {
									$out .= '<ul class="product_cart_list">';
									foreach($woo_cart_list as $cart_key => $cart_item) {
										$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_key );
										$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_key );
										$product_title = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_key );
										$product_permalink = $_product->get_permalink();
										$thumnail_id = get_post_thumbnail_id( $product_id );
										$thumbnail_attrs = wp_get_attachment_image_src($thumnail_id, 'shop_thumbnail');
										$out .= '<li>
													<a href="'.$product_permalink.'"><img src="'.$thumbnail_attrs[0].'" alt="'.$product_title.'" title="'.$product_title.'" class="primary-image" />'.$product_title.'</a>
													'.apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" title="%s"><span class="remove fa fa-times"></span></a>', esc_url( WC()->cart->get_remove_url( $cart_key ) ), esc_html__( 'Remove this item', 'dt_plugins' ) ), $cart_key ).'
													<div class="product-details">
														'.esc_html__('Quantity', 'dt_plugins').' <span>'.apply_filters( 'woocommerce_cart_item_quantity', $cart_item['quantity'], $cart_key ).'</span>
														<p class="quantity"><span class="amount">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_key ).'</span> '.$_product->get_sku().'</p>
													</div>
												</li>';
									}
									$out .= '</ul>';
									$out .= '<p class="total">'.esc_html__('Total', 'dt_plugins').'<span class="amount">'.WC()->cart->get_cart_subtotal().'</span></p>';
									$checkout_url = WC()->cart->get_checkout_url();
									$cart_url = WC()->cart->get_cart_url();
									$out .= '<p class="buttons"><a href="'.esc_url($checkout_url).'">'.esc_html__('Checkout', 'dt_plugins').'</a><a href="'.esc_url($cart_url).'">'.esc_html__('View Cart', 'dt_plugins').'</a></p>';
								} else {
									$out .= '<p>'.esc_html__('No product(s) in your cart!', 'dt_plugins').'</p>';
								}
								$out .= '</div>';
							}
				$out .= '</li>';
			}
					
		$out .= '</ul>';
						
		return $out;

	}
	
	function dt_sc_popup_video($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'type' => '',
				'video_url' => '',
				'class' => '',
		), $attrs ) );
		
		$out = '<a href="#videoContainer" class="popupVideo"><span class="icon icon-Play"></span></a>
				<div id="videoContainer" class="dtVideoContainer">';
					if($type == 'selfhosted') {
						$out .= '<video width="560" height="320" controls>
									<source src="'.$video_url.'" type="video/mp4"/>
									<source src="'.$video_url.'" type="video/webm"/>
									<source src="'.$video_url.'" type="video/ogg"/>
								</video>';
					} else {
						$out .= wp_oembed_get($video_url, array('width'=>560,'height'=>320));
					}
		$out .= '</div>';
		
		return $out;
	
	}
	
	function dt_sc_map_address_wrapper($attrs, $content = null) {
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );
				
		$out = '<div class="dt-map-address-wrapper">
					<div class="dt-map-address-container">
						'.$content.'
					</div>
				</div>';
		
		return $out;
	
	}
	
	function dt_sc_content_carousel($attrs, $content = null) {
		
		extract ( shortcode_atts ( array (
				'columns' => '',
				'disable_arrows' => '',
				'class' => '',
		), $attrs ) );
		
		$content = DTCoreShortcodesDefination::dtShortcodeHelper ( $content );

		if($columns == 1) { $content_cls = 'dt-sc-one-column'; }
		else if($columns == 2) { $content_cls = 'dt-sc-two-column'; }
		else if($columns == 3) { $content_cls = 'dt-sc-three-column'; }
		else { $content_cls = 'dt-sc-four-column'; }
		
		$content =  str_replace ('<ul>', '', $content);
		$content =  str_replace ('</ul>', '', $content);
		
		$content =  str_replace ('<li>', '<div class="column '.$content_cls.'">', $content);
		$content =  str_replace ('</li>', '</div>', $content);
		
		$out = '<div class="content-carousel-wrapper '.$class.'" data-arrows="'.$disable_arrows.'">
					<div class="content-carousel" data-columns="'.$columns.'">
						'.do_shortcode($content).'
					</div>';
					if($disable_arrows != 'true') {
						$out .= '<div class="content-carousel-arrows">
									<a href="#" class="prev"><span class="fa fa-angle-left"></span></a>
									<a href="#" class="next"><span class="fa fa-angle-right"></span></a>
								</div>';
					}
		$out .= '</div>';
		
		return $out;

	}
	
	function dt_sc_schedule_appointment($attrs, $content = null) {
		
		extract(shortcode_atts(array( 
			'serviceids' => '', 
			'staffids' => '', 
		), $attrs)); 
		
		$out = $privacy = $attrs = '';
		
		if(class_exists('DTAppointmentAddon')) {
			
			$url = painting_get_page_permalink_by_its_template('tpl-appointment.php');
			$url = isset($url) ? $url : '';
			
			if($url != '') {
				
				$out .= '<form class="dt-sc-appointment-contactdetails-form" name="appointment-contactdetails-form" method="post" action="'.$url.'">';
				
				$out .= '<div class="column dt-sc-one-half first"><input type="text" id="firstname" name="firstname" value="" placeholder="'.esc_html__('First Name', 'dt_plugins').'" required /></div>';
				$out .= '<div class="column dt-sc-one-half"><input type="text" id="lastname" name="lastname" value="" placeholder="'.esc_html__('Last Name', 'dt_plugins').'" required /></div>';
				
				$out .= '<div class="column dt-sc-one-half first"><input type="text" id="phone" name="phone" value="" placeholder="'.esc_html__('Phone', 'dt_plugins').'" required /></div>';
				$out .= '<div class="column dt-sc-one-half"><input type="text" id="emailid" name="emailid" value="" placeholder="'.esc_html__('Email', 'dt_plugins').'" required /></div>';
				
				$out .= '<div class="column dt-sc-one-column first"><textarea id="address" name="address" placeholder="'.esc_html__('Address', 'dt_plugins').'" required></textarea></div>';

				$out .= '<div class="column dt-sc-one-column">'.apply_filters('dt_sc_reservation_form_elements', $privacy, $attrs ).'</div>';
				
				$out .= '<div class="dt-sc-margin10"></div>
						<input class="fullwidth" value="'.esc_html__('Next', 'dt_plugins').'" type="submit" />';



				$out .= '<input type="hidden" id="staffids" name="staffids" value="'.$staffids.'" />
						<input type="hidden" id="serviceids" name="serviceids" value="'.$serviceids.'" />';

				
									
				$out .= '</form>';
				
			} else {
				$out .= '<div class="dt-sc-info-box">'.esc_html__('Please create appointment template page in order to make this shortcode work properly!', 'dt_plugins').'</div>';		
			}
			
		} else {
			$out .= '<div class="dt-sc-info-box">'.esc_html__('Please install and activate the BuddhaThemes Appointment Addon!', 'dt_plugins').'</div>';		
		}
		
		return $out;		
	
	}

	/**
	 * privacy policy link
	 * @return link
	 */
	function dt_sc_privacy_policy_link( $attrs = array() , $content = "") {	

		$page_id = get_option('wp_page_for_privacy_policy');
		$url	 = get_permalink($page_id);
		$content = !empty($content) ?  $content : get_the_title($page_id);
		$link	 = "<a href='{$url}'>{$content}</a>";

		return $link;
	}

	function dt_sc_privacy_disable_google_tracking( $attrs = array() , $content = "") {	
		$content = !empty($content) ?  $content : __('Click to enable/disable google analytics tracking.', 'dt_plugins');
		$cookie  = "dtPrivacyGoogleTrackingDisabled";
		
		$checked = ' checked="checked"';
		if( isset( $_COOKIE[$cookie] ) )
			$checked = '';

		$out = '<div class="dt-toggle-switch">';
			$out .= '<label>';
				$out .= '<input type="checkbox" '.$checked.' id="'.$cookie.'" name="'.$cookie.'" class="'.$cookie.'">';
				$out .= '<span>'.$content.'</span>';
			$out .= '</label>';
		$out .= '</div>';

		return $out;
	}

	function dt_sc_privacy_disable_google_webfonts( $attrs = array() , $content = "") {
		$content = !empty($content) ?  $content : __('Click to enable/disable google webfonts.', 'dt_plugins');
		$cookie  = "dtPrivacyGoogleWebfontsDisabled";

		$checked = ' checked="checked"';
		if( isset( $_COOKIE[$cookie] ) )
			$checked = '';

		$out = '<div class="dt-toggle-switch">';
			$out .= '<label>';
				$out .= '<input type="checkbox" '.$checked.' id="'.$cookie.'" name="'.$cookie.'" class="'.$cookie.'">';
				$out .= '<span>'.$content.'</span>';
			$out .= '</label>';
		$out .= '</div>';

		return $out;
	}

	function dt_sc_privacy_disable_google_maps( $attrs = array() , $content = "") {	
		$content = !empty($content) ?  $content : __('Click to enable/disable google maps.', 'dt_plugins');
		$cookie  = "dtPrivacyGoogleMapsDisabled";

		$checked = ' checked="checked"';
		if( isset( $_COOKIE[$cookie] ) )
			$checked = '';

		$out = '<div class="dt-toggle-switch">';
			$out .= '<label>';
				$out .= '<input type="checkbox" '.$checked.' id="'.$cookie.'" name="'.$cookie.'" class="'.$cookie.'">';
				$out .= '<span>'.$content.'</span>';
			$out .= '</label>';
		$out .= '</div>';

		return $out;
	}

	function dt_sc_privacy_disable_video_embeds( $attrs = array() , $content = "") {	
		$content = !empty($content) ?  $content : __('Click to enable/disable video embeds.', 'dt_plugins');
		$cookie  = "dtPrivacyVideoEmbedsDisabled";

		$checked = ' checked="checked"';
		if( isset( $_COOKIE[$cookie] ) )
			$checked = '';

		$out = '<div class="dt-toggle-switch">';
			$out .= '<label>';
				$out .= '<input type="checkbox" '.$checked.' id="'.$cookie.'" name="'.$cookie.'" class="'.$cookie.'">';
				$out .= '<span>'.$content.'</span>';
			$out .= '</label>';
		$out .= '</div>';

		return $out;
	}

			
}

new DTCoreShortcodesDefination();?>