<?php get_header();?>
<?php 

$page_layout =  painting_option('pageoptions','notfound-page-layout');
if($GLOBALS['force_enable'] == true) {
	$page_layout = painting_option('general', 'global-page-layout');
	$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
}

$show_sidebar = false;
$sidebar_class = $sidebar_id = "";

switch ( $page_layout ) {
	case 'with-left-sidebar':
		$page_class = "page-with-sidebar with-left-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-left-sidebar";
		$sidebar_id = "left";
	break;

	case 'with-right-sidebar':
		$page_class = "page-with-sidebar with-right-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-right-sidebar";
		$sidebar_id = "right";
	break;

	case 'content-full-width':
	default:
		$page_class = "content-full-width";
	break;
}

?>

<!-- ** Primary Section ** -->
<section id="primary" class="<?php echo esc_attr($page_class); ?>">
    <div class="error-info">
        <?php 
		if(painting_option('pageoptions','enable-404message') == 'true') {
			echo do_shortcode(stripcslashes(painting_option('pageoptions','custom404-message')));
		} else {
			echo '<h2>'.esc_html__('404 - Page Not Found', 'painting').'</h2><h3>'.esc_html__('The Page you are looking for is not found or does not exist', 'painting').'</h3>';
			echo '<a href="'.esc_url(home_url('/')).'" title="'.esc_html__('Back to Home','painting').'" class="dt-sc-button small type7">'.esc_html__('Back to Home','painting').'</a>';
			echo '<div class="dt-sc-hr-invisible"></div>';
		}
		?>
        
    </div>
</section><!-- ** Primary Section End ** -->
    
<?php if ( $show_sidebar ): ?>
	<!-- Secondary Sidebar -->
	<section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class); ?>"><?php get_sidebar($sidebar_id); ?></section>
	<!-- Secondary Sidebar End -->
<?php endif; ?>

<?php get_footer(); ?>