jQuery.noConflict();
jQuery(document).ready(function($){
	
	"use strict";
	
	var isMobile = (navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)) || (navigator.userAgent.match(/iPad/i)) || (navigator.userAgent.match(/Android/i)) || (navigator.userAgent.match(/Blackberry/i)) || (navigator.userAgent.match(/Windows Phone/i)) ? true : false;
	var currentWidth = window.innerWidth || document.documentElement.clientWidth;
	var isMacLike = navigator.platform.match(/(Mac|iPhone|iPod|iPad)/i)?true:false;
	var $wooIsotope = mytheme_urls.wooIsotope;
		
	// Prevents Page Jumping On Click
	$('a[href="#"]').click(function(e) {
		e.preventDefault();
	});
		
	// Preloader
	var $preloader = mytheme_urls.preloader;
	if($preloader == 'enable') {
		Pace.on("done", function(){
			$(".loader-wrapper").fadeOut(500);
			$(".pace").remove();
		});
	}
	
	// Nice Scroll
	var $nicescroll = mytheme_urls.nicescroll;
	if( $nicescroll === "enable" && !isMacLike ) {
		$("html").niceScroll({zindex:99999,cursorborder:"1px solid #424242"});
	}
	
	/* Mega Menu */
	megaMenu();
	function megaMenu() {
		var screenWidth = $(document).width(),
		containerWidth = $(".header .container").width(),
		containerMinuScreen = (screenWidth - containerWidth)/2;
		if( containerWidth == screenWidth ){

			$("li.menu-item-megamenu-parent .megamenu-child-container").each(function(){

				var ParentLeftPosition = $(this).parent("li.menu-item-megamenu-parent").offset().left,
				MegaMenuChildContainerWidth = $(this).width();

				if( (ParentLeftPosition + MegaMenuChildContainerWidth) > screenWidth ){
					var SwMinuOffset = screenWidth - ParentLeftPosition;
					var marginFromLeft = MegaMenuChildContainerWidth - SwMinuOffset;
					var marginFromLeftActual = (marginFromLeft) + 25;
					var marginLeftFromScreen = "-"+marginFromLeftActual+"px";
					$(this).css('left',marginLeftFromScreen);
				}

			});
		} else {

			$("li.menu-item-megamenu-parent .megamenu-child-container").each(function(){
				var ParentLeftPosition = $(this).parent("li.menu-item-megamenu-parent").offset().left,
				MegaMenuChildContainerWidth = $(this).width();

				if( (ParentLeftPosition + MegaMenuChildContainerWidth) > containerWidth ){
					var marginFromLeft = ( ParentLeftPosition + MegaMenuChildContainerWidth ) - screenWidth;
					var marginLeftFromContainer = containerMinuScreen + marginFromLeft + 20;

					if( MegaMenuChildContainerWidth > containerWidth ){
						var MegaMinuContainer	= ( (MegaMenuChildContainerWidth - containerWidth)/2 ) + 10;
						var marginLeftFromContainerVal = marginLeftFromContainer - MegaMinuContainer;
						marginLeftFromContainerVal = "-"+marginLeftFromContainerVal+"px";
						$(this).css('left',marginLeftFromContainerVal);
					} else {
						marginLeftFromContainer = "-"+marginLeftFromContainer+"px";
						$(this).css('left',marginLeftFromContainer);
					}
				}

			});
		}
	}
	
	//Menu Navigation
	$("#dt-menu-toggle").on('click', function( event ){
		event.preventDefault();
		var $menu;
		$menu = $("nav#main-menu").find("ul.menu:first, ul.menu.right-nav:first");
		$menu.slideToggle(function(){
			$menu.css('overflow' , 'visible');
			$menu.toggleClass('menu-toggle-open');
		});
	});
	
	$(".dt-menu-expand").on('click', function(event){
		if( $(this).hasClass("dt-mean-clicked") ){
			$(this).text("+");
			if( $(this).prev('ul').length ) {
				$(this).prev('ul').slideUp(400);
			} else {
				$(this).prev('.megamenu-child-container').find('ul:first').slideUp(600);
			}
		} else {
			$(this).text("-");
			if( $(this).prev('ul').length ) {
				$(this).prev('ul').slideDown(400);
			} else{
				$(this).prev('.megamenu-child-container').find('ul:first').slideDown(2000);
			}
		}
		
		$(this).toggleClass("dt-mean-clicked");
		return false;
	});
	
	// Sticky Header
	if(mytheme_urls.stickynav == 'enable' && !isMobile && currentWidth > 767) {
		$("#header-wrapper").sticky({ topSpacing: 0 });
		var headerH = $('#header-animate').height();
		$(document).bind('ready scroll', function() {
			var docScroll = $(document).scrollTop();
			if(docScroll >= headerH) {
				if (!$('#header-animate').hasClass('header-animate')) {
					$('#header-animate').addClass('header-animate').css({ top: '-155px' }).stop().animate({ top: 0 }, 500);
				}
			} else {
				$('#header-animate').removeClass('header-animate').removeAttr('style');
			}
		});
	}
	
	//NEWSLETTER AJAX SUBMIT...
	$('form[name="frmNewsletter"]').on('submit', function () {
		
		var $this = $(this); 
		var $mc_email = $this.find('#dt_mc_emailid').val(),
			$mc_apikey = $this.find('#dt_mc_apikey').val(),
			$mc_listid = $this.find('#dt_mc_listid').val(),
			$mc_name = $this.find('#dt_mc_name').val(),
			$mc_privacy = $this.find('#dt_mc_privacy').val();

		$.ajax({
			type: "POST",
			url: mytheme_urls.ajaxurl,
			data:
			{
				action: 'painting_mailchimp_subscribe',
				mc_name: $mc_name,
				mc_email: $mc_email,
				mc_apikey: $mc_apikey,
				mc_listid: $mc_listid
			},
			success: function (response) {
				$this.parent().find('#ajax_newsletter_msg').html(response);
				$this.parent().find('#ajax_newsletter_msg').slideDown('slow');
				if (response.match('success') != null) $this.slideUp('slow');
			}
		});
		
		return false;
		
    });
	
	// Script For Search Enable / Disable
	if($(".show-box").length) {
	   $(".show-box").parent().find('.search-form-box').fadeIn( 100 ).addClass('hidden').fadeOut( 100 );
	   $(".show-box").click( function() {
		   if($(this).parent().find('.search-form-box').hasClass('hidden')) 
		   	$(this).parent().find('.search-form-box').removeClass('hidden').fadeIn( 1000 );
		   else 
		   	$(this).parent().find('.search-form-box').addClass('hidden').fadeOut( 1000 );
	   });
	}	

	$(document).click(function(ev){

		var myID = ev.target.id,
			myClass = ev.target.className;
		
		if(myClass !='fa fa-search' && myClass !='show-box' && myClass !='search-text-box' && myID !='search-box'){
			$( '.search-form-box' ).addClass('hidden').fadeOut( 600 );
		}
		
	});
	
	// For Blog Videos
	$("div.dt-video-wrap").fitVids();
	$('.blog-post .wp-video').css('width', '100%');
	$('.wp-video-shortcode').css('width', '100%');
	$('.wp-video-shortcode').css('height', '100%');
		
	$('.portfolio-load-more').css({"cursor":"pointer"});
	$('.portfolio-load-more').on('click', function(){
		
		if(!$(this).hasClass('disable_click')) {
			var postperpage = $(this).attr('data-post-per-page'),
				page = $(this).attr('data-page'),
				postlayout = $(this).attr('data-post-layout'),
				filter = $(this).attr('data-filter'),
				tax = $(this).attr('data-taxonomy'),
				portfoliotype = $(this).attr('data-portfolio-type'),
				more_text = $(this).html();
				
			$.ajax({
				type: "POST",
				url : mytheme_urls.ajaxurl,
				data:
				{
					action: "painting_ajax_load_portfolio_posts",
					postperpage: postperpage,
					page: page,
					postlayout: postlayout,
					filter: filter,
					tax: tax,
					portfoliotype: portfoliotype
				},
				beforeSend: function(){
					$('.portfolio-load-more').html('Loading...');
				},
				error: function (xhr, status, error) {
					$('.portfolio-load-more').html('No More Posts to Load!');
				},
				success: function (response) {
					if(response == 'NoData') {
						$('.portfolio-load-more').html('No More Posts to Load!');
						$('.portfolio-load-more').addClass('disable_click');
						$('.portfolio-load-more').css({"cursor":"default"});
					} else {
						$('.portfolio-container').append(response);
						page = parseInt(page, 10)+1;
						$('.portfolio-load-more').attr('data-page', page)
						$('.portfolio-container').isotope( 'reloadItems' ).isotope();
						$(window).trigger( 'resize' );	
						$('.portfolio-load-more').html(more_text);
						if($(".portfolio").length) {
							$(".portfolio a[data-gal^='prettyPhoto']").prettyPhoto({hook:'data-gal', animation_speed:'normal',theme:'light_square',slideshow:3000, autoplay_slideshow: false,social_tools: false,deeplinking:false});		
						}
					}
				},
			});
			//Isotope relayout...
			setTimeout(function() {
				$('.portfolio-container').isotope('reLayout');
			}, 3000);
			
		}
		
	});
		
	// Gallery Slider

	$(".recent-gallery").each( function () {

		if (( $(".recent-gallery") . length) && ( $(".recent-gallery li") . length > 1) ) {
		$(this).bxSlider({ auto:false, useCSS:false, pager:'', autoHover:true, adaptiveHeight:true });
		}
	
	});


	/// PrettyPhoto For Portfolio
	if($(".portfolio").length) {
		$(".portfolio a[data-gal^='prettyPhoto']").prettyPhoto({hook:'data-gal', animation_speed:'normal',theme:'light_square',slideshow:3000, autoplay_slideshow: false,social_tools: false,deeplinking:false});		
	}
	
	//Smart Resize Start
	$(window).smartresize(function(){
		
		$("ul.menu").removeAttr("style");		
				
		// Shop Page Isotope
		if($wooIsotope == 'true') {
			if( $(".woocommerce-isotope").length ){
				if($('#primary').hasClass('page-with-sidebar')) {
					if($(".woocommerce-isotope").parents('.column').length > 0) { var $gwidth = 10; }
					else { var $gwidth = 18; }
				} else {
					if($(".woocommerce-isotope").parents('.column').length > 0) { var $gwidth = 16; }
					else { var $gwidth = 22; }
				}
				$(".woocommerce-isotope").each(function(){
					$(this).isotope({itemSelector : '.product-wrapper',transformsEnabled:false,masonry: { gutterWidth: $gwidth} });
				});
			}
		}
		
		// Blog Template Isotope
		if( $(".apply-isotope").length ){
			$(".apply-isotope").each(function(){
				if($('#primary').hasClass('page-with-sidebar')) var $blog_gwidth = 18; else var $blog_gwidth = 25;
				$(this).isotope({itemSelector : '.column',transformsEnabled:false,masonry: { gutterWidth: $blog_gwidth} });
			});
		}
		
		// Mega Menu
		megaMenu();
		
	});
	
	//Window Load Start
	$(window).on('load', function(){
		
		// Shop Page Isotope
		if($wooIsotope == 'true') {
			if( $(".woocommerce-isotope").length ){
				if($('#primary').hasClass('page-with-sidebar')) {
					if($(".woocommerce-isotope").parents('.column').length > 0) { var $gwidth = 10; }
					else { var $gwidth = 18; }
				} else {
					if($(".woocommerce-isotope").parents('.column').length > 0) { var $gwidth = 16; }
					else { var $gwidth = 22; }
				}
				$(".woocommerce-isotope").each(function(){
					$(this).isotope({itemSelector : '.product-wrapper',transformsEnabled:false,masonry: { gutterWidth: $gwidth} });
				});
			}
		}
		
		// Blog Template Isotope
		if( $(".apply-isotope").length ){
			$(".apply-isotope").each(function(){
				if($('#primary').hasClass('page-with-sidebar')) var $blog_gwidth = 18; else var $blog_gwidth = 25;
				$(this).isotope({itemSelector : '.column',transformsEnabled:false,masonry: { gutterWidth: $blog_gwidth} });
			});
		}
		
		// Portfolio Template isotope
		var $container = $('.apply-isotope-portfolio');
		if( $container.length) {
			$(window).smartresize(function(){
				$container.css({overflow:'hidden'}).isotope({itemSelector : '.column',masonry: { gutterWidth: 0 } });
			});
			
			$container.isotope({
			  filter: '*',
			  masonry: { gutterWidth: 0 },
			  animationOptions: { duration: 750, easing: 'linear', queue: false  }
			});
		}
				
		if($("div.sorting-container").length){
			$("div.sorting-container a").click(function(){
				$("div.sorting-container a").removeClass("active-sort");
				var selector = $(this).attr('data-filter');
				$(this).addClass("active-sort");
				$container.isotope({
					filter: selector,
					masonry: { gutterWidth:0 },
					animationOptions: { duration:750, easing: 'linear',  queue: false }
				});
			return false;	
			});
		}
		
		// Portfolio Carousel
		if(jQuery('.portfolio-carousel').length) {
			jQuery('.portfolio-carousel').carouFredSel({
				responsive: true,
				auto: false,
				width: '100%',
				height: 'variable',
				prev: '.portfolio-prev',
				next: '.portfolio-next',
				scroll: 1,
				swipe: {onMouse: true, onTouch: true},
				items: { 
				width: $(this).find('.column.no-space').width(),
				height: 'variable',
				visible: {
				  min: 1,
				  max: 3 }
				}
			});
		}
		
		// Mega Menu
		megaMenu();
		
	});
	
	// Goto Top
	$().UItoTop({ easingType: 'easeOutQuart' });
	
	// Shop Single Page Add To Cart
	$('.plus').on('click', function(e){
		e.preventDefault();
		var currentVal = parseInt($(this).parents('.quantity').find('.input-text').val(), 10);
		if (!isNaN(currentVal)) {
			$(this).parents('.quantity').find('.input-text').val(currentVal + 1);
		} else {
			$(this).parents('.quantity').find('.input-text').val(0);
		}
	});

	$(".minus").on('click', function(e) {
		e.preventDefault();
		var currentVal = parseInt($(this).parents('.quantity').find('.input-text').val(), 10);
		if (!isNaN(currentVal) && currentVal > 0) {
			$(this).parents('.quantity').find('.input-text').val(currentVal - 1);
		} else {
			$(this).parents('.quantity').find('.input-text').val(0);
		}
	});
	
	// Adding extra Div around select input type
	$("select").each(function(){
		if($(this).css('display') != 'none') {
			$(this).wrap( '<div class="selection-box"></div>' );
		}
	});
	
});