jQuery(document).ready(function($){

	"use strict";
	var $picker_container = jQuery("div.dt-style-picker-wrapper"),
		$theme_url = mytheme_urls.theme_base_url,
		$rtl = mytheme_urls.isRTL,
		$patterns_url = $theme_url+"/images/patterns/";
  
	if($rtl == '1') {
  
		if ( $.cookie('painting-control-open') === '1' ) {
			$picker_container.animate({right: -230});
			$('a.style-picker-ico').addClass('control-open');
		} else {
			$picker_container.animate( { right: 0 } );
			$('a.style-picker-ico').removeClass('control-open');
		}
  
	} else {
  
		if ( $.cookie('painting-control-open') === '1' ) {
			$picker_container.animate({left: -230});
			$('a.style-picker-ico').addClass('control-open');
		} else {
			$picker_container.animate( { left: 0 } );
			$('a.style-picker-ico').removeClass('control-open');
		}

	}
	
	if($.cookie("painting_layout") === "boxed"){
	
		$("ul.layout-picker li a").removeAttr("class");
		$("ul.layout-picker li a[id='"+$.cookie("painting_layout")+"']").addClass("selected");
		
		$("div#pattern-holder").removeAttr("class");
		$('body').addClass('boxed');
		if($.cookie("painting_pattern")) {
			var $i = $.cookie("painting_pattern");
			var $img = $patterns_url+$i;
			$('body').css('background-image', 'url('+$img+')');
		} else {
			var $img = $patterns_url+'pattern1.jpeg';
			$('body').css('background-image', 'url('+$img+')');
		}
	
	}
  	// Applying Cookies End
	
	// Picker On / Off
	$("a.style-picker-ico").click(function(e){
		
		var $this = $(this);	
		if($rtl == '1') {
		
			if($this.hasClass('control-open')){
				$picker_container.animate({right: 0},function(){$this.removeClass('control-open');});
				$.cookie('painting-control-open', 1, { path: '/' });	
			}else{
				$picker_container.animate({right: -230},function(){$this.addClass('control-open');});
				$.cookie('painting-control-open', 0, { path: '/' });
			}
		
		} else {
		
			if($this.hasClass('control-open')){
				$picker_container.animate({left: 0},function(){$this.removeClass('control-open');});
				$.cookie('painting-control-open', 1, { path: '/' });	
			}else{
				$picker_container.animate({left: -230},function(){$this.addClass('control-open');});
				$.cookie('painting-control-open', 0, { path: '/' });
			}
		
		}
		e.preventDefault();
	
	});
	// Picker On / Off End

	//Layout Picker
	$("ul.layout-picker a").click(function(e){
		
		var $this = $(this);
		
		$("ul.layout-picker a").removeAttr("class");
		$this.addClass("selected");
		$.cookie("painting_layout", $this.attr("id"), { path: '/' });
		
		if( $.cookie("painting_layout") === "boxed") {
			$("body").addClass("boxed");
			$("div#pattern-holder").slideDown();
			if( $.cookie("painting_pattern") == null ){
				$("ul.pattern-picker a:first").addClass('selected');
				$.cookie("painting_pattern","pattern1.jpg",{ path: '/' });
				$('body').css('background-image', 'url('+$patterns_url+'pattern1.jpg)');
			} else {
				$img = $patterns_url+$.cookie("painting_pattern");
				$('body').css('background-image', 'url('+$img+')');
			}
		} else {
			$("body").removeAttr("style").removeClass("boxed");
			$("div#pattern-holder").slideUp();
			$("ul.pattern-picker a").removeAttr("class");
		}
		
		window.location.href = location.href;
		e.preventDefault();
		
	});
	// Layout Picker End

	// Pattern Picker
	$("ul.pattern-picker a").click(function(e){
	
		if($.cookie("painting_layout") === "boxed"){
			var $this = $(this);
			$("ul.pattern-picker a").removeAttr("class");
			$this.addClass("selected");
			$.cookie("painting_pattern", $this.attr("data-image"), { path: '/' });
			var $img = $patterns_url+$.cookie("painting_pattern");
			$('body').css('background-image', 'url('+$img+')');
		}
		e.preventDefault();
	
	});
	// Pattern Picker End

});