<?php
$format = get_post_format(  $post->ID );

$post_meta = get_post_meta($post->ID ,'_dt_post_settings',TRUE);
$post_meta = is_array( $post_meta ) ? $post_meta  : array(); 

$hide_format_meta = (painting_option('pageoptions','post-format-meta') != '')? 'hidden' : '';
$hide_author_meta = (painting_option('pageoptions','post-author-meta') != '') ? 'hidden' : '';
$hide_date_meta = (painting_option('pageoptions','post-date-meta') != '') ? 'hidden' : '';	
$hide_comment_meta = (painting_option('pageoptions','post-comment-meta') != '') ? 'hidden' : '';
$hide_category_meta = (painting_option('pageoptions','post-category-meta') != '') ? 'hidden' : '';
$hide_tag_meta = (painting_option('pageoptions','post-tag-meta') != '') ? 'hidden' : '';

$category_color = array_key_exists('categories-variation', $post_meta) ? $post_meta['categories-variation'] : '';

$blog_overlay = '<div class="blog-overlay '.$hide_format_meta.'"><a href="'.get_permalink().'" alt="'.get_the_title().'" title="'.get_the_title().'" class="entry_format"></a></div>';
?>

<article id="post-<?php the_ID();?>" <?php post_class(array('blog-post'));?>>
    <div class="entry-thumb-meta">
		<?php 
        if(($format === "image" || empty($format)) && !array_key_exists("disable-featured-image", $post_meta)) {
            if(has_post_thumbnail()) { ?>
                <div class="entry-thumb">
                    <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>">
                        <?php 
                        $attachment_id = get_post_thumbnail_id( $post->ID );
                        $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
                        echo '<img src="'.$img_attributes[0].'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                        ?>
                    </a>
                    <?php echo painting_wp_kses($blog_overlay); ?>
                </div>
                <?php
            }
        } elseif($format === 'gallery' && array_key_exists('items', $post_meta)) {
            echo '<div class="entry-thumb">
                    <ul class="recent-gallery">';
                        foreach($post_meta['items'] as $key => $item) {
                            $attachment_id = $post_meta['items_id'][$key];
                            $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
                            echo '<li><img src="'.$img_attributes[0].'" alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
                        }
              echo '</ul>
                </div>';
        } elseif($format === "video" && (array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta))) {
            echo '<div class="entry-thumb">';
                if(array_key_exists('oembed-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_oembed_get($post_meta['oembed-url']).'</div>';
                elseif( array_key_exists('self-hosted-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_video_shortcode(array('src' => $post_meta['self-hosted-url'])).'</div>';
            echo '</div>';
        } elseif($format === "audio" && (array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta))) {
            echo '<div class="entry-thumb">';
                if(array_key_exists('oembed-url', $post_meta)) echo wp_oembed_get($post_meta['oembed-url']);
                elseif(array_key_exists('self-hosted-url', $post_meta)) echo wp_audio_shortcode( array('src' => $post_meta['self-hosted-url']));
            echo '</div>';
        } elseif(!array_key_exists("disable-featured-image", $post_meta)) {
            if(has_post_thumbnail()) { 
                ?>
                <div class="entry-thumb">
                    <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>">
                        <?php 
                        $attachment_id = get_post_thumbnail_id( $post->ID );
                        $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
						echo '<img src="'.$img_attributes[0].'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                        ?>
                    </a>
                    <?php echo painting_wp_kses($blog_overlay); ?>
                </div>
                <?php 
            }
        }
        ?>
    </div>
    
    <div class="entry-detail">
		<?php if(is_sticky()): ?>
			<div class="featured-post"> <span class="fa fa-trophy"> </span> <span class="text"> <?php esc_html_e('Featured','painting');?> </span></div>
        <?php endif;?>
        <div class="entry-body">
			<?php 
			the_content(); 
			wp_link_pages( array('before'=>'<div class="page-link">', 'after'=>'</div>', 'link_before'=>'<span>', 'link_after'=>'</span>', 'next_or_number'=>'number',	'pagelink' => '%', 'echo' => 1 ) );
			?>
        </div>
        <div class="entry-meta">
            <?php if(get_the_category()) { ?><div <?php echo 'class="category '.$hide_category_meta.' '.$category_color.'"'; ?>><?php the_category(', '); ?></div><?php } ?>
            <div class="date <?php echo esc_attr($hide_date_meta); ?>">
                <?php echo get_the_date('d M Y');?>
            </div>
            <div class="post-comments <?php echo esc_attr($hide_comment_meta); ?>">
                <?php comments_popup_link('0 '.esc_html__('Comment', 'painting'), '1 '.esc_html__('Comment', 'painting'), '% '.esc_html__('Comment(s)', 'painting'),'','0 '.esc_html__('Comment', 'painting')); ?>
            </div>
            <div <?php echo 'class="author '.$hide_author_meta.'"'; ?>>
				<a href="<?php echo get_author_posts_url(get_the_author_meta('ID'));?>" title="<?php esc_html_e('View all posts by ', 'painting').get_the_author();?>"><?php echo get_the_author();?></a>
            </div>
            <?php the_tags('<div class="tag '.$hide_tag_meta.'">',', ',"</div>");?>
        </div> 
    </div> 
</article>

<?php painting_social_share(); ?>

<?php if(painting_option("pageoptions","single-post-authorbox") == 'true') { ?>
	<div class="post-author-details">
		<h3><?php echo esc_html__('About Author', 'painting'); ?></h3>
		<div class="entry-author-image">
			<img src="<?php echo painting_get_avatar_url(get_the_author_meta( 'ID' ), 85); ?>" alt="<?php echo get_the_author();?>" title="<?php echo get_the_author();?>">
		</div>
		<div class="author-desc">
			<div class="author-title">
				<h5><a href="<?php echo get_author_posts_url(get_the_author_meta('ID'));?>"><?php echo get_the_author();?></a> / <span><?php $author_role = get_the_author_meta('roles'); echo esc_html($author_role[0]); ?></span></h5>
			</div>
			<p><?php echo get_the_author_meta('description'); ?></p>
		</div>
	</div>
<?php } ?>

<?php 
if(painting_option("pageoptions","single-post-comments") == 'true') { 
	if ( comments_open() || get_comments_number() ) {
		comments_template('', true); 
	} 
}
?>

<div class="dt-sc-margin80"></div>