<!-- Start loop to show Portfolio Items -->
<?php 

$tpl_postid = $post->ID;
$tpl_default_settings = get_post_meta( $post->ID, '_tpl_default_settings', TRUE );
$tpl_default_settings = is_array( $tpl_default_settings ) ? $tpl_default_settings  : array();

$post_layout		=	isset( $tpl_default_settings['portfolio-post-layout'] ) ? $tpl_default_settings['portfolio-post-layout'] : "one-half-column";
$page_layout  		= 	array_key_exists( "layout", $tpl_default_settings ) ? $tpl_default_settings['layout'] : "content-full-width";
$portfolio_type  	= 	array_key_exists( "portfolio-type", $tpl_default_settings ) ? $tpl_default_settings['portfolio-type'] : "";
$post_space			=	isset( $tpl_default_settings['space'] ) ? 'with-space' : 'no-space';
$post_loadmore		=	isset( $tpl_default_settings['loadmore'] ) ? 'loadmore' : '';
$post_per_page		=	isset( $tpl_default_settings['portfolio-post-per-page'] ) ? $tpl_default_settings['portfolio-post-per-page'] : -1;

#TO SET POST LAYOUT
switch($post_layout):

	case 'one-column':
		$post_class = 'portfolio column dt-sc-one-column';
		$columns = 1;
	break;

	case 'one-half-column';
		$post_class = 'portfolio column dt-sc-one-half';
		$columns = 2;
	break;
	
	case 'one-third-column':
		$post_class = 'portfolio column dt-sc-one-third';
		$columns = 3;
	break;

	case 'one-fourth-column':
		$post_class = 'portfolio column dt-sc-one-fourth';
		$columns = 4;
	break;
endswitch;	

$categories =	isset($tpl_default_settings['portfolio-categories']) ? array_filter($tpl_default_settings['portfolio-categories']) : array();
if(empty($categories)):
	$categories = get_categories('taxonomy=portfolio_entries&hide_empty=1');
else:
	$args = array('taxonomy'=>'portfolio_entries','hide_empty'=>1,'include'=>$categories);
	$categories = get_categories($args);
endif;

if(array_key_exists("filter",$tpl_default_settings)) $filter = 'true';
else $filter = 'false';

?>

<?php if( sizeof($categories) > 1 ) :
		if( array_key_exists("filter",$tpl_default_settings) && (!empty($categories)) ):
			$post_class .= " all-sort "; ?>
			<div class="sorting-container dt-sc-hr-invisible-small">
				<a href="#" class="active-sort" title="" data-filter=".all-sort"><?php esc_html_e('All','painting');?></a>
				<?php foreach( $categories as $category ): 
					$cat_name = str_replace(' ', '-', $category->cat_name); ?>
					<a href='#' data-filter=".<?php echo esc_attr($cat_name);?>-sort"><?php echo esc_html($category->cat_name);?></a>
				<?php endforeach;?>
			</div>
            <div class="dt-sc-margin10"></div>
<?php 	endif;
	endif;?>

	<!-- **Portfolio Container** -->
	<?php
	$args = array();
	if(isset($tpl_default_settings['portfolio-categories'])):
		$terms = array_filter($tpl_default_settings['portfolio-categories']);
		$args = array( 
			'orderby' => 'ID',
			'order' => 'ASC',
			'paged' => get_query_var( 'paged' ),
			'posts_per_page' => $post_per_page,
			'tax_query' => array( array( 'taxonomy'=>'portfolio_entries', 'field'=>'id', 'operator'=>'IN', 'terms'=>$terms ) ) );
	else:
		$args = array( 'orderby' => 'ID', 'order' => 'ASC', 'paged' => get_query_var( 'paged' ) ,'posts_per_page' => $post_per_page,'post_type' => 'dt_portfolios');
	endif;

	$portfolio_query = new WP_Query($args);
	if($portfolio_query->have_posts()): 
		$i = 1;
		echo '<div class="portfolio-container apply-isotope-portfolio '.$portfolio_type.'">';
		while($portfolio_query->have_posts()): 
			$portfolio_query->the_post();

			$temp_class = "";
			if($i == 1) $temp_class = $post_class.' first'; else $temp_class = $post_class;
			if($i == $columns) $i = 1; else $i = $i + 1;

			$the_id = get_the_ID();

			$portfolio_item_meta = get_post_meta($the_id,'_portfolio_settings',TRUE);
			$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();

			#Find sort class by using the portfolio_entries
			$sort = " ";
			if( array_key_exists("filter",$tpl_default_settings) ):
				$item_categories = get_the_terms( $the_id, 'portfolio_entries' );
				if(is_object($item_categories) || is_array($item_categories)):
					foreach ($item_categories as $category):
						$cat_slug = str_replace(' ', '-', $category->name);
						$sort .= $cat_slug.'-sort ';
					endforeach;
				endif;
			 endif;
			 
			 $hover_color = array_key_exists('hover-color', $portfolio_item_meta) ? $portfolio_item_meta['hover-color'] : '';
			 $hover_style = '';
			 
			 if($hover_color != '') {
				 
				$hover_color_opacity = array_key_exists('hover-color-opacity', $portfolio_item_meta) ? $portfolio_item_meta['hover-color-opacity'] : '';
				
				$rgb = painting_hex2rgb($hover_color); 
				$hover_style = 'style="background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$hover_color_opacity.');"';
				
			 }
			 
			 ?>
             
            <div id="<?php echo "portfolio-{$the_id}";?>" class="<?php echo esc_attr($temp_class.$sort);?>">
                <figure>
					<?php 
                    $popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title();
                    if( array_key_exists('items_name', $portfolio_item_meta) ) {
                        $item =  $portfolio_item_meta['items_name'][0];
                        $popup = $portfolio_item_meta['items'][0];
                        if( "video" === $item ) {
                            $items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
                            if( !empty($items) ) {
                                echo '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';	
                            } else {
                                echo '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title().'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                            }
                        } else {
                            $attachment_id = $portfolio_item_meta['items_id'][0];
                            $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
                            echo '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                        }
                        
                    } else {
                        echo '<img src="'.esc_attr($popup).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                    }
                    ?>
                    <figcaption <?php echo painting_wp_kses($hover_style); ?>>
                        <div class="fig-content-wrapper">
                            <div class="fig-content">
                                <h5><a href="<?php the_permalink();?>"><?php echo get_the_title(); ?></a></h5>
                                <?php echo get_the_term_list($post->ID, 'portfolio_entries', '<p>', ', ', '</p>'); ?>     
                                <div class="fig-overlay">
                                    <a class="zoom" href="<?php echo esc_url($popup);?>" data-gal="prettyPhoto[gallery]" title="<?php echo get_the_title(); ?>"> <span class="fa fa-plus"> </span> </a>
                                    <a class="link" href="<?php the_permalink();?>" title="<?php echo get_the_title(); ?>"> <span class="fa fa-link"> </span> </a>
                                </div>
                            </div>
                        </div>  
                    </figcaption>
                </figure>             
            </div>
             
		<?php endwhile;
		echo '</div>';
		
		if($post_loadmore != '') {
			
			if($post_per_page != -1) { 
				$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				$terms = '';
				foreach($categories as $cat) {
					$terms .= $cat->term_id.',';
				}
				$terms = rtrim($terms, ',');
				?>	
				<div class="dt-sc-margin50"></div>
                <div class="aligncenter">
                    <a class="dt-sc-button type7 portfolio-load-more" data-post-per-page="<?php echo esc_attr($post_per_page); ?>" data-page="<?php echo esc_attr($paged)+1; ?>" data-post-layout="<?php echo esc_attr($post_layout); ?>" data-filter="<?php echo esc_attr($filter); ?>" data-taxonomy="<?php echo esc_attr($terms); ?>" data-portfolio-type="<?php echo esc_attr($portfolio_type); ?>" ><?php esc_html_e('Load More', 'painting'); ?></a>
                </div>
				<?php
			 }
		} else {
			if($portfolio_query->max_num_pages > 1) { ?>
            	<div class="dt-sc-margin20"></div>
				<div class="pagination <?php echo painting_get_pagination_position(); ?>">
					<?php
					$pages = ($portfolio_query->max_num_pages) ? $portfolio_query->max_num_pages : 1;
					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					if($paged > 1) echo '<div class="prev-post"><a href="'.get_pagenum_link($paged - 1).'"><span class="fa fa-caret-left"></span>&nbsp;'.esc_html__('Prev', 'painting').'</a></div>';
					echo paginate_links( array(
					  'base' 		 => add_query_arg('paged','%#%'),
					  'format' 		 => '',
					  'current' 	 => $paged,
					  'type'     	 => 'list',
					  'end_size'     => 2,
					  'mid_size'     => 3,
					  'prev_next'    => false,
					  'total' 		 => $portfolio_query->max_num_pages )
					);
					if ($paged < $pages) echo '<div class="next-post"><a href="'.get_pagenum_link($paged + 1).'">'.esc_html__('Next', 'painting').'&nbsp;<span class="fa fa-caret-right"></span></a></div>';
					?>
				</div>
			<?php }
		}?>
        		
		<?php
	else: ?>
		<h2><?php esc_html_e('Nothing Found.', 'painting'); ?></h2>
		<p><?php esc_html_e('Apologies, but no results were found for the requested archive.', 'painting'); ?></p><?php
	endif;
	wp_reset_postdata();
	?><!-- **Portfolio Container** -->
<!-- End loop to show Portfolio Items -->