<?php
/* ---------------------------------------------------------------------------
 * Function to apply the colors defined in template pages and buddha panel options
 * --------------------------------------------------------------------------- */
 
if ( ! function_exists( 'painting_template_page_colors' ) ) {
	function painting_template_page_colors() {

		$site_title_color = painting_option('layout','styling-site-title-color');

		echo '<style>';
	
		echo '.logo h2 a { color: '.$site_title_color.'; }';

		echo "</style>";
		
		$colors_opts = (painting_option('colors') != '') ? painting_option('colors') : array();


		
		if(!array_key_exists('disable-color-settings', $colors_opts)) {
			
			$body_bgcolor =  array_key_exists('body-bgcolor', $colors_opts) ? $colors_opts['body-bgcolor'] : ''; 

			$site_title_color = array_key_exists('styling-site-title-color', $colors_opts) ? $colors_opts['styling-site-title-color'] : ''; 

			$topbar_bgcolor =  array_key_exists('topbar-bgcolor', $colors_opts) ? $colors_opts['topbar-bgcolor'] : ''; 
			$topbar_textcolor =  array_key_exists('topbar-text-color', $colors_opts) ? $colors_opts['topbar-text-color'] : ''; 
			$topbar_linkcolor =  array_key_exists('topbar-link-color', $colors_opts) ? $colors_opts['topbar-link-color'] : ''; 
			$topbar_linkhcolor =  array_key_exists('topbar-link-hcolor', $colors_opts) ? $colors_opts['topbar-link-hcolor'] : ''; 
			$topbar_separatorcolor =  array_key_exists('topbar-separator-color', $colors_opts) ? $colors_opts['topbar-separator-color'] : ''; 
			
			$breadcrumb_bgcolor =  array_key_exists('breadcrumb-bgcolor', $colors_opts) ? $colors_opts['breadcrumb-bgcolor'] : ''; 
			$breadcrumb_textcolor =  array_key_exists('breadcrumb-text-color', $colors_opts) ? $colors_opts['breadcrumb-text-color'] : ''; 
			$breadcrumb_linkcolor =  array_key_exists('breadcrumb-link-color', $colors_opts) ? $colors_opts['breadcrumb-link-color'] : ''; 
			$breadcrumb_linkhcolor =  array_key_exists('breadcrumb-link-hcolor', $colors_opts) ? $colors_opts['breadcrumb-link-hcolor'] : ''; 
						
			$header_bgcolor =  array_key_exists('header-bgcolor', $colors_opts) ? $colors_opts['header-bgcolor'] : ''; 
			$megamenu_bgcolor =  array_key_exists('megamenu-bgcolor', $colors_opts) ? $colors_opts['megamenu-bgcolor'] : ''; 
			
			$header_menucolor =  array_key_exists('menu-color', $colors_opts) ? $colors_opts['menu-color'] : ''; 
			$header_menuhovercolor =  array_key_exists('menu-hovercolor', $colors_opts) ? $colors_opts['menu-hovercolor'] : ''; 
			
			$submenu_color =  array_key_exists('submenu-color', $colors_opts) ? $colors_opts['submenu-color'] : ''; 
			$submenu_hovercolor =  array_key_exists('submenu-hovercolor', $colors_opts) ? $colors_opts['submenu-hovercolor'] : ''; 
			$submenu_textcolor =  array_key_exists('submenu-textcolor', $colors_opts) ? $colors_opts['submenu-textcolor'] : ''; 
			$submenu_bordercolor =  array_key_exists('submenu-bordercolor', $colors_opts) ? $colors_opts['submenu-bordercolor'] : ''; 

			$content_themecolor =  array_key_exists('content-theme-color', $colors_opts) ? $colors_opts['content-theme-color'] : ''; 
			$content_textcolor =  array_key_exists('content-text-color', $colors_opts) ? $colors_opts['content-text-color'] : ''; 
			$content_secondary_textcolor =  array_key_exists('content-secondary-text-color', $colors_opts) ? $colors_opts['content-secondary-text-color'] : ''; 
			$content_linkcolor =  array_key_exists('content-link-color', $colors_opts) ? $colors_opts['content-link-color'] : ''; 
			$content_linkhcolor =  array_key_exists('content-link-hcolor', $colors_opts) ? $colors_opts['content-link-hcolor'] : ''; 

			$footer_themecolor =  array_key_exists('footer-theme-color', $colors_opts) ? $colors_opts['footer-theme-color'] : ''; 
			$footer_bgcolor =  array_key_exists('footer-bgcolor', $colors_opts) ? $colors_opts['footer-bgcolor'] : ''; 
			$footer_text_color =  array_key_exists('footer-text-color', $colors_opts) ? $colors_opts['footer-text-color'] : ''; 
			$footer_link_color =  array_key_exists('footer-link-color', $colors_opts) ? $colors_opts['footer-link-color'] : ''; 
			$footer_link_hcolor =  array_key_exists('footer-link-hcolor', $colors_opts) ? $colors_opts['footer-link-hcolor'] : ''; 
			$footer_heading_color =  array_key_exists('footer-heading-color', $colors_opts) ? $colors_opts['footer-heading-color'] : '';
			$footer_border_color =  array_key_exists('footer-border-color', $colors_opts) ? $colors_opts['footer-border-color'] : '';
			 
			$copyright_bgcolor =  array_key_exists('copyright-bgcolor', $colors_opts) ? $colors_opts['copyright-bgcolor'] : ''; 
			$copyright_text_color =  array_key_exists('copyright-text-color', $colors_opts) ? $colors_opts['copyright-text-color'] : ''; 
			$copyright_link_color =  array_key_exists('copyright-link-color', $colors_opts) ? $colors_opts['copyright-link-color'] : ''; 
			$copyright_link_hcolor =  array_key_exists('copyright-link-hcolor', $colors_opts) ? $colors_opts['copyright-link-hcolor'] : ''; 

			$heading_h1_color =  array_key_exists('heading-h1-color', $colors_opts) ? $colors_opts['heading-h1-color'] : '';
			$heading_h2_color =  array_key_exists('heading-h2-color', $colors_opts) ? $colors_opts['heading-h2-color'] : '';
			$heading_h3_color =  array_key_exists('heading-h3-color', $colors_opts) ? $colors_opts['heading-h3-color'] : '';
			$heading_h4_color =  array_key_exists('heading-h4-color', $colors_opts) ? $colors_opts['heading-h4-color'] : '';
			$heading_h5_color =  array_key_exists('heading-h5-color', $colors_opts) ? $colors_opts['heading-h5-color'] : '';
			$heading_h6_color =  array_key_exists('heading-h6-color', $colors_opts) ? $colors_opts['heading-h6-color'] : ''; 
			
		}
		
		if(!array_key_exists('disable-color-settings', $colors_opts)) {
			
			echo '<style>';
	
				if($body_bgcolor != '' && $body_bgcolor != '#') {
					echo 'body, .boxed .wrapper, .boxed #main, .boxed .inner-wrapper, input[type="text"], input[type="password"], input[type="email"], input[type="url"], input[type="tel"], input[type="number"], input[type="range"], input[type="date"], input[type="search"], textarea, input.text, .dt-sc-pr-tb-col, .dt-sc-button.type4, .dt-sc-button.type3, .carousel-arrows a, .dt-sc-subscribe-container, h5.dt-sc-toggle::after, h5.dt-sc-toggle-accordion::after, .woocommerce .quantity .plus, .woocommerce .quantity .minus, .woocommerce-page .quantity .plus, .woocommerce-page .quantity .minus, .woocommerce .quantity .qty, .woocommerce-page .quantity .qty, td, tbody tr:nth-child(2n+1) td, .woocommerce table.cart td.actions .coupon .input-text, .woocommerce-page table.cart td.actions .coupon .input-text, .woocommerce #content table.cart td.actions .coupon .input-text, .woocommerce-page #content table.cart td.actions .coupon .input-text, .select2-container .select2-choice, .select2-results, .woocommerce #payment, .woocommerce-page #payment, .type2 .dt-sc-tabs-frame-content, .woocommerce #reviews #respond input[type="text"], .woocommerce #reviews #respond textarea, .woocommerce #reviews #respond input[type="email"], .pp_inline #respond input[type="text"], .pp_inline #respond input[type="email"], .pp_inline #respond textarea, .dt-sc-tabs-vertical-frame-content { background: '.$body_bgcolor.'; }'."\n";
				}

				if($site_title_color != '' && $site_title_color != '#' ){

					echo '#logo h2 a{ color:'.$site_title_color.'}'."\n";


				}
								
				
				if($topbar_bgcolor != '' && $topbar_bgcolor != '#') {
					echo '.top-bar { background: '.$topbar_bgcolor.'; }'."\n";
				}
					
				if($topbar_textcolor != '' && $topbar_textcolor != '#') {
					echo '.top-bar .dt-sc-left > span, .top-bar .dt-sc-right > span, .top-menu li, .top-menu li i, .top-bar { color: '.$topbar_textcolor.'; }'."\n";
				}
				
				if($topbar_linkcolor != '' && $topbar_linkcolor != '#') {
					echo '.top-menu li a, .top-bar a { color: '.$topbar_linkcolor.'; }'."\n";
				}
	
				if($topbar_linkhcolor != '' && $topbar_linkhcolor != '#') {
					echo '.top-menu li a:hover, .top-bar a:hover { color: '.$topbar_linkhcolor.'; }'."\n";
				}
				
				if($topbar_separatorcolor != '' && $topbar_separatorcolor != '#') {
					echo '.top-menu li { border-color: '.$topbar_separatorcolor.'; }'."\n";
				}
				
				
				if($breadcrumb_bgcolor != '' && $breadcrumb_bgcolor != '#') {
					echo '.breadcrumb-wrapper { background: '.$breadcrumb_bgcolor.'; }'."\n";
				}

				if($breadcrumb_textcolor != '' && $breadcrumb_textcolor != '#') {					
					echo '#main .breadcrumb-wrapper h1, #main .breadcrumb-wrapper h1 a, .breadcrumb .fa { color: '.$breadcrumb_textcolor.'; }'."\n";
				}

				if($breadcrumb_linkcolor != '' && $breadcrumb_linkcolor != '#') {
					echo '#main .breadcrumb a { color: '.$breadcrumb_linkcolor.'; }'."\n"; 
				}
				
				if($breadcrumb_linkhcolor != '' && $breadcrumb_linkhcolor != '#') {
					echo '#main .breadcrumb a:hover, #main .breadcrumb .current { color: '.$breadcrumb_linkhcolor.'; }'."\n"; 
				}
				
				if($header_bgcolor != '' && $header_bgcolor != '#') {
					echo '.header { background: '.$header_bgcolor.'; }'."\n";
				}
					
				if($megamenu_bgcolor != '' && $megamenu_bgcolor != '#') {
					echo '.megamenu-child-container, #main-menu ul li.menu-item-simple-parent ul { background-color: '.$megamenu_bgcolor.'; }'."\n";
				}
				
				
				if($header_menucolor != '' && $header_menucolor != '#') {
					echo '#main-menu > ul > li > a, #main-menu ul li.menu-item-simple-parent ul li a, .megamenu-child-container > ul.sub-menu > li > a, .megamenu-child-container ul.sub-menu > li > ul li a, .megamenu-child-container > ul.sub-menu > li > a, .header #main-menu > ul > li > a { color: '.$header_menucolor.'; }'."\n";
				}
				
				if($header_menuhovercolor != '' && $header_menuhovercolor != '#') {
					echo '#main-menu ul > li.current_page_item > a, #main-menu ul > li.current_page_ancestor > a, #main-menu ul > li.current-menu-item > a, #main-menu ul > li.current-menu-ancestor > a, #main-menu ul li.menu-item-simple-parent ul > li.current_page_item > a, #main-menu ul li.menu-item-simple-parent ul > li.current_page_ancestor > a, #main-menu ul li.menu-item-simple-parent ul > li.current-menu-item > a, #main-menu ul li.menu-item-simple-parent ul > li.current-menu-ancestor > a, #main-menu ul li.menu-item-simple-parent ul li a:hover, .menu-item-widget-area-container .widget ul li a:hover, #main-menu > ul > li > a:hover, #main-menu ul li.menu-item-simple-parent ul li a:hover, #main-menu ul li.menu-item-simple-parent ul li.current_page_item > a, .megamenu-child-container ul > li > a:hover, .megamenu-child-container ul > li > ul li a:hover, #main-menu > ul > li > a:hover, .header #main-menu > ul > li > a:hover, .header #main-menu > ul > li.current_page_item > a, .header #main-menu > ul > li.current-menu-ancestor > a { color: '.$header_menuhovercolor.'; }'."\n";
				}
	

				if($submenu_color != '' && $submenu_color != '#') {
					echo '#main-menu ul li.menu-item-simple-parent ul li a, .megamenu-child-container > ul.sub-menu > li > a, .megamenu-child-container ul.sub-menu > li > ul li a { color:'.$submenu_color.'; }'."\n";
				}

				if($submenu_hovercolor != '' && $submenu_hovercolor != '#') {
					echo '#main-menu ul li.menu-item-simple-parent ul li a:hover, #main-menu ul > li.current_page_item > a, #main-menu ul > li.current-menu-item > a, .megamenu-child-container ul.sub-menu > li > ul li a:hover, .megamenu-child-container ul > li > a:hover, .megamenu-child-container ul > li > ul li a:hover { color:'.$submenu_hovercolor.'; }'."\n";
				}

				if($submenu_textcolor != '' && $submenu_textcolor != '#') {
					echo '.megamenu-child-container > ul.sub-menu > li > p, .megamenu-child-container > ul.sub-menu > li > .nolink-menu { color:'.$submenu_textcolor.'; }'."\n";
				}

				if($submenu_bordercolor != '' && $submenu_bordercolor != '#') {
					echo '.megamenu-child-container > ul.sub-menu > li > a, .megamenu-child-container > ul.sub-menu > li > .nolink-menu, #main-menu ul li.menu-item-simple-parent ul li { border-color:'.$submenu_bordercolor.'; border-image:none; }'."\n";
					echo '.megamenu-child-container:after, #main-menu ul li.menu-item-simple-parent ul:after { background:'.$submenu_bordercolor.'; }'."\n";
				}
				
				
				if($content_themecolor != '' && $content_themecolor != '#') {
					$content_themecolor_rgba = painting_hex2rgb($content_themecolor);
					echo '#main .themecolor { color: '.$content_themecolor.'; }'."\n";
					echo '#main .themebgcolor, .woocommerce .cart-collaterals .cart_totals tr td, .woocommerce-page .cart-collaterals .cart_totals tr td, .woocommerce .cart-collaterals .cart_totals tr th, .woocommerce-page .cart-collaterals .cart_totals tr th , .woocommerce table.shop_table th, .woocommerce-page table.shop_table th, .cart_totals  input[type="text"], .woocommerce #payment div.payment_box, .woocommerce-page #payment div.payment_box, .addresses .col-1, .addresses .col-2, .dt-sc-button.type2, .dt-sc-support-info .support-icon, .type2 ul.dt-sc-tabs-frame li a, .widget.widget_tweetbox ul.tweet_list li, .woocommerce table.cart a.remove, .woocommerce-page table.cart a.remove, .woocommerce #content table.cart a.remove, .woocommerce-page #content table.cart a.remove, th, .type2 .dt-sc-toggle, .type2 .dt-sc-toggle-accordion, .dt-sc-titled-box-content, .dt-sc-tb-content, blockquote.type1, .dt-sc-pullquote1, .dt-sc-pullquote2, .dt-sc-pullquote3, .dt-sc-pullquote4, .dt-sc-pullquote5, .dt-sc-pullquote6, .dt-sc-tabs-frame-content, ul.dt-sc-tabs-frame li a.current, ul.dt-sc-tabs-vertical-frame li a, .dt-sc-team.type2, .dt-sc-boxed-tooltip.dt-sc-tooltip-top, .dt-sc-boxed-tooltip.dt-sc-tooltip-right, .dt-sc-boxed-tooltip.dt-sc-tooltip-bottom, .dt-sc-boxed-tooltip.dt-sc-tooltip-left { background: '.$content_themecolor.'; }'."\n";
					echo '.secondary-sidebar .widgettitle, .product .product-details, .summary .project-details ul.client-details li, .woocommerce .quantity .plus, .woocommerce .quantity .minus, .woocommerce-page .quantity .plus, .woocommerce-page .quantity .minus, .woocommerce #reviews #respond input[type="text"], .woocommerce #reviews #respond textarea, .woocommerce #reviews #respond input[type="email"], .pp_inline #respond input[type="text"], .pp_inline #respond input[type="email"], .pp_inline #respond textarea, .type2 .dt-sc-tabs-frame-content, .woocommerce p.stars a.star-1, .woocommerce p.stars a.star-2, .woocommerce p.stars a.star-3, .woocommerce p.stars a.star-4, .woocommerce p.stars a.star-5, .woocommerce-page p.stars a.star-1, .woocommerce-page p.stars a.star-2, .woocommerce-page p.stars a.star-3, .woocommerce-page p.stars a.star-4, .woocommerce-page p.stars a.star-5, input[type="text"], input[type="password"], input[type="email"], input[type="url"], input[type="tel"], input[type="number"], input[type="range"], input[type="date"], input[type="search"], textarea, input.text, .woocommerce table.shop_table .cart_table_item td:first-child, .woocommerce table.shop_table .cart_table_item td:last-child, td, .woocommerce table.cart td.actions .coupon .input-text, .woocommerce-page table.cart td.actions .coupon .input-text, .woocommerce #content table.cart td.actions .coupon .input-text, .woocommerce-page #content table.cart td.actions .coupon .input-text, th, h5.dt-sc-toggle, h5.dt-sc-toggle-accordion, .woocommerce .quantity .qty, .woocommerce-page .quantity .qty { border-color: '.$content_themecolor.'; }'."\n";
					echo '.dt-sc-animate-num { border-left:1px solid rgba('.$content_themecolor_rgba[0].', '.$content_themecolor_rgba[1].', '.$content_themecolor_rgba[2].', 0.5);  }'."\n";
				}

				if($content_textcolor != '' && $content_textcolor != '#') 
					echo 'body #main , .dt-sc-testimonial .author-detail span, input[type="text"]:hover, input[type="password"]:hover, input[type="email"]:hover, textarea:hover, input[type="date"]:hover, .widget ul li:before, .woocommerce .star-rating span:before, .woocommerce-page .star-rating span:before, label, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce-page nav.woocommerce-pagination ul li span.current, .woocommerce #content nav.woocommerce-pagination ul li span.current, .woocommerce-page #content nav.woocommerce-pagination ul li span.current, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce-page nav.woocommerce-pagination ul li a:hover, .woocommerce #content nav.woocommerce-pagination ul li a:hover, .woocommerce-page #content nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce-page nav.woocommerce-pagination ul li a:focus, .woocommerce #content nav.woocommerce-pagination ul li a:focus, .woocommerce-page #content nav.woocommerce-pagination ul li a:focus, .product .summary .price .amount, th, td, table.shop_table .quantity .plus, table.shop_table .quantity .minus, .product .summary .quantity .qty, .product .summary .quantity .plus, .product .summary .quantity .minus, .woocommerce .cart-collaterals .cart_totals td, h3#ship-to-different-address label, .payment_methods, .payment_methods label, .payment_methods a, .woocommerce #payment div.payment_box, .woocommerce-page #payment div.payment_box, ol.dt-sc-fancy-list li span, .dt-sc-animate-num .dt-sc-num-count, .dt-sc-donutchart { color: '.$content_textcolor.'; }'."\n";
	
				if($content_secondary_textcolor != '' && $content_secondary_textcolor != '#') {
					echo '.entry-meta-data, .dt-sc-bar-text, .dt-sc-tb-header .dt-sc-price span, .dt-sc-tb-header .dt-sc-price p, input[type="text"], input[type="password"], input[type="email"], input[type="url"], input[type="tel"], input[type="number"], input[type="range"], input[type="date"], input[type="search"], textarea, input.text, select, ul.dt-sc-fancy-list li:before, ul.dt-sc-fancy-list li, ul.dt-sc-fancy-list.circle-tick li:before, ul.dt-sc-fancy-list.circle-tick.medium li, .author-title span, .woocommerce #reviews #comments ol.commentlist li .meta, .woocommerce-page #reviews #comments ol.commentlist li .meta, label span, .woocommerce table.cart td.actions .coupon .input-text, .woocommerce-page table.cart td.actions .coupon .input-text, .woocommerce #content table.cart td.actions .coupon .input-text, .woocommerce-page #content table.cart td.actions .coupon .input-text, .select2-results, ins { color: '.$content_secondary_textcolor.'; }'."\n";
					echo '.dt-sc-team h6:before, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce-page nav.woocommerce-pagination ul li span.current, .woocommerce #content nav.woocommerce-pagination ul li span.current, .woocommerce-page #content nav.woocommerce-pagination ul li span.current, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce-page nav.woocommerce-pagination ul li a:hover, .woocommerce #content nav.woocommerce-pagination ul li a:hover, .woocommerce-page #content nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce-page nav.woocommerce-pagination ul li a:focus, .woocommerce #content nav.woocommerce-pagination ul li a:focus, .woocommerce-page #content nav.woocommerce-pagination ul li a:focus { background-color: '.$content_secondary_textcolor.'; }'."\n";
					echo '.woocommerce nav.woocommerce-pagination ul li, .woocommerce-page nav.woocommerce-pagination ul li, .woocommerce #content nav.woocommerce-pagination ul li, .woocommerce-page #content nav.woocommerce-pagination ul li { border-color: '.$content_secondary_textcolor.'; }'."\n";
				}

				if($content_linkcolor != '' && $content_linkcolor != '#') {
					echo '#main a { color: '.$content_linkcolor.'; }'."\n";
				}
	
				if($content_linkhcolor != '' && $content_linkhcolor != '#') {
					echo '#main a:hover { color: '.$content_linkhcolor.'; }'."\n";
				}
					
				
				if($footer_themecolor != '' && $footer_themecolor != '#') {
					echo '#footer .themecolor, .widget.widget_text ul li:before, .widget.widget_tweetbox ul.tweet_list li::before { color: '.$footer_themecolor.'; }'."\n";
					echo '#footer .themebgcolor, .widgettitle:after { background: '.$footer_themecolor.'; }'."\n";
				}
				
				if($footer_bgcolor != '' && $footer_bgcolor != '#') {
					echo '.footer-widgets-wrapper { background: '.$footer_bgcolor.'; }'."\n";
				}
								
				if($footer_text_color != '' && $footer_text_color != '#') {
					echo '.footer-widgets-wrapper, .footer-widgets-wrapper .tweet_text, .widget.widget_text p { color: '.$footer_text_color.'; }'."\n";
				}
	
				if($footer_link_color != '' && $footer_link_color != '#') {
					echo '.footer-widgets-wrapper a, .widget ul li a, .widget.widget_text ul li a { color: '.$footer_link_color.'; }'."\n";
				}
				
				if($footer_link_hcolor != '' && $footer_link_hcolor != '#') {
					echo '.footer-widgets-wrapper a:hover, .widget ul li a:hover, .widget.widget_text ul li a:hover, #footer .dt-sc-social-icons li:hover a { color: '.$footer_link_hcolor.'; }'."\n";
				}
	
				if($footer_heading_color != '' && $footer_heading_color != '#') {
					echo '#footer .widgettitle { color: '.$footer_heading_color.'; }'."\n";
				}
				
				if($footer_border_color != '' && $footer_border_color != '#') {
					echo '#footer .widgettitle, #footer .widget.widget_text ul li, #footer .widget.widget_tweetbox ul.tweet_list li, #footer .dt-sc-social-icons { border-color: '.$footer_border_color.'; }'."\n";
				}

				
				if($copyright_bgcolor != '' && $copyright_bgcolor != '#') {
					echo '.copyright { background: '.$copyright_bgcolor.'; }'."\n";
				}

				if($copyright_text_color != '' && $copyright_text_color != '#') {
					echo '.copyright p, .footer-links li { color: '.$copyright_text_color.'; }'."\n";
				}
	
				if($copyright_link_color != '' && $copyright_link_color != '#') {
					echo '.copyright p a, .footer-links li a { color: '.$copyright_link_color.'; }'."\n";
					echo '.footer-links li:before { background-color: '.$copyright_link_color.'; }'."\n";
				}
				
				if($copyright_link_hcolor != '' && $copyright_link_hcolor != '#') {
					echo '.copyright p a:hover, .footer-links li a:hover { color: '.$copyright_link_hcolor.'; }'."\n";
				}


				if($heading_h1_color != '' && $heading_h1_color != '#') {
					echo '#main h1, #main h1 a { color:'.$heading_h1_color.' }'."\n";
					echo '#main .border-title h1 { border-color:'.$heading_h1_color.' }'."\n";
				}
			
				if($heading_h2_color != '' && $heading_h2_color != '#') {
					echo '#main h2, #main h2 a { color:'.$heading_h2_color.' }'."\n";
					echo '#main .border-title h2 { border-color:'.$heading_h2_color.' }'."\n";
				}
					
				if($heading_h3_color != '' && $heading_h3_color != '#') {
					echo '#main h3, #main h3 a { color:'.$heading_h3_color.' }'."\n";
					echo '#main .border-title h3 { border-color:'.$heading_h3_color.' }'."\n";
				}
					
				if($heading_h4_color != '' && $heading_h4_color != '#') {
					echo '#main h4, #main h4 a { color:'.$heading_h4_color.' }'."\n";
					echo '#main .border-title h4 { border-color:'.$heading_h4_color.' }'."\n";
				}
					
				if($heading_h5_color != '' && $heading_h5_color != '#') {
					echo '#main h5, #main h5 a { color:'.$heading_h5_color.' }'."\n";
					echo '#main .border-title h5 { border-color:'.$heading_h5_color.' }'."\n";
				}
					
				if($heading_h6_color != '' && $heading_h6_color != '#') {
					echo '#main h6, #main h6 a { color:'.$heading_h6_color.' }'."\n";
					echo '#main .border-title h6 { border-color:'.$heading_h6_color.' }'."\n";
				}
	
			echo '</style>';
		
		}
		
		$fonts_opts = (painting_option('fonts') != '') ? painting_option('fonts') : array();
		
		if(!array_key_exists('disable-fonts-settings', $fonts_opts)) {
		
			$content_font =  array_key_exists('content-font', $fonts_opts) ? $fonts_opts['content-font'] : '';
			$content_font_size =  array_key_exists('content-font-size', $fonts_opts) ? $fonts_opts['content-font-size'] : '';
			$content_weight =  array_key_exists('content-weight', $fonts_opts) ? $fonts_opts['content-weight'] : '';
			$content_style =  array_key_exists('content-style', $fonts_opts) ? $fonts_opts['content-style'] : '';
			$content_lineheight =  array_key_exists('content-lineheight', $fonts_opts) ? $fonts_opts['content-lineheight'] : '';
			
			$menu_font =  array_key_exists('menu-font', $fonts_opts) ? $fonts_opts['menu-font'] : '';
			$menu_font_size =  array_key_exists('menu-font-size', $fonts_opts) ? $fonts_opts['menu-font-size'] : '';
			$menu_weight =  array_key_exists('menu-weight', $fonts_opts) ? $fonts_opts['menu-weight'] : '';
			$menu_style =  array_key_exists('menu-style', $fonts_opts) ? $fonts_opts['menu-style'] : '';
			$menu_texttransform =  array_key_exists('menu-texttransform', $fonts_opts) ? $fonts_opts['menu-texttransform'] : '';
			
			$submenu_font =  array_key_exists('submenu-font', $fonts_opts) ? $fonts_opts['submenu-font'] : '';
			$submenu_font_size =  array_key_exists('submenu-font-size', $fonts_opts) ? $fonts_opts['submenu-font-size'] : '';
			$submenu_weight =  array_key_exists('submenu-weight', $fonts_opts) ? $fonts_opts['submenu-weight'] : '';
			$submenu_style =  array_key_exists('submenu-style', $fonts_opts) ? $fonts_opts['submenu-style'] : '';
			$submenu_texttransform =  array_key_exists('submenu-texttransform', $fonts_opts) ? $fonts_opts['submenu-texttransform'] : '';
			
			$pagetitle_font =  array_key_exists('pagetitle-font', $fonts_opts) ? $fonts_opts['pagetitle-font'] : '';
			$pagetitle_font_size =  array_key_exists('pagetitle-font-size', $fonts_opts) ? $fonts_opts['pagetitle-font-size'] : '';
			$pagetitle_weight =  array_key_exists('pagetitle-weight', $fonts_opts) ? $fonts_opts['pagetitle-weight'] : '';
			$pagetitle_style =  array_key_exists('pagetitle-style', $fonts_opts) ? $fonts_opts['pagetitle-style'] : '';
			$pagetitle_texttransform =  array_key_exists('pagetitle-texttransform', $fonts_opts) ? $fonts_opts['pagetitle-texttransform'] : '';
			
			
			$h1_font =  array_key_exists('h1-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-font']) : '';
			$h1_font_size =  array_key_exists('h1-font-size', $fonts_opts) ? $fonts_opts['h1-font-size'] : '';
			$h1_weight =  array_key_exists('h1-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-weight']) : '';
			$h1_style =  array_key_exists('h1-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-style']) : '';
			$h1_texttransform =  array_key_exists('h1-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-texttransform']) : '';
			$h1_lineheight =  array_key_exists('h1-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-lineheight']) : '';
			$h1_letterspacing =  array_key_exists('h1-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h1-letterspacing']) : '';
			
			$h2_font =  array_key_exists('h2-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-font']) : '';
			$h2_font_size =  array_key_exists('h2-font-size', $fonts_opts) ? $fonts_opts['h2-font-size'] : '';
			$h2_weight =  array_key_exists('h2-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-weight']) : '';
			$h2_style =  array_key_exists('h2-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-style']) : '';
			$h2_texttransform =  array_key_exists('h2-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-texttransform']) : '';
			$h2_lineheight =  array_key_exists('h2-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-lineheight']) : '';
			$h2_letterspacing =  array_key_exists('h2-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h2-letterspacing']) : '';

			$h3_font =  array_key_exists('h3-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-font']) : '';
			$h3_font_size =  array_key_exists('h3-font-size', $fonts_opts) ? $fonts_opts['h3-font-size'] : '';
			$h3_weight =  array_key_exists('h3-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-weight']) : '';
			$h3_style =  array_key_exists('h3-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-style']) : '';
			$h3_texttransform =  array_key_exists('h3-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-texttransform']) : '';
			$h3_lineheight =  array_key_exists('h3-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-lineheight']) : '';
			$h3_letterspacing =  array_key_exists('h3-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h3-letterspacing']) : '';

			$h4_font =  array_key_exists('h4-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-font']) : '';
			$h4_font_size =  array_key_exists('h4-font-size', $fonts_opts) ? $fonts_opts['h4-font-size'] : '';
			$h4_weight =  array_key_exists('h4-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-weight']) : '';
			$h4_style =  array_key_exists('h4-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-style']) : '';
			$h4_texttransform =  array_key_exists('h4-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-texttransform']) : '';
			$h4_lineheight =  array_key_exists('h4-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-lineheight']) : '';
			$h4_letterspacing =  array_key_exists('h4-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h4-letterspacing']) : '';

			$h5_font =  array_key_exists('h5-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-font']) : '';
			$h5_font_size =  array_key_exists('h5-font-size', $fonts_opts) ? $fonts_opts['h5-font-size'] : '';
			$h5_weight =  array_key_exists('h5-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-weight']) : '';
			$h5_style =  array_key_exists('h5-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-style']) : '';
			$h5_texttransform =  array_key_exists('h5-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-texttransform']) : '';
			$h5_lineheight =  array_key_exists('h5-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-lineheight']) : '';
			$h5_letterspacing =  array_key_exists('h5-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h5-letterspacing']) : '';

			$h6_font =  array_key_exists('h6-font', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-font']) : '';
			$h6_font_size =  array_key_exists('h6-font-size', $fonts_opts) ? $fonts_opts['h6-font-size'] : '';
			$h6_weight =  array_key_exists('h6-weight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-weight']) : '';
			$h6_style =  array_key_exists('h6-style', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-style']) : '';
			$h6_texttransform =  array_key_exists('h6-texttransform', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-texttransform']) : '';
			$h6_lineheight =  array_key_exists('h6-lineheight', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-lineheight']) : '';
			$h6_letterspacing =  array_key_exists('h6-letterspacing', $fonts_opts) ? str_replace('#', '', $fonts_opts['h6-letterspacing']) : '';
					
			if(
				$content_font != '' || ($content_font_size != '' && $content_font_size != 0) || $content_weight != '' || $content_style != '' ||
				$menu_font != '' || ($menu_font_size != '' && $menu_font_size != 0) || $menu_weight != '' || $menu_style != '' || $menu_texttransform != '' ||
				$submenu_font != '' || ($submenu_font_size != '' && $submenu_font_size != 0) || $submenu_weight != '' || $submenu_style != '' || $submenu_texttransform != '' ||
				$pagetitle_font != '' || ($pagetitle_font_size != '' && $pagetitle_font_size != 0) || $pagetitle_weight != '' || $pagetitle_style != '' || $pagetitle_texttransform != '' ||
				$h1_font != '' || ($h1_font_size != '' && $h1_font_size != 0) || $h1_weight != '' || $h1_style != '' || $h1_texttransform != '' || $h1_lineheight != '' || $h1_letterspacing != '' ||
				$h2_font != '' || ($h2_font_size != '' && $h2_font_size != 0) || $h2_weight != '' || $h2_style != '' || $h2_texttransform != '' || $h2_lineheight != '' || $h2_letterspacing != '' ||
				$h3_font != '' || ($h3_font_size != '' && $h3_font_size != 0) || $h3_weight != '' || $h3_style != '' || $h3_texttransform != '' || $h3_lineheight != '' || $h3_letterspacing != '' ||
				$h4_font != '' || ($h4_font_size != '' && $h4_font_size != 0) || $h4_weight != '' || $h4_style != '' || $h4_texttransform != '' || $h4_lineheight != '' || $h4_letterspacing != '' ||
				$h5_font != '' || ($h5_font_size != '' && $h5_font_size != 0) || $h5_weight != '' || $h5_style != '' || $h5_texttransform != '' || $h5_lineheight != '' || $h5_letterspacing != '' ||
				$h6_font != '' || ($h6_font_size != '' && $h6_font_size != 0) || $h6_weight != '' || $h6_style != '' || $h6_texttransform != '' || $h6_lineheight != '' || $h6_letterspacing != ''
			) 
			{
	
				echo '<style>';
	
				// Content
				if($content_font != '' || ($content_font_size != '' && $content_font_size != 0) || $content_weight != '' || $content_style != '') {
					
					echo 'body { ';
					
						if($content_font != '') echo 'font-family:'.$content_font.';'."\n";
						if($content_font_size != '' && $content_font_size != 0) echo 'font-size:'.$content_font_size.'px;'."\n";
						if($content_weight != '') echo 'font-weight:'.$content_weight.';'."\n";
						if($content_style != '') echo 'font-style:'.$content_style.';'."\n";
					
					echo ' }'."\n";	
				}	
				if($content_lineheight != '') echo 'body p { line-height:'.$content_lineheight.'px; }'."\n";
				
	
				// Menu
				if($menu_font != '' || ($menu_font_size != '' && $menu_font_size != 0) || $menu_weight != '' || $menu_style != '' || $menu_texttransform != '') {
					
					echo '#main-menu > ul > li > a { ';
					
						if($menu_font != '') echo 'font-family:'.$menu_font.';'."\n";
						if($menu_font_size != '' && $menu_font_size != 0) echo 'font-size:'.$menu_font_size.'px;'."\n";
						if($menu_weight != '') echo 'font-weight:'.$menu_weight.';'."\n";
						if($menu_style != '') echo 'font-style:'.$menu_style.';'."\n";
						if($menu_texttransform != '') echo 'text-transform:'.$menu_texttransform.';'."\n";
					
					echo ' }'."\n";	
				}
					
				// Sub Menu
				if($submenu_font != '' || ($submenu_font_size != '' && $submenu_font_size != 0) || $submenu_weight != '' || $submenu_style != '' || $submenu_texttransform != '') {
					
					echo '#main-menu ul li.menu-item-simple-parent ul li a, .megamenu-child-container > ul.sub-menu > li > a, .megamenu-child-container > ul.sub-menu > li > .nolink-menu, #main-menu .megamenu-child-container ul.sub-menu > li > ul li a { ';
					
						if($submenu_font != '') echo 'font-family:'.$submenu_font.';'."\n";
						if($submenu_font_size != '' && $submenu_font_size != 0) echo 'font-size:'.$submenu_font_size.'px;'."\n";
						if($submenu_weight != '') echo 'font-weight:'.$submenu_weight.';'."\n";
						if($submenu_style != '') echo 'font-style:'.$submenu_style.';'."\n";
						if($submenu_texttransform != '') echo 'text-transform:'.$submenu_texttransform.';'."\n";
					
					echo ' }'."\n";	
				}
										
				// Page Title
				if($pagetitle_font != '' || ($pagetitle_font_size != '' && $pagetitle_font_size != 0) || $pagetitle_weight != '' || $pagetitle_style != '' || $pagetitle_texttransform != '') {
					
					echo '.main-title h1 { ';
					
						if($pagetitle_font != '') echo 'font-family:'.$pagetitle_font.';'."\n";
						if($pagetitle_font_size != '' && $pagetitle_font_size != 0) echo 'font-size:'.$pagetitle_font_size.'px;'."\n";
						if($pagetitle_weight != '') echo 'font-weight:'.$pagetitle_weight.';'."\n";
						if($pagetitle_style != '') echo 'font-style:'.$pagetitle_style.';'."\n";
						if($pagetitle_texttransform != '') echo 'text-transform:'.$pagetitle_texttransform.';'."\n";
					
					echo ' }'."\n";	
				}
				
	
				// Heading H1
				if($h1_font != '' || ($h1_font_size != '' && $h1_font_size != 0) || $h1_weight != '' || $h1_style != '' || $h1_texttransform != '' || $h1_lineheight != '' || $h1_letterspacing != '') {
					
					echo 'h1 { ';
					
						if($h1_font != '') echo 'font-family:'.$h1_font.';'."\n";
						if($h1_font_size != '' && $h1_font_size != 0) echo 'font-size:'.$h1_font_size.'px;'."\n";
						if($h1_weight != '') echo 'font-weight:'.$h1_weight.';'."\n";
						if($h1_style != '') echo 'font-style:'.$h1_style.';'."\n";
						if($h1_texttransform != '') echo 'text-transform:'.$h1_texttransform.';'."\n";
						if($h1_lineheight != '') echo 'line-height:'.$h1_lineheight.'px;'."\n";
						if($h1_letterspacing != '') echo 'letter-spacing:'.$h1_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
				
	
				// Heading H2
				if($h2_font != '' || ($h2_font_size != '' && $h2_font_size != 0) || $h2_weight != '' || $h2_style != '' || $h2_texttransform != '' || $h2_lineheight != '' || $h2_letterspacing != '') {
					
					echo 'h2 { ';
					
						if($h2_font != '') echo 'font-family:'.$h2_font.';'."\n";
						if($h2_font_size != '' && $h2_font_size != 0) echo 'font-size:'.$h2_font_size.'px;'."\n";
						if($h2_weight != '') echo 'font-weight:'.$h2_weight.';'."\n";
						if($h2_style != '') echo 'font-style:'.$h2_style.';'."\n";
						if($h2_texttransform != '') echo 'text-transform:'.$h2_texttransform.';'."\n";
						if($h2_lineheight != '') echo 'line-height:'.$h2_lineheight.'px;'."\n";
						if($h2_letterspacing != '') echo 'letter-spacing:'.$h2_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
	
				// Heading H3
				if($h3_font != '' || ($h3_font_size != '' && $h3_font_size != 0) || $h3_weight != '' || $h3_style != '' || $h3_texttransform != '' || $h3_lineheight != '' || $h3_letterspacing != '') {
					
					echo 'h3 { ';
					
						if($h3_font != '') echo 'font-family:'.$h3_font.';'."\n";
						if($h3_font_size != '' && $h3_font_size != 0) echo 'font-size:'.$h3_font_size.'px;'."\n";
						if($h3_weight != '') echo 'font-weight:'.$h3_weight.';'."\n";
						if($h3_style != '') echo 'font-style:'.$h3_style.';'."\n";
						if($h3_texttransform != '') echo 'text-transform:'.$h3_texttransform.';'."\n";
						if($h3_lineheight != '') echo 'line-height:'.$h3_lineheight.'px;'."\n";
						if($h3_letterspacing != '') echo 'letter-spacing:'.$h3_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
	
				// Heading H4
				if($h4_font != '' || ($h4_font_size != '' && $h4_font_size != 0) || $h4_weight != '' || $h4_style != '' || $h4_texttransform != '' || $h4_lineheight != '' || $h4_letterspacing != '') {
					
					echo 'h4 { ';
					
						if($h4_font != '') echo 'font-family:'.$h4_font.';'."\n";
						if($h4_font_size != '' && $h4_font_size != 0) echo 'font-size:'.$h4_font_size.'px;'."\n";
						if($h4_weight != '') echo 'font-weight:'.$h4_weight.';'."\n";
						if($h4_style != '') echo 'font-style:'.$h4_style.';'."\n";
						if($h4_texttransform != '') echo 'text-transform:'.$h4_texttransform.';'."\n";
						if($h4_lineheight != '') echo 'line-height:'.$h4_lineheight.'px;'."\n";
						if($h4_letterspacing != '') echo 'letter-spacing:'.$h4_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
	
				// Heading H5
				if($h5_font != '' || ($h5_font_size != '' && $h5_font_size != 0) || $h5_weight != '' || $h5_style != '' || $h5_texttransform != '' || $h5_lineheight != '' || $h5_letterspacing != '') {
					
					echo 'h5 { ';
					
						if($h5_font != '') echo 'font-family:'.$h5_font.';'."\n";
						if($h5_font_size != '' && $h5_font_size != 0) echo 'font-size:'.$h5_font_size.'px;'."\n";
						if($h5_weight != '') echo 'font-weight:'.$h5_weight.';'."\n";
						if($h5_style != '') echo 'font-style:'.$h5_style.';'."\n";
						if($h5_texttransform != '') echo 'text-transform:'.$h5_texttransform.';'."\n";
						if($h5_lineheight != '') echo 'line-height:'.$h5_lineheight.'px;'."\n";
						if($h5_letterspacing != '') echo 'letter-spacing:'.$h5_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
	
				// Heading H6
				if($h6_font != '' || ($h6_font_size != '' && $h6_font_size != 0) || $h6_weight != '' || $h6_style != '' || $h6_texttransform != '' || $h6_lineheight != '' || $h6_letterspacing != '') {
					
					echo 'h6 { ';
					
						if($h6_font != '') echo 'font-family:'.$h6_font.';'."\n";
						if($h6_font_size != '' && $h6_font_size != 0) echo 'font-size:'.$h6_font_size.'px;'."\n";
						if($h6_weight != '') echo 'font-weight:'.$h6_weight.';'."\n";
						if($h6_style != '') echo 'font-style:'.$h6_style.';'."\n";
						if($h6_texttransform != '') echo 'text-transform:'.$h6_texttransform.';'."\n";
						if($h6_lineheight != '') echo 'line-height:'.$h6_lineheight.'px;'."\n";
						if($h6_letterspacing != '') echo 'letter-spacing:'.$h6_letterspacing.'px;'."\n";
					
					echo ' }'."\n";	
				}
				
				echo '</style>';
			
			}
		
		}
		
	}
	add_action( 'wp_head', 'painting_template_page_colors' );
}

?>