<?php

/* ---------------------------------------------------------------------------
 * Theme support
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_features')) {

	function painting_features() {
		
		if( false ) { add_editor_style( '/css/editor-style.css' ); }
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
		add_theme_support( 'post-formats', array('status', 'quote', 'gallery', 'image', 'video', 'audio', 'link', 'aside', 'chat'));

		# post thumbnails
		if ( function_exists( 'add_theme_support' ) ) {
			add_theme_support( 'post-thumbnails', array('post', 'page', 'tribe_events', 'product'));
			add_image_size('painting-1170x800', 1170, 800, true);
			add_image_size('painting-70x70', 70, 70, true);
			add_image_size('painting-1200x800', 1200, 800, true);
			add_image_size('painting-80x80', 80, 80, true);
		}
		
		# add custom background
		$args = array('default-color' => 'ffffff', 'default-image' => '', 'wp-head-callback' => '_custom_background_cb', 'admin-head-callback' => '', 'admin-preview-callback' => '');
		add_theme_support('custom-background', $args);

		# add custom header
		$args = array('default-image' => '', 'random-default' => false, 'width' => 0, 'height' => 0, 'flex-height' => false, 'flex-width' => false, 'default-text-color' => '', 'header-text' => false, 'uploads' => true, 'wp-head-callback' => '', 'admin-head-callback' => '', 'admin-preview-callback' => '');
		add_theme_support('custom-header', $args);
		
	}
	add_action('after_setup_theme', 'painting_features');
}

/* ---------------------------------------------------------------------------
 *	Set Max Content Width
 * --------------------------------------------------------------------------- */
if ( ! isset( $content_width ) ) $content_width = 1170;

/* ---------------------------------------------------------------------------
 * Get Current Page or Page ID
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_ID')) {
function painting_ID(){
	global $post;
	$postID = false;

	if( ! is_404() && ! is_search() ){

		if( function_exists('is_woocommerce') && is_woocommerce() ){
			// woocommerce
			$postID = wc_get_page_id( 'shop' );
		} elseif( isset($post) && $post->ID == 0 ) {
			$postID = get_queried_object_id();
		} else {
			// default
			$postID = get_the_ID();
		}
	}

	return $postID;
}
}

/* ---------------------------------------------------------------------------
 * Get Layer or Revolution Slider
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_slider')) {
function painting_slider(){
	
	$slider = false;
	$id = painting_ID();

	if( $id || is_home() || get_post_type() == 'page' ) {
		
		$slider_key = get_post_meta( $id, '_tpl_default_settings', true );
		
		if(is_array($slider_key) && array_key_exists( 'show_slider', $slider_key )) {
			
			if($slider_key['slider_type'] == 'revolutionslider') {
				
				$slider = '<div class="dt-sc-main-slider" id="dt-sc-rev-slider">';
					$slider .= do_shortcode('[rev_slider '. $slider_key['revolutionslider_id'] .']');
				$slider .= '</div>';
				
			} else if($slider_key['slider_type'] == 'layerslider') {
				
				$slider = '<div class="dt-sc-main-slider" id="dt-sc-layer-slider">';
					$slider .= do_shortcode('[layerslider id="'. $slider_key['layerslider_id'] .'"]');
				$slider .= '</div>';
				
			} else if($slider_key['slider_type'] == 'imageonly') {
				
				$slider = '<div class="dt-sc-main-slider" id="dt-sc-custom-slider">';
					$slider .= '<img src="'.$slider_key['slider_image'].'" alt="'.esc_html__('Slider Image', 'painting').'"/>';
				$slider .= '</div>';
				
			}
			
		}
		
	}
	return $slider;
}
}

/* ---------------------------------------------------------------------------
 * Subtitle Section For All Pages / Posts
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_subtitle_section')) {
function painting_subtitle_section($id=0,$type,$settings = array() ){
	
	$title = '';
	if( $id > 0 ){

		$title = get_the_title($id);

		if( $type === "post" )
			$settings = '_dt_post_settings';
		elseif( $type === "page")
			$settings = '_tpl_default_settings';
		elseif( $type === "dt_portfolios" )
			$settings = '_portfolio_settings';

		$settings = get_post_meta( $id, $settings, TRUE );
		$settings = is_array($settings) ? $settings : array();
	}

	if ( !array_key_exists('disable-breadcrumb-section', $settings) ) :		
	
		$style = '';
		$breadcrumb_overlay = $breadcrumb_background_image = $breadcrumb_background_image_position = $breadcrumb_background_image_position_str = $breadcrumb_background_image_repeat = $breadcrumb_background_color = $breadcrumb_background_color_opacity = $breadcrumb_parallax = '';
		
		if ( array_key_exists('enable-breadcrumb-settings', $settings) ) {
			
			 if(array_key_exists('breadcrumb-overlay', $settings)) { $breadcrumb_overlay = $settings['breadcrumb-overlay']; }
			 if(array_key_exists('breadcrumb-background-image', $settings)) { $breadcrumb_background_image = 'background-image:url('.$settings['breadcrumb-background-image'].');'; }
			 if(array_key_exists('breadcrumb-background-image-position', $settings)) { 
			 	$breadcrumb_background_image_position_str = $settings['breadcrumb-background-image-position'];
			 	$breadcrumb_background_image_position = 'background-position:'.$settings['breadcrumb-background-image-position'].');'; 
			}
			 if(array_key_exists('breadcrumb-background-image-repeat', $settings)) { $breadcrumb_background_image_repeat = 'background-repeat:'.$settings['breadcrumb-background-image-repeat'].');'; }
			 
			if(array_key_exists('breadcrumb-background-color', $settings)) {
				if(array_key_exists('breadcrumb-background-color-opacity', $settings)) { 
					$rgb = painting_hex2rgb($settings['breadcrumb-background-color']); 
					$breadcrumb_background_color = 'background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$settings['breadcrumb-background-color-opacity'].');';
				} else {
					$breadcrumb_background_color = 'background-color:'.$settings['breadcrumb-background-color'].';';
				}
			}
			 
			 if(array_key_exists('enable-breadcrumb-parallax', $settings)) { $breadcrumb_parallax = 'dt-sc-parallax'; }
			 
			 if(array_key_exists('breadcrumb-delimiter', $settings)) { $breadcrumb_delimiter = $settings['breadcrumb-delimiter']; }
			
		} else {
			
			if(painting_option('layout','breadcrumb-overlay') != '') { $breadcrumb_overlay = painting_option('layout','breadcrumb-overlay'); }
			if(painting_option('layout','breadcrumb-bg-image') != '') { $breadcrumb_background_image = 'background-image:url('.painting_option('layout','breadcrumb-bg-image').');'; }
			if(painting_option('layout','breadcrumb-bg-image-position') != '') { 
				$breadcrumb_background_image_position_str = painting_option('layout','breadcrumb-bg-image-position');
				$breadcrumb_background_image_position = 'background-position:'.painting_option('layout','breadcrumb-bg-image-position').');'; 
			}
			if(painting_option('layout','breadcrumb-bg-image-repeat') != '') { $breadcrumb_background_image_repeat = 'background-repeat:'.painting_option('layout','breadcrumb-bg-image-repeat').');'; }
			
			if(painting_option('layout','breadcrumb-bgcolor') != '') {
				if(painting_option('layout','breadcrumb-bgcolor-opacity') != '') { 
					$rgb = painting_hex2rgb(painting_option('layout','breadcrumb-bgcolor')); 
					$breadcrumb_background_color = 'background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.painting_option('layout','breadcrumb-bgcolor-opacity').');';
				} else {
					$breadcrumb_background_color = 'background-color:'.painting_option('layout','breadcrumb-bgcolor').';';
				}
			}
			
			if(painting_option('layout','breadcrumb-enable-parallax') != '') { $breadcrumb_parallax = 'dt-sc-parallax'; }
			if(painting_option('layout','breadcrumb-delimiter') != '') { $breadcrumb_delimiter = painting_option('layout','breadcrumb-delimiter'); }
			
		}
		
		$styles_first = $styles_second = array();
		
		if($breadcrumb_overlay == 'color-overlay') {
			
			$styles_first[] = $breadcrumb_background_image;
			$styles_first[] = $breadcrumb_background_image_position;
			$styles_first[] = $breadcrumb_background_image_repeat;
			
			$styles_second[] = $breadcrumb_background_color;
			
		} else {
			
			$styles_first[] = $breadcrumb_background_image;
			$styles_first[] = $breadcrumb_background_image_position;
			$styles_first[] = $breadcrumb_background_image_repeat;
			$styles_first[] = $breadcrumb_background_color;
			
		}
		
		$parallax_attribute = '';
		if($breadcrumb_parallax == 'dt-sc-parallax') {
			$styles_first[] = 'background-attachment:fixed;';
			if($breadcrumb_background_image_position_str != '') { $parallax_attribute = 'data-position="'.$breadcrumb_background_image_position_str.'"'; }
			else { $parallax_attribute = 'data-position="left top"'; }
		}
		
		$styles_first = array_filter($styles_first);
		$style_first = join('', array_unique($styles_first));
		$style_first = !empty($style_first) ? 'style="'.$style_first.'"' : '';
		
		$styles_second = array_filter($styles_second);
		$style_second = join('', array_unique($styles_second));
		$style_second = !empty($style_second) ? 'style="'.$style_second.'"' : '';
		
		echo '<div class="full-width-section breadcrumb-wrapper '.$breadcrumb_parallax.'" '.$style_first.' '.$parallax_attribute.'>';
			echo '<div class="full-width-section-inner " '.$style_second.'>';
			
				  echo '<div class="container">
							<div class="main-title">';
							
								if ( is_front_page() || is_home() ) {
									echo '<h1>'.get_bloginfo('description').'</h1>';
								} else {
									if(!isset($disable_breadcrumb)) { painting_breadcrumbs($breadcrumb_delimiter); }
									echo '<h1>'.esc_html($title).'</h1>';
								}
							
					   echo '</div>
					   </div>';
		  	
			echo '</div>';
        echo '</div>';		
	
	endif;	
	
}
}

/* ---------------------------------------------------------------------------
 * Custom Subtitle Section For Archive Pages
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_custom_subtitle_section')) {
function painting_custom_subtitle_section( $title ){
	
	$style = '';
	$breadcrumb_overlay = $breadcrumb_background_image = $breadcrumb_background_image_position = $breadcrumb_background_image_position_str = $breadcrumb_background_image_repeat = $breadcrumb_background_color = $breadcrumb_background_color_opacity = $breadcrumb_parallax = '';

	if(painting_option('layout','breadcrumb-overlay') != '') { $breadcrumb_overlay = painting_option('layout','breadcrumb-overlay'); }
	if(painting_option('layout','breadcrumb-bg-image') != '') { $breadcrumb_background_image = 'background-image:url('.painting_option('layout','breadcrumb-bg-image').');'; }
	if(painting_option('layout','breadcrumb-bg-image-position') != '') { 
		$breadcrumb_background_image_position_str = painting_option('layout','breadcrumb-bg-image-position');
		$breadcrumb_background_image_position = 'background-position:'.painting_option('layout','breadcrumb-bg-image-position').');'; 
	}
	if(painting_option('layout','breadcrumb-bg-image-repeat') != '') { $breadcrumb_background_image_repeat = 'background-repeat:'.painting_option('layout','breadcrumb-bg-image-repeat').');'; }
	
	if(painting_option('layout','breadcrumb-bgcolor') != '') {
		if(painting_option('layout','breadcrumb-bgcolor-opacity') != '') { 
			$rgb = painting_hex2rgb(painting_option('layout','breadcrumb-bgcolor')); 
			$breadcrumb_background_color = 'background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.painting_option('layout','breadcrumb-bgcolor-opacity').');';
		} else {
			$breadcrumb_background_color = 'background-color:'.painting_option('layout','breadcrumb-bgcolor').';';
		}
	}
	
	if(painting_option('layout','breadcrumb-enable-parallax') != '') { $breadcrumb_parallax = 'dt-sc-parallax'; }
	if(painting_option('layout','breadcrumb-delimiter') != '') { $breadcrumb_delimiter = painting_option('layout','breadcrumb-delimiter'); }
			
	$styles_first = $styles_second = array();
	
	if($breadcrumb_overlay == 'color-overlay') {
	
		$styles_first[] = $breadcrumb_background_image;
		$styles_first[] = $breadcrumb_background_image_position;
		$styles_first[] = $breadcrumb_background_image_repeat;
		
		$styles_second[] = $breadcrumb_background_color;
	
	} else {
	
		$styles_first[] = $breadcrumb_background_image;
		$styles_first[] = $breadcrumb_background_image_position;
		$styles_first[] = $breadcrumb_background_image_repeat;
		$styles_first[] = $breadcrumb_background_color;
	
	}
	
	$parallax_attribute = '';
	if($breadcrumb_parallax == 'dt-sc-parallax') {
		$styles_first[] = 'background-attachment:fixed;';
		if($breadcrumb_background_image_position_str != '') { $parallax_attribute = 'data-position="'.$breadcrumb_background_image_position_str.'"'; }
		else { $parallax_attribute = 'data-position="left top"'; }
	}
	
	$styles_first = array_filter($styles_first);
	$style_first = join('', array_unique($styles_first));
	$style_first = !empty($style_first) ? 'style="'.$style_first.'"' : '';
	
	$styles_second = array_filter($styles_second);
	$style_second = join('', array_unique($styles_second));
	$style_second = !empty($style_second) ? 'style="'.$style_second.'"' : '';
	
	echo '<div class="full-width-section breadcrumb-wrapper '.$breadcrumb_parallax.'" '.$style_first.' '.$parallax_attribute.'>';
		echo '<div class="full-width-section-inner " '.$style_second.'>';
		
			  echo '<div class="container">
						<div class="main-title">';
						
							if ( is_front_page() || is_home() ) {
								echo '<h1>'.get_bloginfo('description').'</h1>';
							} else {
								if(!isset($disable_breadcrumb)) { painting_breadcrumbs($breadcrumb_delimiter); }
								echo '<h1>'.esc_html($title).'</h1>';
							}
						
				   echo '</div>
				   </div>';
		
		echo '</div>';
	echo '</div>';		

}
}
/* ---------------------------------------------------------------------------
 * Breadcrumbs
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_breadcrumbs')) {
function painting_breadcrumbs($breadcrumb_delimiter){
	global $post;
	
	$homeLink = esc_url(home_url('/'));
	
	$delimiter = 'fa '.$breadcrumb_delimiter;
	if($delimiter == 'fa default') $separator = ' <span class="fa fa-angle-right"></span>';
	else $separator = ' <span class="'.$delimiter.'"></span>';
	
	$breadcrumbs = array();
	$breadcrumbs[] =  '<a href="'. $homeLink .'">'. esc_html__('Home','painting') .'</a>';
	
	// blog -----------------------------------------------
	if( get_post_type() == 'post' ){
		
		$blogID = false;
		if( get_option( 'page_for_posts' ) ){
			$blogID = get_option( 'page_for_posts' );	// setings > reading
		}
		if( $blogID ) $breadcrumbs[] = '<span class="current">'. get_the_title( $blogID ) .'</span>';
	}
	
	if( is_front_page() ){

		// do nothing

	} elseif( is_tag() ){
		
		$breadcrumbs[] = '<span class="current">' . single_tag_title('', false) . '</span>';
		
	} elseif( is_category() ){
		
		$breadcrumbs[] = '<span class="current">' . single_cat_title('', false) . '</span>';
		
	} elseif( is_author() ){

		$breadcrumbs[] = '<span class="current">' . get_the_author() . '</span>';

	} elseif( is_day() ){

		$breadcrumbs[] = '<a href="'. get_year_link( get_the_time('Y') ) . '">'. get_the_time('Y') .'</a>';
		$breadcrumbs[] = '<a href="'. get_month_link( get_the_time('Y'), get_the_time('m') ) .'">'. get_the_time('F') .'</a>';
		$breadcrumbs[] = '<span class="current">'. get_the_time('d') .'</span>';

	} elseif( is_month() ){

		$breadcrumbs[] = '<a href="' . get_year_link( get_the_time('Y') ) . '">' . get_the_time('Y') . '</a>';
		$breadcrumbs[] = '<span class="current">'. get_the_time('F') .'</span>';

	} elseif( is_year() ){

		$breadcrumbs[] = '<span class="current">'. get_the_time('Y') .'</span>';

	} elseif( is_single() && ! is_attachment() ){

		if( get_post_type() == 'dt_portfolios' ){
			
			$cat = get_the_term_list(painting_ID(), 'portfolio_entries', '', '$$$', '');
			$cats = array_filter(explode('$$$', $cat));
			if (!empty($cats))
				$breadcrumbs[] = $cats[0];
		
			$breadcrumbs[] = '<span class="current">'. get_the_title().'</span>';

		} else if(get_post_type() == 'product') {
			
			$terms = get_the_term_list(painting_ID(), 'product_cat', '', '$$$', '');
			$terms =  array_filter(explode('$$$',$terms));
			if( !empty($terms))
				$breadcrumbs[] = $terms[0];

			$breadcrumbs[] = '<span class="current">'. get_the_title().'</span>';

		} else {
			
			$cat = get_the_category();
			$cat = $cat[0];
			$breadcrumbs[] = get_category_parents( $cat, true, $separator );

			$breadcrumbs[] = '<span class="current">'. get_the_title() .'</span>';
			
		}
		
	} else if(is_post_type_archive('product')) {
			
		$breadcrumbs[] = '<span class="current">' .  get_the_title( painting_ID() ) . '</span>';
		
	} else if(class_exists('DTPropertyAddon') && is_post_type_archive('dt_properties')) {

		$breadcrumbs[] = '<span class="current">' .  esc_html__("Properties", 'painting') . '</span>';
		
	} elseif( is_404() ) {
		
		$breadcrumbs[] = '<span class="current">' . esc_html__('Lost', 'painting') . '</span>';
		
	} elseif( is_search() ) {
		
		$breadcrumbs[] = '<span class="current">' . esc_html__('Search Results', 'painting') . '</span>';
				
	} elseif( get_post_taxonomies() ){
			
		$breadcrumbs[] = '<span class="current">' . single_cat_title('', false) . '</span>';
	
	} elseif( is_page() && $post->post_parent ){
		
		$parent_id  = $post->post_parent;
		$parents = array();
			
		while( $parent_id ) {
			$page = get_page( $parent_id );
			$parents[] = '<a href="' . get_permalink( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a>';
			$parent_id  = $page->post_parent;
		}
		$parents = array_reverse( $parents );
		$breadcrumbs = array_merge_recursive($breadcrumbs, $parents);
			
		$breadcrumbs[] = '<span class="current">'. get_the_title( painting_ID() ) .'</span>';
	
	} else {
		
		$breadcrumbs[] = '<span class="current">'. get_the_title( painting_ID() ) .'</span>';
		
	}

	echo '<div class="breadcrumb">';
		$count = count( $breadcrumbs );
		$i = 1;

		foreach( $breadcrumbs as $bk => $bc ){
			if( strpos( $bc , $separator ) ) {
				// category parents fix
				echo painting_wp_kses($bc);
			} else {
				if( $i == $count ) $separator = '';
				echo painting_wp_kses($bc . $separator);
			}
			$i++;
		}
	echo '</div>';
}
}

/* ---------------------------------------------------------------------------
 * Function To Render Site Logo Or Ttile
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_fetch_logoortitle')) {
function painting_fetch_logoortitle()
{
	
	global $dtenable_general_settings, $dttemplate_general_settings;
	if($dtenable_general_settings && isset($dttemplate_general_settings['template-logo']) && $dttemplate_general_settings['template-logo'] != '') {
		$dt_enable_logo = true;
		$logo_url = isset($dttemplate_general_settings['template-logo']) ? $dttemplate_general_settings['template-logo'] : painting_option('layout', 'logo-url');
		$retina_logo_url = isset($dttemplate_general_settings['template-retina-logo']) ? $dttemplate_general_settings['template-retina-logo'] : painting_option('layout', 'retina-logo-url');
		$retina_logo_width = isset($dttemplate_general_settings['template-retina-logo-width']) ? $dttemplate_general_settings['template-retina-logo-width'] : painting_option('layout', 'retina-logo-width');
		$retina_logo_height = isset($dttemplate_general_settings['template-retina-logo-height']) ? $dttemplate_general_settings['template-retina-logo-height'] : painting_option('layout', 'retina-logo-height');
	} else if(painting_option('layout', 'logo') != '') {
		$dt_enable_logo = true;
		$logo_url = painting_option('layout', 'logo-url');
		$retina_logo_url = painting_option('layout', 'retina-logo-url');
		$retina_logo_width = painting_option('layout','retina-logo-width');
		$retina_logo_height = painting_option('layout','retina-logo-height');
	} else {
		$dt_enable_logo = false;
	}

	if(!empty($logo_url)) {
		$logo_url = $logo_url; $logo_width = ''; $logo_height = '';
	} else {
		$logo_url = PAINTING_URI."/images/logo.png"; $logo_width = '114'; $logo_height = '29';
	}
	
	if(!empty($retina_logo_url)) {
		$retina_logo_url = $retina_logo_url; $retina_logo_width = $retina_logo_width; $retina_logo_height = $retina_logo_height;
	} else {
		$retina_logo_url = PAINTING_URI."/images/logo@2x.png"; $retina_logo_width = '228'; $retina_logo_height = '58';
	}
	
	if($dt_enable_logo) {
		echo '<a href="'.esc_url(home_url('/')).'" title="'.painting_blog_title().'">
				<img class="normal_logo" src="'.esc_url($logo_url).'" alt="'.painting_blog_title().'" title="'.painting_blog_title().'" width="'.esc_attr($logo_width).'" height="'.esc_attr($logo_height).'" />
				<img class="retina_logo" src="'.esc_url($retina_logo_url).'" alt="'.painting_blog_title().'" title="'.painting_blog_title().'" style="width:'.esc_attr($retina_logo_width).'px; height:'.esc_attr($retina_logo_height).'px;" width="'.esc_attr($retina_logo_width).'" height="'.esc_attr($retina_logo_height).'" />
			</a>';
	} else {
		echo '<h2><a href="'.esc_url(home_url('/')).'" title="'.painting_blog_title().'">'.do_shortcode(get_option('blogname')).'</a></h2>';
	}

}
}
/* ---------------------------------------------------------------------------
 * Ajax Function For portfolio To Load More Posts
 * --------------------------------------------------------------------------- */
add_action("wp_ajax_painting_ajax_load_portfolio_posts", "painting_ajax_load_portfolio_posts");
add_action("wp_ajax_nopriv_painting_ajax_load_portfolio_posts", "painting_ajax_load_portfolio_posts");
if (!function_exists('painting_ajax_load_portfolio_posts')) {
function painting_ajax_load_portfolio_posts() {

	$out = '';
	
	$postperpage = $_REQUEST['postperpage'];
	$postlayout = $_REQUEST['postlayout'];
	$page = $_REQUEST['page'];
	$filter = $_REQUEST['filter'];
	$tax = (!empty($_REQUEST['tax'])) ? explode(',', $_REQUEST['tax']) : '';
	$portfoliotype = $_REQUEST['portfoliotype'];
	
	switch($postlayout):
		case 'one-column';
			$post_class = "portfolio column dt-sc-one-column ";
			$columns = 2;
		break;

		case 'one-half-column';
			$post_class = "portfolio column dt-sc-one-half ";
			$columns = 2;
		break;
		
		case 'one-third-column':
			$post_class = "portfolio column dt-sc-one-third ";
			$columns = 3;
		break;
	
		case 'one-fourth-column':
			$post_class = "portfolio column dt-sc-one-fourth";
			$columns = 4;
		break;
	endswitch;			
	

	if($tax != ''):
		$args = array('post_type' => 'dt_portfolios', 'paged' => $page, 'posts_per_page' => $postperpage, 'post_status' => 'publish', 'offset' => ($postperpage * ($page-1)), 'orderby' => 'ID', 'order' => 'ASC', 'tax_query' => array( array( 'taxonomy' => 'portfolio_entries', 'field' => 'id', 'operator'=>'IN', 'terms' => $tax )));
	else:
		$args = array('post_type' => 'dt_portfolios', 'paged' => $page , 'posts_per_page' => $postperpage, 'post_status' => 'publish', 'offset' => ($postperpage * ($page-1)), 'orderby' => 'ID', 'order' => 'ASC');
	endif;
	
	$the_query = new WP_Query($args);
	if($the_query->have_posts()): 
		$i = 1;
		while($the_query->have_posts()): $the_query->the_post();
	
			$temp_class = $post_class;

			$the_id = get_the_ID();

			$portfolio_item_meta = get_post_meta($the_id,'_portfolio_settings',TRUE);
			$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();

			#Find sort class by using the portfolio_entries
			$sort = " ";
			if( $filter == 'true' ):
				$post_class .= ' all-sort ';
				$item_categories = get_the_terms( $the_id, 'portfolio_entries' );
				if(is_object($item_categories) || is_array($item_categories)):
					foreach ($item_categories as $category):
						$cat_slug = str_replace(' ', '-', $category->name);
						$sort .= $cat_slug.'-sort ';
					endforeach;
				endif;
			 endif;
			 
			 $hover_color = array_key_exists('hover-color', $portfolio_item_meta) ? $portfolio_item_meta['hover-color'] : '';
			 $hover_style = '';
			 
			 if($hover_color != '') {
				 
				$hover_color_opacity = array_key_exists('hover-color-opacity', $portfolio_item_meta) ? $portfolio_item_meta['hover-color-opacity'] : '';
				
				$rgb = painting_hex2rgb($hover_color); 
				$hover_style = 'style="background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$hover_color_opacity.');"';
				
			 }
			 
			$out .= '<div id="portfolio-'.$the_id.'" class="'.$temp_class.$sort.'">
						<figure>';
							$popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title();
							if( array_key_exists('items_name', $portfolio_item_meta) ) {
							
								$item =  $portfolio_item_meta['items_name'][0];
								$popup = $portfolio_item_meta['items'][0];
							
								if( "video" === $item ) {
									$items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
									if( !empty($items) ) {
										$out .= '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';	
									} else {
										$out .= '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title().'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';
									}
								} else {
									$attachment_id = $portfolio_item_meta['items_id'][0];
									$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
									$out .= '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
								}
								
							} else {
								$out .= '<img src="'.esc_attr($popup).'" alt="" />';
							}
							if($portfoliotype == 'type2') $out .= '<div class="fhover"></div>';
					$out .= '<figcaption '.$hover_style.'>
								<div class="fig-content-wrapper">
									<div class="fig-content">
										<h5><a href="'.get_permalink().'">'.get_the_title().'</a></h5>'
										.get_the_term_list($the_id, 'portfolio_entries', '<p>', ', ', '</p>').'    
										<div class="fig-overlay">
											<a class="zoom" href="'.esc_url($popup).'" data-gal="prettyPhoto[gallery]" title="'.get_the_title().'"> <span class="fa fa-plus"> </span> </a>
											<a class="link" href="'.get_permalink().'" title="'.get_the_title().'"> <span class="fa fa-link"> </span> </a>
										</div>
									</div>
								</div>  
							</figcaption>
						</figure>
                    </div>';

        endwhile;
    else:
        $out = 'NoData';
    endif;
	
	
	if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
		echo ($out != '') ? $out : 'NoData';
	} 
	else {
		header("Location: ".$_SERVER["HTTP_REFERER"]);
	}
	die();

}
}

if (!function_exists('painting_get_global_variables')) {
function painting_get_global_variables($variable)
{
	
	global $post, $product, $woocommerce_loop, $wp_query;
	
	switch($variable)
	{
		case "post":
			return $post;
		break;	
		case "wp_query":
			return $wp_query;
		break;	
		case "product":
			return $product;
		break;	
		case "woocommerce_loop":
			return $woocommerce_loop;
		break;	
	}
	
	return false;
	
}
}
/* ---------------------------------------------------------------------------
* Whitelist Associate
* --------------------------------------------------------------------------- */
if ( ! function_exists( 'dt_theme_array_whitelist_assoc' ) ) {
	function dt_theme_array_whitelist_assoc( Array $array1, Array $array2 ) {
		if ( func_num_args() > 2 ) {
			$args = func_get_args();
			array_shift( $args );
			$array2 = call_user_func_array( 'array_merge', $args );
		}

		return array_intersect_key( $array1, array_flip( $array2 ) );
	}
}

/* ---------------------------------------------------------------------------
* Post Type Support
* --------------------------------------------------------------------------- */
add_filter( 'fw_ext_page_builder_supported_post_types', 'dt_theme_limit_post_types_support', 1 );

if (!function_exists('dt_theme_limit_post_types_support')) {
	function dt_theme_limit_post_types_support( $all_post_types ) {
		$white_listed_post_types = array( '' ); //allowed custom post type names
		$post_types              = dt_theme_array_whitelist_assoc( $all_post_types, $white_listed_post_types );
		return $post_types;
	} 

}

?>