<?php
/* ---------------------------------------------------------------------------
 * Registers some menu location to use with navigation menus.
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_navigation_menus')) {

	// register navigation menus
	function painting_navigation_menus() {
		$locations = array(
			'header-menu' => esc_html__('Header Menu', 'painting'),
			'footer-menu' => esc_html__('Footer Menu', 'painting'),
		);
		register_nav_menus($locations);
	}

	// hook into the 'init' action
	add_action('init', 'painting_navigation_menus');
}

/* ---------------------------------------------------------------------------
 * Header Menu Left
 * --------------------------------------------------------------------------- */
function painting_header_menu() 
{
	$args = array( 
		'container' 		=> false,
		'menu_class'		=> 'menu', 
		'fallback_cb'		=> 'painting_header_menu_default_pages', 
 		'theme_location'	=> 'header-menu',
		'depth' 			=> 0,
		'walker' 			=> new paintingFrontEndMenuWalker,
	);
	wp_nav_menu( $args ); 
	
}

function painting_header_menu_default_pages() {
	echo '<ul id="header-menu" class="menu">';
	$args = array(
		'depth' 		=> 0,
		'title_li' 		=> '',
		'echo' 			=> 0,
		'post_type' 	=> 'page',
		'post_status' 	=> 'publish'
	);
	$pages = wp_list_pages($args);
	if ($pages)
		echo painting_wp_kses($pages);
	echo '</ul>';
}

/* ---------------------------------------------------------------------------
 * Footer Menu
 * --------------------------------------------------------------------------- */
function painting_footer_menu() 
{
	$args = array( 
		'container' 		=> false,
		'menu_class'		=> 'footer-links', 
		'fallback_cb'		=> 'painting_footer_menu_default_pages', 
 		'theme_location'	=> 'footer-menu',
		'depth' 			=> 1,
		'walker' 			=> new paintingFrontEndMenuWalker,
	);
	wp_nav_menu( $args ); 
	
}

function painting_footer_menu_default_pages() {
	echo '<ul id="menu-footer-menu" class="footer-links">';
	$args = array(
		'depth' 		=> 1,
		'title_li' 		=> '',
		'echo' 			=> 0,
		'post_type' 	=> 'page',
		'post_status' 	=> 'publish'
	);
	$pages = wp_list_pages($args);
	if ($pages)
		echo painting_wp_kses($pages);
	echo '</ul>';
}
?>