<?php
	// Standard Left Sidebar
	register_sidebar(array(
		'name' 			=>	esc_html__('Standard | Left Sidebar', 'painting'),
		'id'			=>	'standard-sidebar-left',
		'description'	=>	esc_html__("Appears in the Left side of the page, one enabled.",'painting'),
		'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
		'after_widget' 	=> 	'</aside>',
		'before_title' 	=> 	'<h3 class="widgettitle">',
		'after_title' 	=> 	'</h3>'));

	// Standard Right Sidebar
	register_sidebar(array(
		'name' 			=>	esc_html__('Standard | Right Sidebar', 'painting'),
		'id'			=>	'standard-sidebar-right',
		'description'	=>	esc_html__("Appears in the Right side of the page, one enabled.",'painting'),
		'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
		'after_widget' 	=> 	'</aside>',
		'before_title' 	=> 	'<h3 class="widgettitle">',
		'after_title' 	=> 	'</h3>'));

	// custom widget area
	$widget_area = painting_option('widgetarea','custom');
	$widget_area = is_array($widget_area) ? $widget_area : array();
    $widget_area = array_filter($widget_area);
    foreach ($widget_area as $key => $value) {
    	$id = mb_convert_case($value['name'], MB_CASE_LOWER, "UTF-8");
    	$id = str_replace(" ", "-", $id);

    	register_sidebar(array(
		'name' 			=>	$value['name'],
		'id'			=>	$id,
		'description'   =>  esc_html__("Custom sidebar created in Theme Options.",'painting'),
		'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
		'after_widget' 	=> 	'</aside>',
		'before_title' 	=> 	'<h3 class="widgettitle">',
		'after_title' 	=> 	'</h3>'));
    }

	// post archives sidebar
	$layout = painting_option('pageoptions','post-archives-page-layout');
	$layout = !empty($layout) ? $layout : "content-full-width";
	switch($layout) :
		case 'with-left-sidebar':
			register_sidebar(array(
				'name' 			=>	esc_html__("Post Archives | Left Sidebar",'painting'),
				'id'			=>	'post-archives-sidebar-left',
				'description'   =>  esc_html__("Appears in the Left side of the Post Archives Page.",'painting'),
				'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
				'after_widget' 	=> 	'</aside>',
				'before_title' 	=> 	'<h3 class="widgettitle">',
				'after_title' 	=> 	'</h3>'));
		break;

		case 'with-right-sidebar':
			register_sidebar(array(
				'name' 			=>	esc_html__("Post Archives | Right Sidebar",'painting'),
				'id'			=>	'post-archives-sidebar-right',
				'description'   =>  esc_html__("Appears in the Right side of the Post Archives Page.",'painting'),
				'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
				'after_widget' 	=> 	'</aside>',
				'before_title' 	=> 	'<h3 class="widgettitle">',
				'after_title' 	=> 	'</h3>'));
		break;
	endswitch;

	// 404 page layout
	$layout = painting_option('pageoptions','notfound-page-layout');
	$layout = !empty($layout) ? $layout : "content-full-width";
	switch($layout) :
		case 'with-left-sidebar':
			register_sidebar(array(
				'name' 			=>	esc_html__('404 | Left Sidebar','painting'),
				'id'			=>	'not-found-404-sidebar-left',
				'description'   =>  esc_html__("Appears in the Left side of 404 Page.",'painting'),
				'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
				'after_widget' 	=> 	'</aside>',
				'before_title' 	=> 	'<h3 class="widgettitle">',
				'after_title' 	=> 	'</h3>'));
		break;

		case 'with-right-sidebar':
			register_sidebar(array(
				'name' 			=>	esc_html__('404 | Right Sidebar','painting'),
				'id'			=>	'not-found-404-sidebar-right',
				'description'   =>  esc_html__("Appears in the Right side of 404 Page.",'painting'),
				'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
				'after_widget' 	=> 	'</aside>',
				'before_title' 	=> 	'<h3 class="widgettitle">',
				'after_title' 	=> 	'</h3>'));
		break;
	endswitch;
	
	// portfolio archives sidebar
	if(class_exists('DTCorePlugin')):
		$layout = painting_option('pageoptions','portfolio-archives-page-layout');
		$layout = !empty($layout) ? $layout : "content-full-width";
		switch($layout) :
			case 'with-left-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__("Portfolio Archives | Left Sidebar",'painting'),
					'id'			=>	'custom-post-portfolio-archives-sidebar-left',
					'description'   =>  esc_html__("Appears in the Left side of the Portfolio Archives Page.",'painting'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'</h3>'));
			break;

			case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__("Portfolio Archives | Right Sidebar",'painting'),
					'id'			=>	'custom-post-portfolio-archives-sidebar-right',
					'description'   =>  esc_html__("Appears in the Right side of the Portfolio Archives Page.",'painting'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'</h3>'));
			break;
		endswitch;
	endif;

	// shop standard sidebar
	if( class_exists('woocommerce')	):
		// left sidebar
		register_sidebar(array(
			'name' 			=>	esc_html__('Shop | Left Sidebar', 'painting'),
			'id'			=>	'shop-standard-sidebar-left',
			'description'   =>  esc_html__("Appears in the Right side of the Shop Page.",'painting'),
			'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
			'after_widget' 	=> 	'</aside>',
			'before_title' 	=> 	'<h3 class="widgettitle">',
			'after_title' 	=> 	'</h3>'));

		// right sidebar
		register_sidebar(array(
			'name' 			=>	esc_html__('Shop | Right Sidebar', 'painting'),
			'id'			=>	'shop-standard-sidebar-right',
			'description'   =>  esc_html__("Appears in the Right side of the Shop Page.",'painting'),
			'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
			'after_widget' 	=> 	'</aside>',
			'before_title' 	=> 	'<h3 class="widgettitle">',
			'after_title' 	=> 	'</h3>'));
	endif;


	// Footer Columnns		
	$footer_columns =  painting_option('layout','footer-columns');
	painting_footer_widgetarea($footer_columns);

	/* ---------------------------------------------------------------------------
	 * Registering Footer Widget Areas
	 * --------------------------------------------------------------------------- */
	function painting_footer_widgetarea($count) {
		$name = esc_html__( "Footer Column", 'painting' );
		if ($count <= 5) :
			for($i = 1; $i <= $count; $i ++) :
				register_sidebar ( array (
						'name' => $name . "-{$i}",
						'id' => "footer-sidebar-{$i}",
						'description' => esc_html__("Appears in the footer section of the site.",'painting'),
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget' => '</aside>',
						'before_title' => '<h3 class="widgettitle">',
						'after_title' => '</h3>' 
				) );
			endfor
			;
		 elseif ($count == 6 || $count == 7) :
			$a = array (
					"1-4",
					"1-4",
					"1-2" 
			);
			$a = ($count == 6) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				register_sidebar ( array (
						'name' => $name . "-{$v}",
						'id' => "footer-sidebar-{$k}-{$v}",
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget' => '</aside>',
						'before_title' => '<h3 class="widgettitle">',
						'after_title' => '</h3>' 
				) );
			endforeach
			;
		 elseif ($count == 8 || $count == 9) :
			$a = array (
					"1-4",
					"3-4" 
			);
			$a = ($count == 8) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				register_sidebar ( array (
						'name' => $name . "-{$v}",
						'id' => "footer-sidebar-{$k}-{$v}",
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget' => '</aside>',
						'before_title' => '<h3 class="widgettitle">',
						'after_title' => '</h3>' 
				) );
			endforeach
			;
		 elseif ($count == 10 || $count == 11) :
			$a = array (
					"1-3",
					"2-3" 
			);
			$a = ($count == 10) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				register_sidebar ( array (
						'name' => $name . "-{$v}",
						'id' => "footer-sidebar-{$k}-{$v}",
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget' => '</aside>',
						'before_title' => '<h3 class="widgettitle">',
						'after_title' => '</h3>' 
				) );
			endforeach
			;
		endif;
	}

	/* ---------------------------------------------------------------------------
	 * Function to show widgets in front end
	 * --------------------------------------------------------------------------- */
	function painting_show_footer_widgetarea($count) {
		$classes = array (
				"1" => "dt-sc-full-width",
				"dt-sc-one-half",
				"dt-sc-one-third",
				"dt-sc-one-fourth",
				"dt-sc-one-fifth",
				"1-2" => "dt-sc-one-half",
				"1-3" => "dt-sc-one-third",
				"1-4" => "dt-sc-one-fourth",
				"3-4" => "dt-sc-three-fourth",
				"2-3" => "dt-sc-two-third",
		);
		if ($count <= 5) :
			for($i = 1; $i <= $count; $i ++) :
				$class = $classes [$count];
				$first = ($i == 1) ? "first" : "";
				echo "<div class='column {$class} {$first}'>";
				if(is_active_sidebar("footer-sidebar-{$i}")): dynamic_sidebar("footer-sidebar-{$i}"); endif;
				echo "</div>";
			endfor;
		 elseif ($count == 6 || $count == 7) :
			$a = array (
					"1-4",
					"1-4",
					"1-2" 
			);
			$a = ($count == 6) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				$class = $classes [$v];
				$first = ($k == 0 ) ? "first" : "";
				echo "<div class='column {$class} {$first}'>";
				if(is_active_sidebar("footer-sidebar-{$k}-{$v}")): dynamic_sidebar("footer-sidebar-{$k}-{$v}"); endif;
				echo "</div>";
			endforeach;
		 
	
		elseif ($count == 8 || $count == 9) :
			$a = array (
					"1-4",
					"3-4" 
			);
			
			$a = ($count == 8) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				$class = $classes [$v];
				$first = ($k == 0 ) ? "first" : "";
				echo "<div class='column {$class} {$first}'>";
				if(is_active_sidebar("footer-sidebar-{$k}-{$v}")): dynamic_sidebar("footer-sidebar-{$k}-{$v}"); endif;
				echo "</div>";
			endforeach;
			
		 elseif ($count == 10 || $count == 11) :
			$a = array (
					"1-3",
					"2-3" 
			);
			$a = ($count == 10) ? $a : array_reverse ( $a );
			foreach ( $a as $k => $v ) :
				$class = $classes [$v];
				$first = ($k == 0 ) ? "first" : "";
				echo "<div class='column {$class} {$first}'>";
				if(is_active_sidebar("footer-sidebar-{$k}-{$v}")): dynamic_sidebar("footer-sidebar-{$k}-{$v}"); endif;
				echo "</div>";
			endforeach;
			
		endif;
	}

	// DT Theme Custom Widgets
	require_once( PAINTING_DIR .'/framework/theme-widgets/widget-flickr.php' );
	require_once( PAINTING_DIR .'/framework/theme-widgets/widget-portfolio.php' );
	require_once( PAINTING_DIR .'/framework/theme-widgets/widget-recent-posts.php' );
	
	if(class_exists('DTCorePlugin')) {
		require_once( PAINTING_DIR .'/framework/theme-widgets/widget-mailchimp.php' );
		require_once( PAINTING_DIR .'/framework/theme-widgets/widget-twitter.php' );
	}
		
	add_action('widgets_init', 'painting_widgets');
	function painting_widgets() {
		register_widget('DT_Flickr'); #Flickr
		register_widget('DT_Recent_Posts');#Recent Posts
		register_widget('DT_Portfolio');#Portfolio Widget
		
		if(class_exists('DTCorePlugin')) {
			register_widget('DT_Mailchimp'); #Mailchimp
			register_widget('DT_Twitter'); #Twitter
		}
	}
?>