<?php
$post = painting_get_global_variables('post');
if(is_front_page()):
	$postid = isset($post->ID) ? $post->ID : 0;
	painting_subtitle_section( $postid, 'page' );
elseif ( is_home() ):
	$pageid = get_option('page_for_posts');
	painting_subtitle_section( $pageid, 'page' );
elseif ( is_page() ):
	painting_subtitle_section( $post->ID, 'page' );
elseif( is_post_type_archive('tribe_events') ):
	painting_custom_subtitle_section( '');
elseif( is_post_type_archive('product') ):
	painting_subtitle_section( get_option('woocommerce_shop_page_id'), 'page' );
elseif( is_post_type_archive('dt_portfolios') ):
	$title = esc_html__("Portfolio Archives",'painting');
	painting_custom_subtitle_section($title);
elseif( class_exists('DTPropertyAddon') && is_post_type_archive('dt_properties') ):
	$title = esc_html__("Property Archives",'painting');    
	painting_custom_subtitle_section($title);
elseif( is_single() ):
	if( is_attachment() ):
	else:
		$post_type = get_post_type();
		if( $post_type === 'post' )   {
			painting_subtitle_section( $post->ID, 'post' );
		}elseif(  $post_type === "dt_portfolios"  ) {
			painting_subtitle_section( $post->ID, 'dt_portfolios' );
		}elseif( class_exists('DTPropertyAddon') && $post_type === "dt_properties" ){
			painting_subtitle_section( $post->ID, 'dt_properties' );
		} elseif( in_array('events-single', get_body_class()) ) {
			painting_custom_subtitle_section( '' );
		} elseif( in_array('single-tribe_venue', get_body_class()) ) {
			painting_custom_subtitle_section( '' );
		} elseif( in_array('single-tribe_organizer', get_body_class()) ) {
			painting_custom_subtitle_section( '' );
		} elseif( $post_type === "product" ) {
			$title = get_the_title($post->ID);
			$subtitle = esc_html__("Shop",'painting');
			$icon = "fa-shopping-cart";
			painting_custom_subtitle_section( $title );
		}
	endif; 
elseif( is_tax() ):
	$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
	$title = esc_html__("Term Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif( is_category( ) ):
	$title = esc_html__("Category Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif( is_tag() ):
	$title = esc_html__("Tag Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif( is_month() ):
	$title = esc_html__("Monthly Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif( is_year() ):
	$title = esc_html__("Yearly Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif(is_day() || is_time()):
elseif( is_author() ):
	$curauth = get_user_by('slug',get_query_var('author_name')) ;
	$title  = esc_html__("Author Archives",'painting');
	painting_custom_subtitle_section( $title );
elseif(in_array('events-archive', get_body_class())):
	painting_custom_subtitle_section( '' );
elseif( is_search() ):
	$title  = esc_html__("Search Result for ",'painting').get_search_query();
	painting_custom_subtitle_section( $title );
elseif( is_404() ):
	$title  = esc_html__("Lost ",'painting');
	painting_custom_subtitle_section( $title );
endif; 
?>