<?php 
add_action("add_meta_boxes", "painting_post_metabox");
add_action('save_post','painting_post_meta_save');
function painting_post_metabox(){
	add_meta_box("post-template-meta-container", esc_html__('Post Options','painting'), "painting_post_settings","post", "normal", "default");
	add_meta_box("post-format-meta-container",esc_html__('Post Format Options','painting'),"painting_post_format_settings","post","normal","default");
} 
	
	function painting_post_settings($args){ 
		global $post; 
		$tpl_default_settings = get_post_meta($post->ID,'_dt_post_settings',TRUE);
		$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
		
		wp_nonce_field( 'dttheme_page_options_meta_box', 'dttheme_page_options_meta_box_nonce' );
		?>

        <!-- Layout Start -->
        <div id="page-layout" class="custom-box">
			<div class="column one-sixth">                        
                <label><?php esc_html_e('Layout','painting');?> </label>
            </div>
			<div class="column five-sixth last">  
                <ul class="bpanel-layout-set">
                    <?php $homepage_layout = array(
                        'content-full-width'=>'without-sidebar',
                        'with-left-sidebar'=>'left-sidebar',
                        'with-right-sidebar'=>	'right-sidebar');
                        $v =  array_key_exists("layout",$tpl_default_settings) ?  $tpl_default_settings['layout'] : 'content-full-width';
                        foreach($homepage_layout as $key => $value):
                            $class = ($key == $v) ? " class='selected' " : "";
                            echo "<li><a href='#' rel='{$key}' {$class}><img src='".PAINTING_URI."/framework/theme-options/images/columns/{$value}.png' alt='' /></a></li>";
                        endforeach;?>
                </ul>
                <?php $v = array_key_exists("layout",$tpl_default_settings) ? $tpl_default_settings['layout'] : 'content-full-width';?>
                <input id="dttheme-post-layout" name="layout" type="hidden"  value="<?php echo esc_attr($v);?>"/>
                <p class="note"> <?php esc_html_e("You can choose between a left, right or no sidebar layout.",'painting');?> </p>
            </div>
        </div><!-- Layout End-->
        
    
		 <?php 
         $sb_layout = array_key_exists("layout",$tpl_default_settings) ? $tpl_default_settings['layout'] : 'content-full-width';
         $sidebar_both = $sidebar_left = $sidebar_right = '';
         if($sb_layout == 'content-full-width') {
            $sidebar_both = 'display:none;'; 
         } elseif($sb_layout == 'with-left-sidebar') {
            $sidebar_right = 'display:none;'; 
         } elseif($sb_layout == 'with-right-sidebar') {
            $sidebar_left = 'display:none;'; 
         } 
         ?>
        <div id="widget-area-options" <?php echo 'style="'.$sidebar_both.'"';?>>
            
            <div id="left-sidebar-container" class="page-left-sidebar" <?php echo 'style="'.$sidebar_left.'"'; ?>>
                <!-- 2. Standard Sidebar Left Start -->
                <div id="page-commom-sidebar" class="sidebar-section custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Disable Standard Sidebar Left','painting');?></label></div>
                    <div class="column five-sixth last"><?php 
                        $switchclass = array_key_exists("disable-standard-sidebar-left",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                        $checked = array_key_exists("disable-standard-sidebar-left",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        
                        <div data-for="dttheme-disable-standard-sidebar-left" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-disable-standard-sidebar-left" class="hidden" type="checkbox" name="disable-standard-sidebar-left" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Yes! to hide "Standard Sidebar" on this page.','painting');?> </p>
                     </div>
                </div><!-- Standard Sidebar Left End-->

                <!-- 3. Choose Widget Areas Start -->
                <div id="page-sidebars" class="sidebar-section custom-box page-widgetareas">
                    <div class="column one-sixth"><label><?php esc_html_e('Choose Widget Area - Left Sidebar','painting');?></label></div>
                    <div class="column five-sixth last">
						<?php $widgetareas = array_key_exists("widget-area-left",$tpl_default_settings) ? array_unique($tpl_default_settings["widget-area-left"]) : array();
                        $widgets = painting_option('widgetarea','custom'); ?>
                        <select class="dt-chosen-select" name="dttheme[widgetareas-left][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Widget Area', 'painting');?>"><?php
                            echo "<option value=''></option>";
                            foreach ( $widgets as $widget ) :
								$id = mb_convert_case($widget['name'], MB_CASE_LOWER, "UTF-8");
								$id = str_replace(" ", "-", $id);
								$selected = in_array( $id , $widgetareas ) ? " selected='selected' " : "";
								echo "<option value='{$id}' {$selected}>{$widget['name']}</option>";
                            endforeach;?>
                        </select>
                    </div>
                </div><!-- Choose Widget Areas End -->
            </div>

            <div id="right-sidebar-container" class="page-right-sidebar" <?php echo 'style="'.$sidebar_right.'"'; ?>>
                <!-- 3. Standard Sidebar Right Start -->
                <div id="page-commom-sidebar" class="sidebar-section custom-box page-right-sidebar">
                    <div class="column one-sixth"><label><?php esc_html_e('Disable Standard Sidebar Right','painting');?></label></div>
                    <div class="column five-sixth last"><?php 
                        $switchclass = array_key_exists("disable-standard-sidebar-right",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                        $checked = array_key_exists("disable-standard-sidebar-right",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        
                        <div data-for="dttheme-disable-standard-sidebar-right" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-disable-standard-sidebar-right" class="hidden" type="checkbox" name="disable-standard-sidebar-right" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Yes! to hide "Standard Sidebar" on this page.','painting');?> </p>
                     </div>
                </div><!-- Standard Sidebar Right End-->
                
                <!-- 3. Choose Widget Areas Start -->
                <div id="page-sidebars" class="sidebar-section custom-box page-widgetareas">
                    <div class="column one-sixth"><label><?php esc_html_e('Choose Widget Area - Right Sidebar','painting');?></label></div>
                    <div class="column five-sixth last">
						<?php $widgetareas = array_key_exists("widget-area-right",$tpl_default_settings) ? array_unique($tpl_default_settings["widget-area-right"]) : array();
                        $widgets = painting_option('widgetarea','custom'); ?>
                        <select class="dt-chosen-select" name="dttheme[widgetareas-right][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Widget Area', 'painting');?>"><?php
                            echo "<option value=''></option>";
                            foreach ( $widgets as $widget ) :
								$id = mb_convert_case($widget['name'], MB_CASE_LOWER, "UTF-8");
								$id = str_replace(" ", "-", $id);
								$selected = in_array( $id , $widgetareas ) ? " selected='selected' " : "";
								echo "<option value='{$id}' {$selected}>{$widget['name']}</option>";
                            endforeach;?>
                        </select>
                    </div>
                </div><!-- Choose Widget Areas End -->
            </div>

        </div>
        
        <!-- Featured Image Section Start -->
        <div class="custom-box">
			<div class="column one-sixth">                        
        	    <label><?php esc_html_e('Disable Featured Image','painting');?></label>
            </div>
			<div class="column five-sixth last">  
				<?php $switchclass = array_key_exists("disable-featured-image",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                      $checked = array_key_exists("disable-featured-image",$tpl_default_settings) ? ' checked="checked"' : '';?>
                <div data-for="dttheme-post-featured-image" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                <input id="dttheme-post-featured-image" class="hidden" type="checkbox" name="post-featured-image" value="true"  <?php echo esc_attr($checked);?>/>
                <p class="note"> <?php esc_html_e('YES! to disable featured image','painting');?> </p>
            </div>
        </div><!-- Featured Image Section End-->
        
        <!-- Categories Variations -->
        <div class="custom-box">
          <div class="column one-sixth">
              <label><?php esc_html_e('Categories Variation','painting');?></label>
          </div>
          <div class="column five-sixth last">
                <?php $blog_post_cats_variation = array_key_exists('categories-variation', $tpl_default_settings) ? $tpl_default_settings['categories-variation'] : ''; ?>
                <select class="dt-chosen-select" name="categories-variation" data-placeholder="<?php esc_html_e('Select Variation', 'painting');?>"><?php
                    echo '<option value=""></option>';
                    $variations = array('pink' => 'Pink', 'green' => 'Green', 'skyblue' => 'SkyBlue', 'red' => 'Red', 'yellow' => 'Yellow', 'blueturquoise' => 'Blueturquoise', 'blue' => 'Blue');
                    foreach($variations as $variation_key => $variation_value) {
                        $selected = ($variation_key == $blog_post_cats_variation) ? 'selected="selected"' : '';
                        echo '<option value="'.$variation_key.'" '.$selected.'>'.$variation_value.'</option>';	
                    }
                    ?>                        	
                </select>
              <p class="note"> <?php esc_html_e("You can choose variation for categories of this post.",'painting');?> </p>
          </div>
        </div><!-- Categories Variations End-->
        
<?php
		wp_reset_postdata();
    }

    function painting_post_format_settings( $args ) {
        global $post; 
        $tpl_default_settings = get_post_meta($post->ID,'_dt_post_settings',TRUE);
        $tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array(); 
		
		wp_nonce_field( 'dttheme_page_format_options_meta_box', 'dttheme_page_format_options_meta_box_nonce' );
		?>

        <div id="dt-post-format-gallery">
            <div class="custom-box">
                <div class="column one-sixth"><label><?php esc_html_e('Image Gallery','painting');?> </label></div>
                <div class="column five-sixth last">
                    <div class="dt-media-btns-container">
                        <a href="#" class="dt-open-media-for-gallery-post custom-button-style">
                            <?php esc_html_e( 'Click Here to Add Images', 'painting' );?> </a>
                    </div>
                    <div class="clear"></div>
                    <div class="dt-media-container">
                        <ul class="dt-items-holder"><?php
                            if ( array_key_exists("items",  $tpl_default_settings)) {
                                foreach ( $tpl_default_settings["items_thumbnail"] as $key => $thumbnail ) {
                                    $item = $tpl_default_settings ['items'] [$key];
									$items_id = $tpl_default_settings ['items_id'] [$key];
                                    $out = "";
                                    $name = "";
                                    $foramts = array ('jpg','jpeg','png','gif');
                                    $parts = explode ( '.', $item );
                                    $ext = strtolower ( $parts [count ( $parts ) - 1] );

                                    $out .= "<li>";
                                    if (in_array ( $ext, $foramts )) {
                                        $name = $tpl_default_settings ['items_name'] [$key];
                                    
                                        $out .= "<img src='{$thumbnail}' alt='' />";
                                        $out .= "<span class='dt-image-name'>{$name}</span>";
                                        $out .= "<input type='hidden' name='items[]' value='{$item}' />";
                                    }
                                    $out .= "<input class='dt-image-name' type='hidden' name='items_name[]' value='{$name}' />";
                                    $out .= "<input type='hidden' name='items_thumbnail[]' value='{$thumbnail}' />";
									$out .= "<input type='hidden' name='items_id[]' value='{$items_id}' />";
                                    $out .= "<span class='my_delete'></span>";
                                    $out .= "</li>";
                                    echo painting_wp_kses($out);
                                }
                            }
                        ?></ul>
                    </div>    
                </div>
            </div> 
        </div>

        <div id="dt-post-format-video-audio">
            <div class="custom-box">
                <div class="column one-sixth"><label><?php esc_html_e('oEmbed URL','painting');?> </label></div>
                <div class="column five-sixth last">
                    <?php $oembed_url = array_key_exists("oembed-url", $tpl_default_settings) ? $tpl_default_settings['oembed-url'] : "";?>
                    <input type="text" name="oembed-url" value="<?php echo esc_url($oembed_url);?>" class="widefat"/>
                    <p class="note"><?php esc_html_e("Enter a URL that is compatible with WP's built-in oEmbed feature. This setting is used for your video and audio post formats.",'painting');?></p>
                </div>
            </div>

            <div class="custom-box">
                <div class="column one-sixth"><label><?php esc_html_e('Self Hosted URL','painting');?> </label></div>
                <div class="column five-sixth last">
                    <?php $self_hosted_url = array_key_exists("self-hosted-url", $tpl_default_settings) ? $tpl_default_settings['self-hosted-url'] : ""; ?>
                    <input type="text" name="self-hosted-url" value="<?php echo esc_url($self_hosted_url);?>" class="widefat"/>
                    <p class="note"><?php esc_html_e("Insert your self hosted video or audio url here.",'painting');?></p>                    
                </div>
            </div>            
        </div>

<?php wp_reset_postdata();
    }
	
	function painting_post_meta_save($post_id){
		
		
		if ( ! isset( $_POST['dttheme_page_options_meta_box_nonce'] ) || ! isset( $_POST['dttheme_page_format_options_meta_box_nonce'] ) ) {
			return;
		}
		
		if ( ! wp_verify_nonce( $_POST['dttheme_page_options_meta_box_nonce'], 'dttheme_page_options_meta_box' ) || ! wp_verify_nonce( $_POST['dttheme_page_format_options_meta_box_nonce'], 'dttheme_page_format_options_meta_box' ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
	
		if ( isset( $_POST['post_type'] ) && 'post' == $_POST['post_type'] ) {
	
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
	
		} else {
	
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}
		
		if ( (key_exists('post_type', $_POST)) && ('post' == $_POST['post_type']) ) :

			$settings = array();
			$settings['layout'] = isset($_POST['layout']) ? $_POST['layout'] : "";
			
			if($_POST['layout'] == 'with-left-sidebar') {
				$settings['disable-standard-sidebar-left'] = isset($_POST['disable-standard-sidebar-left']) ? $_POST['disable-standard-sidebar-left'] : '';
				$settings['widget-area-left'] = isset($_POST['dttheme']['widgetareas-left']) ? array_unique(array_filter($_POST['dttheme']['widgetareas-left'])) : '';
			} elseif($_POST['layout'] == 'with-right-sidebar') {
				$settings['disable-standard-sidebar-right'] = isset($_POST['disable-standard-sidebar-right']) ? $_POST['disable-standard-sidebar-right'] : '';
				$settings['widget-area-right'] = isset($_POST['dttheme']['widgetareas-right']) ? array_unique(array_filter($_POST['dttheme']['widgetareas-right'])) : '';
			} 
			
			$settings['disable-featured-image'] = isset($_POST['post-featured-image']) ? $_POST['post-featured-image'] : '';
			$settings['categories-variation'] = isset($_POST['categories-variation']) ? $_POST['categories-variation'] : '';
	
			#For Gallery Post Format
			if(isset($_POST['post_format'])) {
				if( $_POST['post_format'] === "gallery") {
					$settings ['items'] = isset ( $_POST ['items'] ) ? painting_wp_kses($_POST ['items']) : "";
					$settings ['items_thumbnail'] = isset ( $_POST ['items_thumbnail'] ) ? painting_wp_kses($_POST ['items_thumbnail']) : "";
					$settings ['items_name'] = isset ( $_POST ['items_name'] ) ? painting_wp_kses($_POST ['items_name']) : "";
					$settings ['items_id'] = isset ( $_POST ['items_id'] ) ? $_POST ['items_id'] : "";
		
				} elseif( $_POST['post_format'] === "video" || $_POST['post_format'] === "audio" ) {
					$settings['oembed-url'] = isset( $_POST['oembed-url'] ) ? painting_wp_kses($_POST['oembed-url']) : "";
					$settings['self-hosted-url'] = isset( $_POST['self-hosted-url'] ) ? painting_wp_kses($_POST['self-hosted-url']) : "";
				}
			}
			
			update_post_meta($post_id, "_dt_post_settings", array_filter($settings));
		
		endif;
		
	}
?>