<!-- fonts -->
<div id="fonts" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel">
        	<li><a href="#tab1"><?php esc_html_e('Fonts', 'painting');?></a></li>
            <li><a href="#tab2"><?php esc_html_e('Content', 'painting');?></a></li>
            <li><a href="#tab3"><?php esc_html_e('Menu', 'painting');?></a></li>
            <li><a href="#tab4"><?php esc_html_e('Page Title', 'painting');?></a></li>
            <li><a href="#tab5"><?php esc_html_e('Headings', 'painting');?></a></li>
        </ul>

        <!-- tab1-custom-fonts -->
        <div id="tab1" class="tab-content">
        
            <div class="bpanel-box">

                <div class="box-title">
                    <h3><?php esc_html_e('General', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Disable All Fonts Settings', 'painting');?></label></div>
                    <div class="column two-third last">
                        <?php $checked = ( "true" ==  painting_option('fonts','disable-fonts-settings') ) ? ' checked="checked"' : ''; ?>
                        <?php $switchclass = ( "true" ==  painting_option('fonts','disable-fonts-settings') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        <div data-for="disable-fonts-settings" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input class="hidden" id="disable-fonts-settings" name="dttheme[fonts][disable-fonts-settings]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                        <p class="note"><?php esc_html_e('Disable all font settings you have done here.', 'painting');?></p>
                    </div>
                </div>
                
            </div>
                    
            <!-- .bpanel-box -->
            <div class="bpanel-box">

                <div class="box-title">
                    <h3><?php esc_html_e('Fonts Style & Subset', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Google Font Style & Weight', 'painting');?></label></div>
                    <div class="column two-third last">
                    	<ul class="checkbox-list"><?php
							#google font styles
							$font_styles = painting_font_weight();
							$dtfonts = painting_option('fonts', 'font-style');
							$dtfonts = !empty($dtfonts) ? $dtfonts : array();
							foreach($font_styles as $key => $option):
								$checked = ( in_array(trim($key), $dtfonts) ) ? ' checked="checked"' : ''; ?>
								<li><label><input type="checkbox" name="dttheme[fonts][font-style][]" value="<?php echo esc_attr($key);?>" <?php echo esc_attr($checked); ?> /><?php echo esc_attr($option); ?></label></li><?php
							endforeach;	?>
                        </ul>
                        <p class="note"><?php esc_html_e('Some of the fonts in the Google Font Directory support multiple styles.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Google Font Subset', 'painting');?></label></div>
                    <div class="column two-third last">
                    	<input type="text" class="large" name="dttheme[fonts][font-subset]" value="<?php echo painting_option('fonts','font-subset');?>" />
                        <p class="note"><?php esc_html_e('Specify which subsets should be downloaded. Multiple subsets should be separated with comma (,)', 'painting');?></p>
                    </div>
                </div>
                
                <div class="box-title">
                    <h3><?php esc_html_e('Custom Fonts', 'painting');?></h3>
                </div>

                <div class="box-content">
                
                    <div class="column one-third"><label><?php esc_html_e('Custom Font Name', 'painting');?></label></div>
                    <div class="column two-third last">
                    	<input type="text" class="large" name="dttheme[fonts][customfont-name]" value="<?php echo painting_option('fonts','customfont-name');?>" />
                        <p class="note"><?php esc_html_e('Please use only letters or spaces, eg. Patua One', 'painting');?></p>
                    </div>
					<div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font (.woff)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont-woff]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont-woff');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .woff file for above custom font.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font (.ttf)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont-ttf]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont-ttf');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .ttf file for above custom font.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font (.svg)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont-svg]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont-svg');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .svg file for above custom font.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font (.eot)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont-eot]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont-eot');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .eot file for above custom font.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Custom Font 2 Name', 'painting');?></label></div>
                    <div class="column two-third last">
                    	<input type="text" class="large" name="dttheme[fonts][customfont2-name]" value="<?php echo painting_option('fonts','customfont2-name');?>" />
                        <p class="note"><?php esc_html_e('Please use only letters or spaces, eg. Patua One', 'painting');?></p>
                    </div>
					<div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font 2 (.woff)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont2-woff]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont2-woff');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .woff file for above custom font 2.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font 2 (.ttf)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont2-ttf]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont2-ttf');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .ttf file for above custom font 2.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font 2 (.svg)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont2-svg]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont2-svg');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .svg file for above custom font 2.', 'painting');?>  </p>
					</div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Custom Font 2 (.eot)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input id="dttheme-favicon" name="dttheme[fonts][customfont2-eot]" type="text" class="uploadfield medium" value="<?php echo painting_option('fonts','customfont2-eot');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
	                    <p class="note"> <?php esc_html_e('Upload .eot file for above custom font 2.', 'painting');?>  </p>
					</div>
                </div>
            </div><!-- .bpanel-box end -->
        </div><!--tab1-custom-fonts end-->

		<?php 
		$fonts = painting_fonts();
		$font_weights = painting_font_weight(); 
		$font_styles = painting_font_style();
		$font_transforms = painting_font_transform();
		?>
        
        <!-- tab2-content -->
        <div id="tab2" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Content', 'painting');?></h3>
                </div>
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Font Family', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-content" name="dttheme[fonts][content-font]" class="medium dt-chosen-select"><?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							
							#system fonts
							echo '<optgroup label="'. esc_html__('System', 'painting') .'">';
							foreach ( $fonts['system'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','content-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>';

							#custom font | uploaded in theme options
							if( key_exists( 'custom', $fonts ) ){
								echo '<optgroup label="'. esc_html__('Custom', 'painting') .'">';
								foreach ( $fonts['custom'] as $font ) {
									echo '<option value="'. $font .'"'.selected(painting_option('fonts','content-font'), $font, false).'>'. $font .'</option>';
								}
								echo '</optgroup>';
							}

							#google fonts | all
							echo '<optgroup label="'. esc_html__('Google Fonts', 'painting') .'">';
							foreach ( $fonts['all'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','content-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>'; ?>
                        </select>
                        <p class="note"><?php esc_html_e('This font will be used for default content.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Font Size', 'painting');?></label></div>
                    <div class="column two-third last">
						<?php painting_admin_jqueryuislider('', "dttheme[fonts][content-font-size]", painting_option('fonts','content-font-size')); ?>
						<p class="note"> <?php esc_html_e('This font size will be used for default contents.', 'painting');?>  </p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Weight', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-content-weight" name="dttheme[fonts][content-weight]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_weights as $weight_key => $weight ) {
								echo '<option value="'. $weight_key .'"'.selected(painting_option('fonts','content-weight'), $weight_key, false).'>'. $weight .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font weight for site default contents.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Style', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-content-style" name="dttheme[fonts][content-style]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_styles as $style_key => $style ) {
								echo '<option value="'. $style_key .'"'.selected(painting_option('fonts','content-style'), $style_key, false).'>'. $style .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font style for site default contents.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Line Height (px)', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input type="text" class="large" name="dttheme[fonts][content-lineheight]" value="<?php echo painting_option('fonts','content-lineheight');?>" />
                        <p class="note"><?php esc_html_e('Choose line height for your contents.', 'painting');?></p>
                    </div>

                </div><!-- .box-content -->

            </div><!-- .bpanel-box end -->
        </div><!--tab2-content end-->


        <!-- tab3-menu -->
        <div id="tab3" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
            
                <div class="box-title">
                    <h3><?php esc_html_e('Menu', 'painting');?></h3>
                </div>
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Font Family', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-menu" name="dttheme[fonts][menu-font]" class="medium dt-chosen-select"><?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							
							#system fonts
							echo '<optgroup label="'. esc_html__('System', 'painting') .'">';
							foreach ( $fonts['system'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','menu-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>';

							#custom font | uploaded in theme options
							if( key_exists( 'custom', $fonts ) ){
								echo '<optgroup label="'. esc_html__('Custom', 'painting') .'">';
								foreach ( $fonts['custom'] as $font ) {
									echo '<option value="'. $font .'"'.selected(painting_option('fonts','menu-font'), $font, false).'>'. $font .'</option>';
								}
								echo '</optgroup>';
							}

							#google fonts | all
							echo '<optgroup label="'. esc_html__('Google Fonts', 'painting') .'">';
							foreach ( $fonts['all'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','menu-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>'; ?>
                        </select>
                        <p class="note"><?php esc_html_e('The selected font can apply for header menu.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Size', 'painting');?></label></div>
                    <div class="column two-third last">
						<?php painting_admin_jqueryuislider('', "dttheme[fonts][menu-font-size]", painting_option('fonts','menu-font-size')); ?>
						<p class="note"> <?php esc_html_e('This font size will be used for header menu and also for its first level menu only.', 'painting');?>  </p>                    
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Weight', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-menu-weight" name="dttheme[fonts][menu-weight]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_weights as $weight_key => $weight ) {
								echo '<option value="'. $weight_key .'"'.selected(painting_option('fonts','menu-weight'), $weight_key, false).'>'. $weight .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font weight for menus.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Style', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-menu-style" name="dttheme[fonts][menu-style]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_styles as $style_key => $style ) {
								echo '<option value="'. $style_key .'"'.selected(painting_option('fonts','menu-style'), $style_key, false).'>'. $style .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font style for site menus.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Text Transform', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-menu-texttransform" name="dttheme[fonts][menu-texttransform]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_transforms as $transform_key => $transform ) {
								echo '<option value="'. $transform_key .'"'.selected(painting_option('fonts','menu-texttransform'), $transform_key, false).'>'. $transform .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose text transform for site menus.', 'painting');?></p>
                    </div>
                </div><!-- .box-content -->
                
                <div class="box-title">
                    <h3><?php esc_html_e('Sub Menu', 'painting');?></h3>
                </div>
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Font Family', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-submenu" name="dttheme[fonts][submenu-font]" class="medium dt-chosen-select"><?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							
							#system fonts
							echo '<optgroup label="'. esc_html__('System', 'painting') .'">';
							foreach ( $fonts['system'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','submenu-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>';

							#custom font | uploaded in theme options
							if( key_exists( 'custom', $fonts ) ){
								echo '<optgroup label="'. esc_html__('Custom', 'painting') .'">';
								foreach ( $fonts['custom'] as $font ) {
									echo '<option value="'. $font .'"'.selected(painting_option('fonts','submenu-font'), $font, false).'>'. $font .'</option>';
								}
								echo '</optgroup>';
							}

							#google fonts | all
							echo '<optgroup label="'. esc_html__('Google Fonts', 'painting') .'">';
							foreach ( $fonts['all'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','submenu-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>'; ?>
                        </select>
                        <p class="note"><?php esc_html_e('The selected font can apply for header sub and mega menus.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Size', 'painting');?></label></div>
                    <div class="column two-third last">
						<?php painting_admin_jqueryuislider('', "dttheme[fonts][submenu-font-size]", painting_option('fonts','submenu-font-size')); ?>
						<p class="note"> <?php esc_html_e('This font size will be used for header sub and mega menus.', 'painting');?>  </p>                    
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Weight', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-submenu-weight" name="dttheme[fonts][submenu-weight]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_weights as $weight_key => $weight ) {
								echo '<option value="'. $weight_key .'"'.selected(painting_option('fonts','submenu-weight'), $weight_key, false).'>'. $weight .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font weight for sub and mega menus.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Style', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-submenu-style" name="dttheme[fonts][submenu-style]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_styles as $style_key => $style ) {
								echo '<option value="'. $style_key .'"'.selected(painting_option('fonts','submenu-style'), $style_key, false).'>'. $style .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font style for site and mega sub menus.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Text Transform', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-submenu-texttransform" name="dttheme[fonts][submenu-texttransform]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_transforms as $transform_key => $transform ) {
								echo '<option value="'. $transform_key .'"'.selected(painting_option('fonts','submenu-texttransform'), $transform_key, false).'>'. $transform .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose text transform for site and mega sub menus.', 'painting');?></p>
                    </div>
                </div><!-- .box-content -->
                
            </div><!-- .bpanel-box end -->
        </div><!--tab3-menu end-->

        <!-- tab4-page-title -->
        <div id="tab4" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Page Title', 'painting');?></h3>
                </div>
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Font Family', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-pagetitle" name="dttheme[fonts][pagetitle-font]" class="medium dt-chosen-select"><?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							
							#system fonts
							echo '<optgroup label="'. esc_html__('System', 'painting') .'">';
							foreach ( $fonts['system'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','pagetitle-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>';

							#custom font | uploaded in theme options
							if( key_exists( 'custom', $fonts ) ){
								echo '<optgroup label="'. esc_html__('Custom', 'painting') .'">';
								foreach ( $fonts['custom'] as $font ) {
									echo '<option value="'. $font .'"'.selected(painting_option('fonts','pagetitle-font'), $font, false).'>'. $font .'</option>';
								}
								echo '</optgroup>';
							}

							#google fonts | all
							echo '<optgroup label="'. esc_html__('Google Fonts', 'painting') .'">';
							foreach ( $fonts['all'] as $font ) {
								echo '<option value="'. $font .'"'.selected(painting_option('fonts','pagetitle-font'), $font, false).'>'. $font .'</option>';
							}
							echo '</optgroup>'; ?>
                        </select>
                        <p class="note"><?php esc_html_e('The selected font can apply for page titles.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Size', 'painting');?></label></div>
                    <div class="column two-third last">
						<?php painting_admin_jqueryuislider('', "dttheme[fonts][pagetitle-font-size]", painting_option('fonts','pagetitle-font-size')); ?>
						<p class="note"> <?php esc_html_e('This font size will be used for all page title.', 'painting');?>  </p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Weight', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-pagetitle-weight" name="dttheme[fonts][pagetitle-weight]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_weights as $weight_key => $weight ) {
								echo '<option value="'. $weight_key .'"'.selected(painting_option('fonts','pagetitle-weight'), $weight_key, false).'>'. $weight .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font weight for page title.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Font Style', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-pagetitle-style" name="dttheme[fonts][pagetitle-style]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_styles as $style_key => $style ) {
								echo '<option value="'. $style_key .'"'.selected(painting_option('fonts','pagetitle-style'), $style_key, false).'>'. $style .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose font style for site page title.', 'painting');?></p>
                    </div>
					<div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Text Transform', 'painting');?></label></div>
                    <div class="column two-third last">
                        <select id="dttheme-fonts-pagetitle-texttransform" name="dttheme[fonts][pagetitle-texttransform]" class="medium dt-chosen-select">
							<?php
							echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
							foreach ( $font_transforms as $transform_key => $transform ) {
								echo '<option value="'. $transform_key .'"'.selected(painting_option('fonts','pagetitle-texttransform'), $transform_key, false).'>'. $transform .'</option>';
							}
							?>
                        </select>
                        <p class="note"><?php esc_html_e('Choose text transform for site page title.', 'painting');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!--tab4-page-title end-->

        <!-- tab5-headings -->
        <div id="tab5" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
            	
                <?php 
				$htags = array('h1' => 'H1', 'h2' => 'H2', 'h3' => 'H3', 'h4' => 'H4', 'h5' => 'H5', 'h6' => 'H6'); 
				foreach($htags as $htag_key => $htag) {
				?>
                    <div class="box-title">
                        <h3><?php echo esc_html($htag); ?></h3>
                    </div>
                    <div class="box-content">
                        <div class="column one-third"><label><?php esc_html_e('Font Family', 'painting');?></label></div>
                        <div class="column two-third last">
                            <select id="dttheme-fonts-<?php echo esc_attr($htag_key); ?>" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-font]" class="medium dt-chosen-select"><?php
                                echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
                                
                                #system fonts
                                echo '<optgroup label="'. esc_html__('System', 'painting') .'">';
                                foreach ( $fonts['system'] as $font ) {
                                    echo '<option value="'. $font .'"'.selected(painting_option('fonts',$htag_key.'-font'), $font, false).'>'. $font .'</option>';
                                }
                                echo '</optgroup>';
    
                                #custom font | uploaded in theme options
                                if( key_exists( 'custom', $fonts ) ){
                                    echo '<optgroup label="'. esc_html__('Custom', 'painting') .'">';
                                    foreach ( $fonts['custom'] as $font ) {
                                        echo '<option value="'. $font .'"'.selected(painting_option('fonts',$htag_key.'-font'), $font, false).'>'. $font .'</option>';
                                    }
                                    echo '</optgroup>';
                                }
    
                                #google fonts | all
                                echo '<optgroup label="'. esc_html__('Google Fonts', 'painting') .'">';
                                foreach ( $fonts['all'] as $font ) {
                                    echo '<option value="'. $font .'"'.selected(painting_option('fonts',$htag_key.'-font'), $font, false).'>'. $font .'</option>';
                                }
                                echo '</optgroup>'; ?>
                            </select>
                            <p class="note"><?php echo sprintf( esc_html__('The select font for %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                        <div class="hr"></div>
                        
                        <div class="column one-third"><label><?php esc_html_e('Font Size', 'painting');?></label></div>
                        <div class="column two-third last">
                            <?php painting_admin_jqueryuislider('', "dttheme[fonts][$htag_key-font-size]", painting_option('fonts',$htag_key.'-font-size')); ?>
                            <p class="note"> <?php echo sprintf( esc_html__('Choose font size for your %s heading.', 'painting'), $htag_key ); ?>  </p>
                        </div>
                        <div class="hr"></div>
                        
                        <div class="column one-third"><label><?php esc_html_e('Font Weight', 'painting');?></label></div>
                        <div class="column two-third last">
                            <select id="dttheme-fonts-<?php echo esc_attr($htag_key); ?>-weight" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-weight]" class="medium dt-chosen-select">
                                <?php
                                echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
                                foreach ( $font_weights as $weight_key => $weight ) {
                                    echo '<option value="'. $weight_key .'"'.selected(painting_option('fonts',$htag_key.'-weight'), $weight_key, false).'>'. $weight .'</option>';
                                }
                                ?>
                            </select>
                            <p class="note"><?php echo sprintf( esc_html__('Choose font weight for %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                        <div class="hr"></div>
                        
                        <div class="column one-third"><label><?php esc_html_e('Font Style', 'painting');?></label></div>
                        <div class="column two-third last">
                            <select id="dttheme-fonts-<?php echo esc_attr($htag_key); ?>-style" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-style]" class="medium dt-chosen-select">
                                <?php
                                echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
                                foreach ( $font_styles as $style_key => $style ) {
                                    echo '<option value="'. $style_key .'"'.selected(painting_option('fonts',$htag_key.'-style'), $style_key, false).'>'. $style .'</option>';
                                }
                                ?>
                            </select>
                            <p class="note"><?php echo sprintf( esc_html__('Choose font style for site %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                        <div class="hr"></div>
                        
                        <div class="column one-third"><label><?php esc_html_e('Text Transform', 'painting');?></label></div>
                        <div class="column two-third last">
                            <select id="dttheme-fonts-<?php echo esc_attr($htag_key); ?>-texttransform" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-texttransform]" class="medium dt-chosen-select">
                                <?php
                                echo '<option value="">'. esc_html__('Default', 'painting') .'</option>';
                                foreach ( $font_transforms as $transform_key => $transform ) {
                                    echo '<option value="'. $transform_key .'"'.selected(painting_option('fonts',$htag_key.'-texttransform'), $transform_key, false).'>'. $transform .'</option>';
                                }
                                ?>
                            </select>
                            <p class="note"><?php echo sprintf( esc_html__('Choose text transform for site %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                        <div class="hr"></div>
    
                        <div class="column one-third"><label><?php esc_html_e('Line Height (px)', 'painting');?></label></div>
                        <div class="column two-third last">
                            <input type="text" class="large" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-lineheight]" value="<?php echo painting_option('fonts',$htag_key.'-lineheight');?>" />
                            <p class="note"><?php echo sprintf( esc_html__('Choose line height for your %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                        <div class="hr"></div>
    
                        <div class="column one-third"><label><?php esc_html_e('Letter Spacing (px)', 'painting');?></label></div>
                        <div class="column two-third last">
                            <input type="text" class="large" name="dttheme[fonts][<?php echo esc_attr($htag_key); ?>-letterspacing]" value="<?php echo painting_option('fonts',$htag_key.'-letterspacing');?>" />
                            <p class="note"><?php echo sprintf( esc_html__('Choose letter spacing for your %s heading.', 'painting'), $htag_key ); ?></p>
                        </div>
                    </div>
                <?php
				}
				?>
                
            </div><!-- .bpanel-box end -->
        </div><!--tab5-heading end-->

    </div><!-- .bpanel-main-content end-->
</div><!-- fonts end-->