<!-- general -->
<div id="general" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#tab1"><?php esc_html_e('General', 'painting');?></a></li>
            <li><a href="#tab2"><?php esc_html_e('Responsive', 'painting');?></a></li>
			<li><a href="#tab3"><?php esc_html_e('Advanced', 'painting');?></a></li>
        </ul>
        
        <!-- tab1-general -->
        <div id="tab1" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('General', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Enable Preloader','painting');?></h6> 
                    <div class="column one-fifth">
                        <?php $checked = ( "true" ==  painting_option('general','enable-preloader') ) ? ' checked="checked"' : ''; ?>
                        <?php $switchclass = ( "true" ==  painting_option('general','enable-preloader') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        <div data-for="enable-preloader" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input class="hidden" id="enable-preloader" name="dttheme[general][enable-preloader]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                    	<p class="note"><?php esc_html_e('YES! to enable preloader for this site.', 'painting');?></p>
                    </div>
                    
                    <div class="hr"></div>
                    <div class="clear"></div>
                
                    <h6><?php esc_html_e('Enable Nice Scroll', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('general','enable-nicescroll') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('general','enable-nicescroll') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-enable-nicescroll" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-enable-nicescroll" name="dttheme[general][enable-nicescroll]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to use nice scroll for this site.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Globally Disable Page Comments', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('general','disable-pagecomments') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('general','disable-pagecomments') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-disable-pagecomments" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-disable-pagecomments" name="dttheme[general][disable-pagecomments]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note no-margin"><?php esc_html_e('YES! to disable comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Style Picker', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('general','enable-stylepicker') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('general','enable-stylepicker') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-enable-stylepicker" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-enable-stylepicker" name="dttheme[general][enable-stylepicker]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('Check if you want to show the style picker.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                                        
                    <h6><?php esc_html_e('Pagination Position', 'painting'); ?></h6>
                    <div class="column one-half">
                        <select id="dttheme-pagination-position" name="dttheme[general][pagination-position]" class="dt-chosen-select">
                            <?php
							
                          $alignments = array('', 'text-alignleft' => 'Align Left', 'text-aligncenter' => 'Align Center', 'text-alignright' => 'Align Right');
                          foreach($alignments as $alignment_key => $alignment_item):
                              $s = selected(painting_option('general','pagination-position'), $alignment_key, false);
                              echo '<option '.$s.' value="'.$alignment_key.'">'.$alignment_item.'</option>';
                          endforeach;
                          ?>
                        </select>
                    </div>
                    <div class="column one-half last">
                        <p class="note"><?php esc_html_e('Choose position of pagination here.', 'painting');?></p>
                    </div>
                    
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Mailchip API Key', 'painting');?></h6>
                    <input type="text" class="large" name="dttheme[general][mailchimp-key]" value="<?php echo painting_option('general','mailchimp-key');?>" />
                    <p class="note"><?php esc_html_e('You can add mailchip api key here, which will be accessed in mailchip widgets','painting');?></p>
                    
                    <?php 
                    if(painting_option('general','mailchimp-key') != '') { 
                        ?>
                    
                        <div class="hr"></div>
    
                        <h6><?php esc_html_e('Mailchimp List Id','painting');?></h6>
                        <?php
                        
                        $list_id = (painting_option('general','mailchimp-listid') != '') ? painting_option('general','mailchimp-listid') : '';
                        
                        $apiKey = painting_option('general','mailchimp-key');						
                        $mailchimp_lists = painting_mailchimp_list_ids($apiKey);
                        
                        echo '<select id="dttheme-mailchimp-listid" name="dttheme[general][mailchimp-listid]">';
                        foreach ($mailchimp_lists as $key => $value):
                            $id = $value['id'];
                            $name = $value['name'];
                            $selected = ( $list_id == $id ) ? ' selected="selected" ' : '';
                            echo '<option '.$selected.' value="'.$id.'">'.$name.'</option>';
                        endforeach;
                        echo '</select>';
                        
                        ?>
                        <p class="note no-margin"><?php esc_html_e('Select your mailchip list id, which will be used in newsletter shortcodes.','painting'); ?></p>
                
                        <?php 
                    } 
					?>
                    
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!--tab1-general end-->

        <!-- tab2-responsive -->
        <div id="tab2" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Responsive', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Make My Site Responsive', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('general','enable-responsive') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('general','enable-responsive') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-enable-responsive" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-enable-responsive" name="dttheme[general][enable-responsive]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to check responsive version for your website.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Disable Slider for Mobile Devices', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('general','disable-mobileslider') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('general','disable-mobileslider') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-disable-mobileslider" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-disable-mobileslider" name="dttheme[general][disable-mobileslider]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note no-margin"><?php esc_html_e('Choose whether you wish to hide / display the slider area of your website on mobile devices.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!--tab2-responsive end-->

        <!-- tab3-advanced -->
        <div id="tab3" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Advanced', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                    <?php if(class_exists('DTCorePlugin')): ?>
						<h6><?php esc_html_e('Choose any of these post types to activate page builder', 'painting');?></h6><?php
						//Getting post types...
						$post_types = array( 'post' => 'Post', 'page' => 'Page', 'dt_portfolios' => 'Portfolio' );
						foreach ( $post_types as $key => $pname ):
							$sel_posttypes = is_array(painting_option('general', 'post-types')) ? painting_option('general', 'post-types') : array();
						  	$switchclass = ( array_key_exists($key, $sel_posttypes) && $key ==  $sel_posttypes[$key] ) ? 'checkbox-switch-on' :'checkbox-switch-off';
						  	$obj = get_post_type_object( $key );?>
							  <div class="column one-third"><label><?php echo esc_attr($obj->labels->singular_name); ?></label></div>
							  <div class="column two-third last">
								   <div data-for="dttheme-<?php echo esc_attr($key);?>" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
								   <input class="hidden" id="dttheme-<?php echo esc_attr($key);?>" name="dttheme[general][post-types][<?php echo esc_attr($key);?>]" type="checkbox" value="<?php echo esc_attr($key);?>"
								   <?php if(array_key_exists($key, $sel_posttypes)) checked($sel_posttypes[$key],$key);?>/>
							  </div><?php
						endforeach;
                        echo '<div class="hr"></div>';

						$checked = ( true ==  painting_option('general','enable-pagebuilder') ) ? ' checked="checked"' : '';
						$switchclass = ( true ==  painting_option('general', 'enable-pagebuilder') ) ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                        <h6><?php esc_html_e('Keep page builder active in above selected post types', 'painting'); ?></h6>
                        <div data-for="dttheme-enable-pagebuilder" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input class="hidden" id="dttheme-enable-pagebuilder" name="dttheme[general][enable-pagebuilder]" type="checkbox" value="true" <?php $checked; ?>/>
                        <div class="hr"></div><?php
					endif; ?>

                	<h6><?php esc_html_e('Replace Buddha Panel Logo','painting');?></h6>
                    <div class="column one-fifth">
						<?php $checked = ( "true" ==  painting_option('general','enable-bpanel-logo-url') ) ? ' checked="checked"' : ''; ?>
                        <?php $switchclass = ( "true" ==  painting_option('general','enable-bpanel-logo-url') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        <div data-for="enable-bpanel-logo-url" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input class="hidden" id="enable-bpanel-logo-url" name="dttheme[general][enable-bpanel-logo-url]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>

                    <div class="column four-fifth last">
                        <div class="image-preview-container">
                            <input id="dttheme-bpanellogo" name="dttheme[general][bpanel-logo-url]" type="text" class="uploadfield medium" readonly="readonly"
                                value="<?php echo painting_option('general','bpanel-logo-url');?>" />
                            <input type="button" value="<?php esc_attr_e('Upload','painting');?>" class="upload_image_button show_preview" />
                            <input type="button" value="<?php esc_attr_e('Remove','painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('general','bpanel-logo-url'),true,'logo.png');?>
                        </div>
                    </div>
                    <p class="note"><?php esc_html_e('Upload an image to replace the default buddha panel logo.<b><i>You can set your own brand</i></b>. ','painting');?></p>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
            
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Global Page Layouts','painting');?></h3>
                </div>
                <div class="box-content">
                
                    <div class="bpanel-option-set">
                        <h6><?php esc_html_e('Force to Enable Global Page Layout','painting');?></h6>
                        <?php painting_switch("",'general','force-enable-global-layout');?>
                        <p class="note"> <?php esc_html_e('Enable or Disable global page layout ("Disaplay Everywhere" sidebar) for all pages, posts, archive pages.','painting');?>  </p>
                    </div>
                    <div class="clear"> </div>
                    <div class="hr"> </div>
                
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="dt-global-page">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                        foreach($layout as $key => $value):
                            $class = ( $key ==  painting_option('general',"global-page-layout")) ? " class='selected' " : "";
                            echo "<li><a href='#' rel='{$key}' {$class}><img src='".PAINTING_URI."/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                        endforeach; ?>
                        </ul>
                        <input id="dttheme[general][global-page-layout]" name="dttheme[general][global-page-layout]" type="hidden" value="<?php echo painting_option('general',"global-page-layout");?>"/>
                    </div>
                        
                </div> 
            </div>
            
        </div><!--tab3-advanced end-->

    </div><!-- .bpanel-main-content end-->
</div><!-- general end-->