<?php
/* ---------------------------------------------------------------------------
 * Load all theme options in back-end
 * --------------------------------------------------------------------------- */
function painting_options_page(){ ?>
<!-- wrapper -->
<div id="wrapper">

	<!-- Result -->
    <div id="bpanel-message" style="display:none;"></div>
    <div id="ajax-feedback" style="display:none;"><img src="<?php echo esc_url( PAINTING_URI . '/framework/theme-options/images/loading.png' );?>" alt="<?php esc_attr_e('loader', 'painting');?>" /> </div>
    <!-- Result -->

	<!-- panel-wrap -->
	<div id="panel-wrap">
    
       	<!-- bpanel-wrapper -->
        <div id="bpanel-wrapper">
        
           	<!-- bpanel -->
           	<div id="bpanel">

                	<!-- bpanel-left -->
                	<div id="bpanel-left">
                    	<div id="logo"><?php
                        	 $logo =  PAINTING_URI . '/framework/theme-options/images/logo.png';
							 $general = painting_option('general');
							 if(isset($general['bpanel-logo-url']) && isset($general['enable-bpanel-logo-url']))
							  	$logo = $general['bpanel-logo-url']; ?>
                             <img src="<?php echo esc_url($logo);?>" width="186" height="101" alt="<?php esc_html_e('Buddha Panel Logo', 'painting');?>" />
						</div><?php
						/* ---------------------------------------------------------------------------
						 * Load all theme option tabs.
						 * --------------------------------------------------------------------------- */
						$tabs = array(
							'general' 		=>	array('icon' => 'dashicons-admin-home', 'name'=>esc_html__('General','painting'), 'display' => true),
							'layout' 		=>	array('icon' => 'dashicons-exerpt-view', 'name'=>esc_html__('Layout','painting'), 'display' => true),
							'widgetarea' 	=>	array('icon' => 'dashicons-welcome-widgets-menus', 'name'=>esc_html__('Widget Area','painting'), 'display' => true),
							'pageoptions'	=>	array('icon' => 'dashicons-admin-page', 'name'=>esc_html__('Page Options','painting'), 'display' => true),
							'colors'		=>	array('icon' => 'dashicons-admin-appearance', 'name'=>esc_html__('Colors','painting'), 'display' => true),
							'fonts'			=>	array('icon' => 'dashicons-editor-spellcheck', 'name'=>esc_html__('Fonts','painting'), 'display' => true),
							'woocommerce'	=>	array('icon' => 'dashicons-cart', 'name'=>esc_html__('WooCommerce','painting'), 'display' => false),	
							'appointment'	=>	array('icon' => 'dashicons-feedback', 'name'=>esc_html__('Appointment','painting'), 'display' => false),
							'privacy'	    =>  array('icon' => 'dashicons-chart-pie', 'name'=>esc_html__('Privacy & Cookies','painting'), 'display'=>true),
							'importer'		=>	array('icon' => 'dashicons-upload', 'name'=>esc_html__('Importer','painting'), 'display' => true),
							'backup'		=>	array('icon' => 'dashicons-backup', 'name'=>esc_html__('Backup','painting'), 'display' => true),
						);	
						
						if(class_exists('woocommerce')) $tabs['woocommerce']['display'] = true;
						if(class_exists('DTAppointmentAddon')) $tabs['appointment']['display'] = true;
						if(class_exists('DTCorePlugin')) $tabs['importer']['display'] = true;
						
						$output = '<ul id="bpanel-mainmenu">';
							foreach($tabs as $tabkey => $tab ):
								if($tab['display']) $output .= '<li><a href="#'.$tabkey.'" title="'.$tab['name'].'"><span class="dashicons '.$tab['icon'].'"></span>'.$tab['name'].'</a></li>';
							endforeach;
						$output .= '</ul>';
						echo painting_wp_kses($output);?>
                    </div><!-- bpanel-left  end-->
                    
                    <form id="painting_options_form" name="painting_options_form" enctype="multipart/form-data" method="post" action="options.php">
		                <?php settings_fields( 'dttheme' );?>
                        <input type="hidden" id="dttheme-full-submit" name="dttheme-full-submit" value="0" />
                        <input type="hidden" name="dttheme_admin_wpnonce" value="<?php echo wp_create_nonce('dttheme_wpnonce');?>" /><?php
						/* ---------------------------------------------------------------------------
						 * Load theme options php files
						 * --------------------------------------------------------------------------- */
						foreach($tabs as $tabkey => $tab ):
							if($tab['display']) require_once( PAINTING_DIR .'/framework/theme-options/' .$tabkey. '.php' );
						endforeach; ?>
						<!-- bpanel-bottom -->
                        <div id="bpanel-bottom">
                           <input type="submit" value="<?php esc_html_e('Reset All','painting');?>" class="save-reset dttheme-reset-button bpanel-button white-btn" name="dttheme[reset]" />
						   <input type="submit" value="<?php esc_html_e('Save All','painting');?>" name="submit"  class="save-reset dttheme-footer-submit bpanel-button white-btn" />
                        </div><!-- bpanel-bottom end-->        
                    </form>

            </div><!-- bpanel -->

        </div><!-- bpanel-wrapper -->
    </div><!-- panel-wrap end -->
</div><!-- wrapper end-->
<?php
} ?>