<?php
/** My Twitter Widget
  * Objective:
  *		1.To list out the latest tweets
**/
class DT_Mailchimp extends WP_Widget {
	#1.constructor
	function __construct() {
		$widget_ops = array(
			'classname' => 'mailchimp',
			'description' => esc_html__( 'Use this widget to add a mailchimp newsletter to your site', 'painting' ),
			'customize_selective_refresh' => true,
		);
		parent::__construct( 'mailchimp-newsletter', PAINTING_NAME.' '.esc_html__('Mailchimp Newsletter', 'painting'), $widget_ops );
	}
	
	
	#2.widget input form in back-end
	function form($instance) {
		$instance = wp_parse_args( (array) $instance,array( 'title' => "", "list_id" => "") );
		
		$title 		= 	empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$desc 		= 	empty($instance['desc']) ?	'' : strip_tags($instance['desc']);
		$list_id 	=	empty($instance['list_id']) ? '' : strip_tags($instance['list_id']);
		
		if( painting_option('general','mailchimp-key') ):
		
			$apiKey = painting_option('general','mailchimp-key');
			$mailchimp_lists = painting_mailchimp_list_ids($apiKey);
		
			?>
            
            <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:','painting');?></label>
               <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>"  
                      type="text" value="<?php echo esc_attr($title); ?>" /></p>

            <p><label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"><?php esc_html_e('Description:','painting');?></label>
               <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>" ><?php echo esc_html($desc); ?></textarea></p>
                      
            <p><label for="<?php echo esc_attr($this->get_field_id('list_id')); ?>"><?php esc_html_e('Select List:','painting'); ?></label>
               <select id="<?php echo esc_attr($this->get_field_id('list_id')); ?>" name="<?php echo esc_attr($this->get_field_name('list_id')); ?>">
               <?php foreach ($mailchimp_lists as $key => $value):
			   			$id = $value['id'];
						$name = $value['name'];
						$selected = ( $list_id == $id ) ? ' selected="selected" ' : '';
						echo "<option $selected value='$id'>$name</option>";
					 endforeach;?></select></p>
                      
<?php   else:
			echo "<p>".esc_html__("Paste your mailchimp api key in BPanel at General Settings tab",'painting')."</p>";
		endif;
	}
	
	#3.processes & saves the mailchimp widget option
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['desc'] = strip_tags($new_instance['desc']);
		$instance['list_id'] = strip_tags($new_instance['list_id']);
		return $instance;
	}
	
	#4.output in front-end
	function widget($args, $instance) {
		extract($args);
		echo painting_wp_kses($before_widget);
		$title = empty($instance['title']) ? '' : strip_tags($instance['title']);
		$title = apply_filters( 'widget_title', $title );

		$desc = empty($instance['desc']) ? '' : strip_tags($instance['desc']);

		$list_id = isset($instance['list_id']) ? $instance['list_id'] : '';
		
		if ( !empty( $title ) ) echo painting_wp_kses($before_title.$title.$after_title);
		
		if ( !empty( $desc ) ) echo "<p>$desc</p>";
		
		$mcapi = painting_option('general','mailchimp-key');
		
		echo '<form name="frmNewsletter" method="post" class="mailchimp-form">';
		echo '	<input type="hidden" placeholder="'.esc_html__('Name','painting').'" name="dt_mc_name" id="dt_mc_name" value="" required />';
		echo '	<input type="email" placeholder="'.esc_html__('Enter Email','painting').'" name="dt_mc_emailid" id="dt_mc_emailid" value="" required />';
		echo "	<input type='hidden' name='dt_mc_apikey' id='dt_mc_apikey' value='$mcapi' />";
		echo "	<input type='hidden' name='dt_mc_listid' id='dt_mc_listid' value='$list_id' />";
		echo '	<input type="submit" name="submit" class="dt-sc-button" value="&#xf178;" />';

		echo '<p>'.apply_filters('dt_sc_mailchimp_form_elements', $privacy, $attrs ).'</p>';

		echo '</form>';
		
		echo '<div id="ajax_newsletter_msg"></div>';

		echo painting_wp_kses($after_widget);		
	}
}?>