<?php 
/** My Twitter Widget
  * Objective:
  *		1.To list out the latest tweets
**/
class DT_Twitter extends WP_Widget {
	#1.constructor
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_tweetbox',
			'description' => esc_html__( 'To Show latest twitter tweets', 'painting' ),
			'customize_selective_refresh' => true,
		);
		parent::__construct( 'twitter', PAINTING_NAME.' '.esc_html__('Twitter', 'painting'), $widget_ops );
	}

	#2.widget input form in back-end
	function form($instance) {
		$instance = wp_parse_args( (array) $instance,array( 'title' => esc_html__('Latest Tweets','painting'), 'count' => '3', 'type' => 'type1', 'username' => '',
						'exclude_replies'=>'1' , 'time'=>'1', 'consumer_key'=>'','consumer_secret'=>'','access_token'=>'','access_token_secret'=>'') );
						
		$title = 					empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$consumer_key = 			empty($instance['consumer_key']) ?	'' : strip_tags($instance['consumer_key']);
		$consumer_secret = 			empty($instance['consumer_secret']) ?	'' : strip_tags($instance['consumer_secret']);
		$access_token = 			empty($instance['access_token']) ?	'' : strip_tags($instance['access_token']);
		$access_token_secret = 		empty($instance['access_token_secret']) ?	'' : strip_tags($instance['access_token_secret']);
		$count = 					empty($instance['count']) ? '' : strip_tags($instance['count']);
		$username = 				empty($instance['username']) ? '' : strip_tags($instance['username']);
		$exclude_replies = 			empty($instance['exclude_replies']) ? 0 : 1;
		$time = 					empty($instance['time']) ? 0 : 1;?>
        
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:','painting');?></label>
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
            type="text" value="<?php echo esc_attr($title); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('consumer_key')); ?>"><?php esc_html_e('Consumer Key:','painting');?></label>
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('consumer_key')); ?>" name="<?php echo esc_attr($this->get_field_name('consumer_key')); ?>" 
            type="text" value="<?php echo esc_attr($consumer_key); ?>" /></p>
            
        <p><label for="<?php echo esc_attr($this->get_field_id('consumer_secret')); ?>"><?php esc_html_e('Consumer Secret:','painting');?></label> 
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('consumer_secret')); ?>" name="<?php echo esc_attr($this->get_field_name('consumer_secret')); ?>" 
            type="text" value="<?php echo esc_attr($consumer_secret); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('access_token')); ?>"><?php esc_html_e('Access Token:','painting');?></label>
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('access_token')); ?>" name="<?php echo esc_attr($this->get_field_name('access_token')); ?>" 
            type="text" value="<?php echo esc_attr($access_token); ?>" /></p>
            
        <p><label for="<?php echo esc_attr($this->get_field_id('access_token_secret')); ?>"><?php esc_html_e('Access Token Secret:','painting');?></label>
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('access_token_secret')); ?>" name="<?php echo esc_attr($this->get_field_name('access_token_secret')); ?>" 
            type="text" value="<?php echo esc_attr($access_token_secret); ?>" /></p>

        <p><label for="<?php echo esc_attr($this->get_field_id('username')); ?>"><?php esc_html_e('Enter your twitter username:','painting');?></label>
           <input class="widefat" id="<?php echo esc_attr($this->get_field_id('username')); ?>" name="<?php echo esc_attr($this->get_field_name('username')); ?>"
            type="text" value="<?php echo esc_attr($username); ?>" /></p>
            
        <p><label for="<?php echo esc_attr($this->get_field_id('count')); ?>"><?php esc_html_e('How many entries do you want to show:','painting');?></label>
        	<select class="widefat" id="<?php echo esc_attr($this->get_field_id('count')); ?>" name="<?php echo esc_attr($this->get_field_name('count')); ?>">
            <?php for($i = 1; $i <= 20; $i++):	
					$selected = ($count == $i ) ? "selected='selected'" : "";?>
	              <option <?php echo($selected);?> value="<?php echo($i);?>"><?php echo($i);?></option>
            <?php endfor;?>
            </select></p>
            
        <p><input type="checkbox"  id="<?php echo esc_attr($this->get_field_id('exclude_replies'));?>" name="<?php echo esc_attr($this->get_field_name('exclude_replies'));?>" 
			<?php checked($exclude_replies); ?> /> <label for="<?php echo esc_attr($this->get_field_id('exclude_replies')); ?>"><?php esc_html_e('Exclude @replies','painting');?></label></p>
            
        <p><input type="checkbox"  id="<?php echo esc_attr($this->get_field_id('time'));?>" name="<?php echo esc_attr($this->get_field_name('time'));?>" 
			<?php checked($time); ?> /> <label for="<?php echo esc_attr($this->get_field_id('time')); ?>"><?php esc_html_e('Show time of tweet','painting');?></label></p>
            
<?php
	}
	
	#3.processes & saves the twitter widget option
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['consumer_key'] = strip_tags($new_instance['consumer_key']);
		$instance['consumer_secret'] = strip_tags($new_instance['consumer_secret']);
		$instance['access_token'] = strip_tags($new_instance['access_token']);
		$instance['access_token_secret'] = strip_tags($new_instance['access_token_secret']);
		$instance['count'] = strip_tags($new_instance['count']);
		$instance['username'] = strip_tags($new_instance['username']);
		$instance['exclude_replies'] = empty($new_instance['exclude_replies']) ? 0 : 1;
		$instance['time'] = empty($new_instance['time']) ? 0 : 1;
		return $instance;
	}
	
	#4.output in front-end
	function widget($args, $instance) {
		extract($args);
			$title = 			empty($instance['title']) ?	'' : strip_tags($instance['title']);
			$consumer_key = 			empty($instance['consumer_key']) ?	'' : strip_tags($instance['consumer_key']);
			$consumer_secret = 			empty($instance['consumer_secret']) ?	'' : strip_tags($instance['consumer_secret']);
			$access_token = 			empty($instance['access_token']) ?	'' : strip_tags($instance['access_token']);
			$access_token_secret = 			empty($instance['access_token_secret']) ?	'' : strip_tags($instance['access_token_secret']);
			$count = 			empty($instance['count']) ? '' : strip_tags($instance['count']);
			$username = 		empty($instance['username']) ? '' : strip_tags($instance['username']);
			$exclude_replies = 	empty($instance['exclude_replies']) ? false : true;
			$time = 			empty($instance['time']) ? false : true;

		echo painting_wp_kses($before_widget);			
			
			$title = apply_filters('widget_title', $title );
			if ( !empty( $title ) ) { echo painting_wp_kses($before_title . $title . $after_title); };
			
			if($username && $consumer_key && $consumer_secret && $access_token && $access_token_secret && $count) { 

					$transName = 'list_tweets';
					$cacheTime = 10;
			
					require_once(PAINTING_CORE_PLUGIN.'/apis/twitteroauth/twitteroauth.php');
					
						$twitterConnection = new TwitterOAuth($consumer_key, $consumer_secret, $access_token, $access_token_secret );
						$twitterData = $twitterConnection->get('statuses/user_timeline',array('screen_name' => $username, 'count' => $count,'exclude_replies' => $exclude_replies));
			
						 if($twitterConnection->http_code != 200) {
							 $twitterData = get_transient($transName);
						 }
			 
					set_transient($transName, $twitterData, 60 * 10);
					$twitter = get_transient($transName);
				
				echo "<ul class='tweet_list'>";
				if($twitter && is_array($twitter)) {
					foreach( $twitter as $tweet ):

						$latestTweet = $tweet->text;

						$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";

						if(preg_match($reg_exUrl, $latestTweet, $url)) {
						    $latestTweet = preg_replace($reg_exUrl, '<a href="'.$url[0].'" rel="nofollow">'.$url[0].'</a>', $latestTweet);
						}

						$twitterTime = strtotime($tweet->created_at);
						$twitterTime = !empty($tweet->utc_offset) ? $twitterTime+($tweet->utc_offset ) : $twitterTime;
						$timeAgo = date_i18n(  get_option('date_format'), $twitterTime );

						
						echo '<li class="tweet">';
								
								echo '<span class="tweet-text">'.$latestTweet.'</span>';
								if( $tweet->created_at ) echo '<span class="tweet_time"><a href="http'.painting_ssl().'://twitter.com/'.$username.'">'.$this->getTimeDifference($tweet->created_at).'</a></span>';
							
						echo '</li>';

					endforeach;
				} else {
					echo '<li>'.esc_html__('No public Tweets found','painting').'</li>';
				}
				echo "</ul>";
			}
		echo painting_wp_kses($after_widget);
	}
	
	function getTimeDifference($time) {
		$currentTime = date('Y-m-d H:i:s');
		$toTime = strtotime($currentTime);
		$fromTime = strtotime($time);
		$timeDiff = floor(abs($toTime - $fromTime) / 60);
		if ($timeDiff < 2) {
			$timeDiff = esc_html__('Just now', 'painting');
		} elseif ($timeDiff > 2 && $timeDiff < 60) {
			$timeDiff = esc_html__('about ','painting').floor(abs($timeDiff)) . esc_html__(' minutes ago', 'painting');
		} elseif ($timeDiff > 60 && $timeDiff < 120) {
			$timeDiff = esc_html__('about ','painting').floor(abs($timeDiff / 60)) . esc_html__(' hour ago', 'painting');
		} elseif ($timeDiff < 1440) {
			$timeDiff = esc_html__('about ','painting').floor(abs($timeDiff / 60)) . esc_html__(' hours ago', 'painting');
		} elseif ($timeDiff > 1440 && $timeDiff < 2880) {
			$timeDiff = esc_html__('about ','painting').floor(abs($timeDiff / 1440)) . esc_html__(' day ago', 'painting');
		} elseif ($timeDiff > 2880) {
			$timeDiff = esc_html__('about ','painting').floor(abs($timeDiff / 1440)) . esc_html__(' days ago', 'painting');
		}
		return $timeDiff;
	}
	
}?>