<?php

/* ---------------------------------------------------------------------------
 * Buddha Panel Default Options
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_default_option')) {
function painting_default_option() {
	
	$general = array(
					"enable-preloader" 			=>	"true",
					"enable-responsive" 		=>	"true",
					"post-types"				=>	array("page" => "page"),
					"enable-pagebuilder"		=>	false,
					);
				
	$layout = array(
					"logo" 						=>	"true",
					"site-layout" 				=>	"wide",
					'breadcrumb-delimiter' 		=> 	'fa-angle-right',
					"topbar-leftcontent"		=> 	'',
					"topbar-rightcontent"		=> 	'',
					"enable-footer" 			=> 	"true",
					"footer-columns" 			=>	"4",
					"enable-copyright" 			=> 	"true",
					"copyright-content" 		=> 	'Painting theme by iamdesigning. © 2016 <a href="http://themeforest.net/user/buddhathemes" title="BuddhaThemes">Buddha Themes</a>',
					"enable-footer-menu" 		=> 	"true",
					);
		
	$pageoptions = array(
					"single-post-meta" 			=>	"true",
					"single-post-authorbox"	 	=>	"true",
					"single-post-comments" 		=>	"true",
					"archives-layout-type" 		=>	"type1",
					"single-portfolio-related" 	=>	"true",
					"portfolio-archives-space" 	=>	"true",
					"enable-404message" 		=>	"true",
					"custom404-message" 		=>	'[dt_sc_title type="h2"]404 - Page Not Found[/dt_sc_title]
													[dt_sc_title type="h3"]The Page you are looking for is not found or does not exist[/dt_sc_title]
													<p>Etiam sit amet orci eget eros faucibus tincidunt. Duis kalam <br> stefen kajas in the enter leo. Sed fringilla mauris sit amet nibh.</p>
													[dt_sc_button type="type7" size="small" target="_blank" link="#"]Back to Home[/dt_sc_button]
													[dt_sc_hr_invisible /]'
					);

	$colors = array(
			"theme-skin" 						=>	"default"
			);
			
	$woo = array (
			'shop-apply-isotope' 				=>	true,
			'shop-page-product-layout' 			=>	'one-fourth-column',
			'shop-upsellrelated-product-layout' =>	'one-third-column',
			);
			
	$appointments = array(		
			'dt_company_monday_start' 			=> '08:00',
			'dt_company_monday_end' 			=> '17:00',
	
			'dt_company_tuesday_start' 			=> '08:00',
			'dt_company_tuesday_end' 			=> '17:00',
	
			'dt_company_wednesday_start' 		=> '08:00',
			'dt_company_wednesday_end' 			=> '17:00',
	
			'dt_company_thursday_start' 		=> '08:00',
			'dt_company_thursday_end' 			=> '17:00',
	
			'dt_company_friday_start' 			=> '08:00',
			'dt_company_friday_end' 			=> '18:00',
	
			'notification_sender_name' 			=> get_option( 'blogname' ),
			'notification_sender_email' 		=> get_option( 'admin_email' ),
			
			'appointment_notification_to_staff_subject' 			=>  'Hi [STAFF_NAME] , New booking information ( Booking id: [APPOINTMENT_ID] )',
			'appointment_notification_to_staff_message' 			=> '<p> Hello [STAFF_NAME], </p>
																		<p> Your new Booking id : [APPOINTMENT_ID] </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>Client Address: [CLIENT_ADDRESS]</p>
																		<p>[APPOINTMENT_BODY]</p>',
		
		
			'modified_appointment_notification_to_staff_subject' 	=> 'Hi [STAFF_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Modified',
			'modified_appointment_notification_to_staff_message' 	=> '<p> Hello [STAFF_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was modified </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>Client Address: [CLIENT_ADDRESS]</p>
																		<p>[APPOINTMENT_BODY]</p>',
			
			'deleted_appointment_notification_to_staff_subject' 	=> 'Hi [STAFF_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Deleted / Declined',
			'deleted_appointment_notification_to_staff_message'		=> '<p> Hello [STAFF_NAME], </p>
																		<p> Booking id : [APPOINTMENT_ID]  was Deleted / Declined </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>Client Address: [CLIENT_ADDRESS]</p>
																		<p>[APPOINTMENT_BODY]</p>',
			
			'agenda_to_staff_subject' 								=> 'Hi [STAFF_NAME] , Your Agenda for [TOMORROW]',
			'agenda_to_staff_message' 								=> '<p> Hello [STAFF_NAME], </p><p>Your agenda for tomorrow is </p><p>[TOMORROW_AGENDA]</p>',
	
			'appointment_notification_to_client_subject' 			=> 'Hi [CLIENT_NAME] , New booking information ( Booking id: [APPOINTMENT_ID] )',
			'appointment_notification_to_client_message' 			=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your new Booking id : [APPOINTMENT_ID] </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>[APPOINTMENT_BODY]</p>
																		<p></p>
																		<p>Thank you for choosing our company.</p>',
	
			'modified_appointment_notification_to_client_subject' 	=> 'Hi [CLIENT_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Modified',
			'modified_appointment_notification_to_client_message' 	=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was modified </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>[APPOINTMENT_BODY]</p>
																		<p></p>
																		<p>Thank you for choosing our company.</p>',
			
			'deleted_appointment_notification_to_client_subject' 	=> 'Hi [CLIENT_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Deleted / Declined',
			'deleted_appointment_notification_to_client_message' 	=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was Deleted / Declined </p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>[APPOINTMENT_BODY]</p>',
		
			'success_message' 										=>	'[dt_sc_titled_box type="success-box"]Appointment created successfully. Our professional will come to your locations and give you a free extimate for the work.[/dt_sc_titled_box]',
			'error_message' 										=>	'[dt_sc_titled_box type="error-box"]Oops! Something went wrong![/dt_sc_titled_box]',
	
		);
			
	$data = array(
			"general"	 						=>	$general,
			"layout" 							=>	$layout,
			"pageoptions" 						=>	$pageoptions,
			"colors"							=>	$colors,
			"woo" 								=>	$woo,
			"appointments" 						=>	$appointments,
			);		
					
	return $data;
}
}

/* ---------------------------------------------------------------------------
 * Check activated plugins
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_is_plugin_active')) {
function painting_is_plugin_active( $plugin ) {
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if (is_plugin_active($plugin) || is_plugin_active_for_network($plugin)) return true;
	else return false;
}
}

/* ---------------------------------------------------------------------------
 * If you eanble responsive mode in theme , this will add view port at the head
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_responsive')) {
function painting_responsive() {
	if (painting_option('general', 'enable-responsive')) echo "<meta name='viewport' content='width=device-width, initial-scale=1, maximum-scale=1' />\r";
}
}
/* ---------------------------------------------------------------------------
 * Filter to adjust the embed videos
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_slt_wmode_opaque')) {
function painting_slt_wmode_opaque( $html, $url, $args ) {
	
	if( (strrpos($url,"youtube") !== false)  || (strrpos($url,"youtu.") !== false) ) {
		
		$patterns[] = '/src="(.*?)"/';
		$replacements[] = 'src="${1}&wmode=opaque"';
		
		$html =  preg_replace($patterns, $replacements, $html);
		$html = str_replace('</iframe>)', '</iframe>', $html);
		
	}elseif( strrpos($url, "soundcloud.com") !== false ) {
		
		$patterns[] = '/height="(.*?)"/';
		$replacements[] = 'height="166"';
		$html =  preg_replace($patterns, $replacements, $html);
		
		$patterns[] = '/width="(.*?)"/';
		$replacements[] = 'width="100%"';
		$html =  preg_replace($patterns, $replacements, $html);
		
		$patterns[] = '/visual=true&/';
		$replacements[] = '';
		$html =  preg_replace($patterns, $replacements, $html);
	}	
	
	return $html; 
          
}
}
add_filter( 'oembed_result', 'painting_slt_wmode_opaque', 10, 3 );


/* ---------------------------------------------------------------------------
 * Filter to adjust the embed videos
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_show_sidebar')) {
function painting_show_sidebar($type, $id, $sidebar = 'left'){

	if( $type === 'post'){
		$settings = get_post_meta($id,'_dt_post_settings',TRUE);
	}elseif( $type === 'page' ){
		$settings = get_post_meta($id,'_tpl_default_settings',TRUE);
	}

	$settings = is_array($settings) ? $settings  : array();
	
	if ( !array_key_exists('disable-standard-sidebar-'.$sidebar,$settings) ):
		if(is_active_sidebar('standard-sidebar-'.$sidebar)) dynamic_sidebar('standard-sidebar-'.$sidebar);
	endif;	
	
	if( array_key_exists('widget-area-'.$sidebar, $settings)):
		foreach ($settings['widget-area-'.$sidebar] as $widget ) {
			$id = mb_convert_case($widget, MB_CASE_LOWER, "UTF-8");
			if(is_active_sidebar($id)) dynamic_sidebar($id);
		}
	endif;
	
}
}

/* ---------------------------------------------------------------------------
 * To Generate Excerpt For Posts
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_excerpt')) {
function painting_excerpt($limit = NULL) {
	$limit = !empty($limit) ? $limit : 10;
	$excerpt = explode(' ', get_the_excerpt(), $limit);
	$excerpt = array_filter($excerpt);
	
	if (!empty($excerpt)) {
		if (count($excerpt) >= $limit) {
			array_pop($excerpt);
			$excerpt = implode(" ", $excerpt).'...';
		} else {
			$excerpt = implode(" ", $excerpt);
		}
		$excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
		return "<p>{$excerpt}</p>";
	}
}
}

/* ---------------------------------------------------------------------------
 * To User Avatar Of Required Size
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_avatar_url')) {
function painting_get_avatar_url($author_id, $size){
    $get_avatar = get_avatar( $author_id, $size );
    preg_match("/src='(.*?)'/i", $get_avatar, $matches);
    return ( $matches[1] );
}
}

/* ---------------------------------------------------------------------------
 * To Customize WordPress Comment list
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_custom_comments')) {
function painting_custom_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
	   case 'pingback' :
  	   case 'trackback' :
			echo '<li class="post pingback">';
			echo "<p>";
			  esc_html_e( 'Pingback:','painting');
			  comment_author_link();
			  edit_comment_link( esc_html__('Edit','painting'), ' ' ,'');
			echo "</p>";
	   break;

	   default :
	   case '' :
			echo "<li ";
			comment_class();
			echo ' id="comment-';
			comment_ID();
			echo '">';

			echo '<div class="comment">';
			
			echo '<header class="comment-author">'.get_avatar($comment, 85).'</header>';

			echo '<div class="comment-details">';
			
			echo '	<div class="author-name">'.ucfirst(get_comment_author_link()).'</div>';
			echo '	<div class="commentmetadata">'.get_comment_date('d M Y').'</div>';

			echo '  <div class="comment-body">';
			echo '		<div class="comment-content">';
							comment_text();
							if ($comment->comment_approved == '0') :
								esc_html_e('Your comment is awaiting moderation.', 'painting');
							endif;
							edit_comment_link(esc_html__('Edit', 'painting'));
			echo '		</div>';
			echo '	</div>';


			echo '	<div class="reply">';
				echo comment_reply_link(array_merge($args, array('reply_text' => esc_html__('Reply', 'painting'), 'depth' => $depth, 'max_depth' => $args['max_depth'])));
			echo '	</div>';

			echo '</div>';

			echo '</div>';
	   break;
	endswitch;
}
}


/* ---------------------------------------------------------------------------
 * Custom Function To Get Page Permalink By Its Template
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_page_permalink_by_its_template')) {
function painting_get_page_permalink_by_its_template( $temlplate ) {
	$permalink = '#';

	$pages = get_posts( array(
			'post_type' => 'page',
			'meta_key' => '_wp_page_template',
			'meta_value' => $temlplate,
			'suppress_filters' => false  ) );

	if ( is_array( $pages ) && count( $pages ) > 0 ) {
		$login_page = $pages[0];
		$permalink = get_permalink( $login_page->ID );
	}
	return $permalink;
}
}

/* ---------------------------------------------------------------------------
 * Remove rel attribute from the category list ( Validation purpose)
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_remove_category_list_rel')) {
function painting_remove_category_list_rel($output) {
	return str_replace(' rel="category tag"', '', $output);
}
}
add_filter('wp_list_categories', 'painting_remove_category_list_rel');
add_filter('the_category', 'painting_remove_category_list_rel');

/* ---------------------------------------------------------------------------
 * FILTER TO MODIFY THE DEFAULT CATEGORY WIDGET
 * --------------------------------------------------------------------------- */
add_filter('wp_list_categories', 'painting_wp_list_categories', 10, 2);
if (!function_exists('painting_wp_list_categories')) {
function painting_wp_list_categories($output, $args) {
	
	$output = mb_convert_encoding($output, 'HTML-ENTITIES', "UTF-8");
			
	$doc = new DomDocument();
	$file = @$doc->loadHTML($output);
	
	$result = array();
	$litag = $doc->getElementsByTagName('li');
	foreach($litag AS $item)
	{

		foreach($item->getElementsByTagName('ul') as $ul_tag){
			if($ul_tag->getAttribute('class') == 'children') {
				$ul_tag->setAttribute('class', 'children dt-sc-toggle-content');
				$ul_tag->parentNode->firstChild->setAttribute('class', 'dt-sc-toggle');
				$spanplus = $doc->createElement('span');
				$spanplus->setAttribute('class', 'fa fa-plus-square');
				$spanminus = $doc->createElement('span');
				$spanminus->setAttribute('class', 'fa fa-minus-square');
				$ul_tag->parentNode->firstChild->appendChild($spanplus);
				$ul_tag->parentNode->firstChild->appendChild($spanminus);
			}
		}
		
	}
		
	$output = @$doc->saveHTML();
	
	if(!isset($args['taxonomy'])) {
		$output = str_replace('</a> (', '<span> ', $output);
		$output = str_replace(')', '</span></a> ', $output);
	}
	
	return $output;
	
}
}
/* ---------------------------------------------------------------------------
 * FILTER TO MODIFY THE DEFAULT ARCHIVES WIDGET
 * --------------------------------------------------------------------------- */
add_filter('get_archives_link', 'painting_wp_list_archive');
if (!function_exists('painting_wp_list_archive')) {
function painting_wp_list_archive($output) {
	$output = str_replace('</a>&nbsp;(', '<span> ', $output);
	$output = str_replace(')', '</span></a> ', $output);
	return $output;
}
}

/* ---------------------------------------------------------------------------
 * FILTER TO MODIFY THE POST BEFORE FECTHING
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_add_custom_types')) {
function painting_add_custom_types( $query ) {
    if( is_tag() && empty( $query->query_vars['suppress_filters'] ) ) {
        $post_types = get_post_types();
        $query->set( 'post_type', $post_types );
        return $query;
    }
}
}
add_filter( 'pre_get_posts', 'painting_add_custom_types' );

/* ---------------------------------------------------------------------------
 * Style Picker
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_color_picker')) {
function painting_color_picker(){

	$skins_url = PAINTING_URI."/images/style-picker/";
	
	$patterns = "";
	$patterns_array =  painting_listImage(TEMPLATEPATH."/images/style-picker/patterns/");
	
	foreach($patterns_array as $k => $v){
		$img = 	PAINTING_URI."/images/style-picker/patterns/".$k;
		$patterns .= '<li>';
		$patterns .= "<a data-image='".esc_attr($k)."' href='#' title='".esc_attr($v)."'>";
		$patterns .= "<img src='".esc_url($img)."' alt='".esc_attr($v)."' title='".esc_attr($v)."' width='30' height='30' />";
		$patterns .= '</a>';
		$patterns .= '</li>'; 
	}
	
	$str = '<!-- **BuddhaThemes Style Picker Wrapper** -->';
	$str .= '<div class="dt-style-picker-wrapper">';
	$str .= '	<a href="" title="" class="style-picker-ico"> <img src="'.PAINTING_URI.'/images/style-picker/picker-icon.png" alt="'.esc_html__('Picker Icon', 'painting').'" title="'.esc_html__('Picker Icon', 'painting').'" width="20" height="20" /> </a>';
	$str .= '	<div id="dt-style-picker">';
	$str .= '   	<h2>'.esc_html__('Select Your Style','painting').'</h2>';
	$str .= '       <h3>'.esc_html__('Choose your layout','painting').'</h3>';
	$str .= '		<ul class="layout-picker">';
	$str .= '       	<li> <a id="fullwidth" href="#" title="full-width" class="selected"> <span>'.esc_html__('Full width', 'painting').'</span> </a> </li>';
	$str .= '       	<li> <a id="boxed" href="#" title="boxed"> <span>'.esc_html__('Boxed', 'painting').'</span> </a> </li>';
	$str .= '		</ul>';
	$str .= '		<div class="hr"> </div>';
	
	$str .= '		<div id="pattern-holder" class="hidden">';
	$str .= '			<h3>'.esc_html__('Patterns for Boxed Layout','painting').'</h3>';
	$str .= '			<ul class="pattern-picker">';
	$str .= 				$patterns;
	$str .= '			</ul>';
	$str .= '		</div>';
	
	$str .= '	</div>';
	$str .= '</div><!-- **BuddhaThemes Style Picker Wrapper - End** -->';
	
	echo painting_wp_kses($str);
	
}
}
/* ---------------------------------------------------------------------------
 * To Convert Hexadecimal to RGB code
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_hex2rgb')) {
function painting_hex2rgb($hex) {
	$hex = str_replace ( "#", "", $hex );
	
	if (strlen ( $hex ) == 3) :
		$r = hexdec ( substr ( $hex, 0, 1 ) . substr ( $hex, 0, 1 ) );
		$g = hexdec ( substr ( $hex, 1, 1 ) . substr ( $hex, 1, 1 ) );
		$b = hexdec ( substr ( $hex, 2, 1 ) . substr ( $hex, 2, 1 ) );
	 else :
		$r = hexdec ( substr ( $hex, 0, 2 ) );
		$g = hexdec ( substr ( $hex, 2, 2 ) );
		$b = hexdec ( substr ( $hex, 4, 2 ) );
	endif;
	$rgb = array ( $r,$g,$b);
	return $rgb;
}
}
/* ---------------------------------------------------------------------------
 * wp_kses filter function
 * --------------------------------------------------------------------------- */

if( !function_exists( 'painting_wp_kses' ) ){
	function painting_wp_kses($content) {
		
		$dt_allowed_html_tags = array(
			'a' => array('class' => array(), 'data-product_id' => array(), 'href' => array(), 'title' => array(), 'target' => array(), 'id' => array(), 'data-post-id' => array(), 'data-gal' => array(), 'data-image' => array(), 'rel' => array()),
			'abbr' => array('title' => array()),
			'address' => array(),
			'area' => array('shape' => array(), 'coords' => array(), 'href' => array(), 'alt' => array()),
			'article' => array('id' => array(), 'class' => array()),
			'aside' => array('id' => array(), 'class' => array()),
			'audio' => array('autoplay' => array(), 'controls' => array(), 'loop' => array(), 'muted' => array(), 'preload' => array(), 'src' => array()),
			'b' => array(),
			'base' => array('href' => array(), 'target' => array()),
			'bdi' => array(),
			'bdo' => array('dir' => array()), 
			'blockquote' => array('cite' => array()), 
			'br' => array(),
			'button' => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'name' => array(), 'type' => array(), 'value' => array()),
			'canvas' => array('height' => array(), 'width' => array()),
			'caption' => array('align' => array()),
			'cite' => array(),
			'code' => array(),
			'col' => array(),
			'colgroup' => array(),
			'datalist' => array('id' => array()),
			'dd' => array(),
			'del' => array('cite' => array(), 'datetime' => array()),
			'details' => array('open' => array()),
			'dfn' => array(),
			'dialog' => array('open' => array()),
			'div' => array('class' => array(), 'id' => array(), 'style' => array(), 'align' => array(), 'data-for' => array()),
			'dl' => array(),
			'dt' => array(),
			'em' => array(),
			'embed' => array('height' => array(), 'src' => array(), 'type' => array(), 'width' => array()),
			'fieldset' => array('disabled' => array(), 'form' => array(), 'name' => array()),
			'figcaption' => array(),
			'figure' => array(),
			'form' => array('accept' => array(), 'accept-charset' => array(), 'action' => array(), 'autocomplete' => array(), 'enctype' => array(), 'method' => array(), 'name' => array(), 'novalidate' => array(), 'target' => array(), 'id' => array(), 'class' => array()),
			'h1' => array('class' => array()), 'h2' => array('class' => array()), 'h3' => array('class' => array()), 'h4' => array('class' => array()), 'h5' => array('class' => array()), 'h6' => array('class' => array()),
			'hr' => array(), 
			'i' => array('class' => array(), 'id' => array()), 
			'iframe' => array('name' => array(), 'seamless' => array(), 'src' => array(), 'srcdoc' => array(), 'width' => array(), 'height' => array(), 'frameborder' => array(), 'allowfullscreen' => array(), 'mozallowfullscreen' => array(), 'webkitallowfullscreen' => array(), 'title' => array()),
			'img' => array('alt' => array(), 'crossorigin' => array(), 'height' => array(), 'ismap' => array(), 'src' => array(), 'usemap' => array(), 'width' => array(), 'title' => array(), 'data-default' => array()),
			'input' => array('align' => array(), 'alt' => array(), 'autocomplete' => array(), 'autofocus' => array(), 'checked' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'height' => array(), 'list' => array(), 'max' => array(), 'maxlength' => array(), 'min' => array(), 'multiple' => array(), 'name' => array(), 'pattern' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'size' => array(), 'src' => array(), 'step' => array(), 'type' => array(), 'value' => array(), 'width' => array(), 'id' => array(), 'class' => array()),
			'ins' => array('cite' => array(), 'datetime' => array()),
			'label' => array('for' => array(), 'form' => array(), 'class' => array()),
			'legend' => array('align' => array()), 
			'li' => array('type' => array(), 'value' => array(), 'class' => array(), 'id' => array()),
			'link' => array('crossorigin' => array(), 'href' => array(), 'hreflang' => array(), 'media' => array(), 'rel' => array(), 'sizes' => array(), 'type' => array()),
			'main' => array(), 
			'map' => array('name' => array()), 
			'mark' => array(), 
			'menu' => array('label' => array(), 'type' => array()),
			'menuitem' => array('checked' => array(), 'command' => array(), 'default' => array(), 'disabled' => array(), 'icon' => array(), 'label' => array(), 'radiogroup' => array(), 'type' => array()),
			'meta' => array('charset' => array(), 'content' => array(), 'http-equiv' => array(), 'name' => array()),
			'object' => array('form' => array(), 'height' => array(), 'name' => array(), 'type' => array(), 'usemap' => array(), 'width' => array()),
			'ol' => array('class' => array(), 'reversed' => array(), 'start' => array(), 'type' => array()),
			'option' => array('value' => array(), 'selected' => array()),
			'p' => array('class' => array()), 
			'q' => array('cite' => array()), 
			'section' => array(), 
			'select' => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'multiple' => array(), 'name' => array(), 'required' => array(), 'size' => array(), 'class' => array()),
			'small' => array(), 
			'source' => array('media' => array(), 'src' => array(), 'type' => array()),
			'span' => array('class' => array()), 
			'strong' => array(),
			'style' => array('media' => array(), 'scoped' => array(), 'type' => array()),
			'sub' => array(),
			'sup' => array(),
			'table' => array('sortable' => array()), 
			'tbody' => array(), 
			'td' => array('colspan' => array(), 'headers' => array()),
			'textarea' => array('autofocus' => array(), 'cols' => array(), 'disabled' => array(), 'form' => array(), 'maxlength' => array(), 'name' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'rows' => array(), 'wrap' => array()),
			'tfoot' => array(),
			'th' => array('abbr' => array(), 'colspan' => array(), 'headers' => array(), 'rowspan' => array(), 'scope' => array(), 'sorted' => array()),
			'thead' => array(), 
			'time' => array('datetime' => array()), 
			'title' => array(), 
			'tr' => array(), 
			'track' => array('default' => array(), 'kind' => array(), 'label' => array(), 'src' => array(), 'srclang' => array()), 
			'u' => array(), 
			'ul' => array('class' => array(), 'id' => array()), 
			'var' => array(), 
			'video' => array('autoplay' => array(), 'controls' => array(), 'height' => array(), 'loop' => array(), 'muted' => array(), 'muted' => array(), 'poster' => array(), 'preload' => array(), 'src' => array(), 'width' => array()), 
			'wbr' => array(),
		);
	
		$data = wp_kses($content, $dt_allowed_html_tags);
		return $data;
		
	}
}

/* ---------------------------------------------------------------------------
 * Social share for post
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_social_share')) {
function painting_social_share() {
	
	global $post;
	
	$title = $post->post_title;
	$url = get_permalink ($post->ID);
	$excerpt = $post->post_excerpt;
	$data = '';
	
	$fb = painting_option('pageoptions', 'post-facebook');
	$data .= !empty($fb) ? '<li class="facebook"><a title="'.esc_html__('Facebook', 'painting').'" target="_blank" href="//www.facebook.com/sharer.php?u='.$url.'&amp;t='.urlencode($title).'"><i class="fa fa-facebook"></i></a></li>' : '';
	
	$delicious = painting_option('pageoptions', 'post-delicious');
	$data .= !empty($delicious) ? '<li class="delicious"><a title="'.esc_html__('Delicious', 'painting').'" target="_blank" href="//del.icio.us/post?url='.$url.'&amp;title='.urlencode($title).'"><i class="fa fa-delicious"></i></a></li>' : '';

	$digg = painting_option('pageoptions', 'post-digg');
	$data .= !empty($digg) ? '<li class="digg"><a title="'.esc_html__('Digg', 'painting').'" target="_blank" href="//digg.com/submit?phase=2&amp;url='.$url.'&amp;title='.urlencode($title).'"><i class="fa fa-digg"></i></a></li>' : '';

	$stumbleupon = painting_option('pageoptions', 'post-stumbleupon');
	$data .= !empty($stumbleupon) ? '<li class="stumbleupon"><a title="'.esc_html__('StumbleUpon', 'painting').'" target="_blank" href="//www.stumbleupon.com/submit?url='.$url.'&amp;title='.urlencode($title).'"><i class="fa fa-stumbleupon"></i></a></li>' : '';
	
	$twitter = painting_option('pageoptions', 'post-twitter');
	$data .= !empty($twitter) ? '<li class="twitter"><a title="'.esc_html__('Twitter', 'painting').'" target="_blank" href="//twitter.com/home/?status='.urlencode($title ) . ':'.$url.'"><i class="fa fa-twitter"></i></a></li>' : '';
	
	$googleplus = painting_option('pageoptions', 'post-googleplus');
	$data .= !empty($googleplus) ? '<li class="googleplus"><a title="'.esc_html__('GooglePlus', 'painting').'" target="_blank" href="//plus.google.com/share?url='.$url.'" onclick="javascript:window.open(this.href,\'\',\'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600\');return false;"><i class="fa fa-google-plus"></i></a></li>' : '';

	$linkedin = painting_option('pageoptions', 'post-linkedin');
	$data .= !empty($linkedin) ? '<li class="linkedin"><a title="'.esc_html__('LinkedIn', 'painting').'" target="_blank" href="//www.linkedin.com/shareArticle?mini=true&amp;title='.urlencode($title).'&amp;url='.$url.'"><i class="fa fa-linkedin"></i></a></li>' : '';

	$pinterest = painting_option('pageoptions', 'post-pinterest');
	$media = wp_get_attachment_url(get_post_thumbnail_id($post->ID));
	$data .= !empty($pinterest) ? '<li class="pinterest"><a title="'.esc_html__('Pinterest', 'painting').'" target="_blank" href="//pinterest.com/pin/create/button/?url='.urlencode($url).'&amp;media='.$media.'"><i class="fa fa-pinterest"></i></a></li>' : '';
	
	echo !empty($data) ? '<div class="dt-sc-share-post"><h3>'.esc_html__('Share this post', 'painting').'</h3><ul class="dt-sc-social-icons">'.$data.'</ul></div>' : '';

}
}
/* ---------------------------------------------------------------------------
 * Customizing comment form fields
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_customize_comment_fields')) {
function painting_customize_comment_fields( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
}
add_filter( 'comment_form_fields', 'painting_customize_comment_fields' );

/* ---------------------------------------------------------------------------
 * Get Header Type
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_header_type')) {
function painting_get_header_type() {
	
	global $dttemplate_general_settings, $dtenable_general_settings;
	
	if($dtenable_general_settings) $headertype = $dttemplate_general_settings['header-type'];
	elseif(painting_option('layout','header-type') != '') $headertype = painting_option('layout','header-type');
	else $headertype = 'default';

	return $headertype;
	
}
}

/* ---------------------------------------------------------------------------
 * Enable / Disable Top Bar
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_enabledisable_topbar')) {
function painting_enabledisable_topbar() {
	
	global $dttemplate_general_settings, $dtenable_general_settings;
	
	if($dtenable_general_settings) { $enable_topbar = (isset($dttemplate_general_settings['enable-topbar']) && $dttemplate_general_settings['enable-topbar'] != '') ? 'true' : 'false'; }
	elseif(painting_option('layout','enable-topbar') != '') { $enable_topbar = (painting_option('layout','enable-topbar') != '') ? 'true' : 'false'; }
	else { $enable_topbar = ''; }

	return $enable_topbar;
}	
}

/* ---------------------------------------------------------------------------
 * Get Header Left Content
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_header_left_content')) {
function painting_get_header_left_content() {
	
	global $dttemplate_general_settings, $dtenable_general_settings;
	
	if($dtenable_general_settings) {
		$header_leftcontent = array_key_exists('header-leftcontent', $dttemplate_general_settings) ? $dttemplate_general_settings['header-leftcontent'] : '';
	} else {
		$header_leftcontent = painting_option('layout','header-leftcontent');
	}

	return $header_leftcontent;
	
}
}

/* ---------------------------------------------------------------------------
 * Get Header Right Content
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_header_right_content')) {
function painting_get_header_right_content() {
	
	global $dttemplate_general_settings, $dtenable_general_settings;
	
	if($dtenable_general_settings) {
		$header_rightcontent = array_key_exists('header-rightcontent', $dttemplate_general_settings) ? $dttemplate_general_settings['header-rightcontent'] : '';
	} else {
		$header_rightcontent = painting_option('layout','header-rightcontent');
	}

	return $header_rightcontent;
}	
}

/* ---------------------------------------------------------------------------
 * Archive pages post navigations
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_post_navigation')) {
function painting_post_navigation() {
	
	$post_max_num_pages = $GLOBALS['wp_query']->max_num_pages;
	
	if ( $post_max_num_pages < 2 ) {
		return;
	}
	
	if(painting_option('general','pagination-position') != '') { $pagination_position = painting_option('general','pagination-position'); }
	else { $pagination_position = 'text-alignright'; }
	
	echo '<div class="pagination '.painting_get_pagination_position().'">';
		$pages = ($post_max_num_pages) ? $post_max_num_pages : 1;
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		if($paged > 1) { echo '<div class="prev-post"><a href="'.get_pagenum_link($paged - 1).'"><span class="fa fa-caret-left"></span>&nbsp;'.esc_html__('Prev', 'painting').'</a></div>'; }
		echo paginate_links( array(
									'base' => add_query_arg('paged','%#%'),
									'format' => '',
									'current' => $paged,
									'type' => 'list',
									'end_size' => 2,
									'mid_size' => 3,
									'prev_next' => false,
									'total' => $post_max_num_pages 
								)
							);
		if($paged < $pages) { echo '<div class="next-post"><a href="'.get_pagenum_link($paged + 1).'">'.esc_html__('Next', 'painting').'&nbsp;<span class="fa fa-caret-right"></span></a></div>'; }
	echo '</div>';
	
}
}
/* ---------------------------------------------------------------------------
 * Custom body classes
 * --------------------------------------------------------------------------- */
add_filter( 'body_class', 'painting_body_class_names' );
if (!function_exists('painting_body_class_names')) {
function painting_body_class_names($classes) {
	
	$layout_opts = (painting_option('layout') != '') ? painting_option('layout') : array();
	$site_layout =  array_key_exists('site-layout', $layout_opts) ? $layout_opts['site-layout'] : ''; 
	
	$classes[]  = ($site_layout === 'boxed') ? 'boxed' : ''; 
	
	if(is_page()) {
		global $post;
		$settings = get_post_meta( $post->ID, '_tpl_default_settings', TRUE );
		$settings = is_array($settings) ? $settings : array();
		if(array_key_exists('show_slider', $settings) && array_key_exists('transparent-menu', $settings)) {
			$classes[] = 'dt-transparent-menu';
		}
	}
	
	$headertype = painting_get_header_type();
	$classes[] = 'dt-transparent-'.$headertype;
	
	return $classes;
}	
}

/* ---------------------------------------------------------------------------
 * Get pagination position
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_get_pagination_position')) {
function painting_get_pagination_position() {
	if(painting_option('general','pagination-position') != '') { $pagination_position = painting_option('general','pagination-position'); }
	else { $pagination_position = 'text-alignright'; }
	return $pagination_position;
}
}

?>