<?php 
/**
 * Theme Functions
 *
 * @package BTtheme
 * @author BuddhaThemes
 * @link http://wedesignthemes.com
 */

define( 'PAINTING_DIR', get_template_directory() );
define( 'PAINTING_URI', get_template_directory_uri() );
define( 'PAINTING_CORE_PLUGIN', WP_PLUGIN_DIR.'/buddhathemes-core-features' );
define( 'PAINTING_CORE_PLUGIN_URI', WP_PLUGIN_URL.'/buddhathemes-core-features' );

define( 'PAINTING_SETTINGS', 'painting-options' );

if (function_exists ( 'wp_get_theme' )) :
	$themeData = wp_get_theme ();
	define( 'PAINTING_NAME', $themeData->get ( 'Name' ) );
	define( 'PAINTING_VERSION', $themeData->get ( 'Version' ) );
endif;

define( 'PAINTING_LANG_DIR', PAINTING_DIR. '/languages' );


/* ---------------------------------------------------------------------------
 * Loads Theme Textdomain
 * --------------------------------------------------------------------------- */
load_theme_textdomain( 'painting', PAINTING_LANG_DIR );

/* ---------------------------------------------------------------------------
 * Loads the Admin Panel Scripts
 * --------------------------------------------------------------------------- */
function painting_admin_scripts() {

	wp_enqueue_style('dttheme-admin', PAINTING_URI .'/framework/theme-options/style.css');
	wp_enqueue_style('dttheme-chosen', PAINTING_URI .'/framework/theme-options/css/chosen.css');
	wp_enqueue_style('wp-color-picker');

	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('wp-color-picker');

	wp_enqueue_script('dttheme-tooltip', PAINTING_URI . '/framework/theme-options/js/jquery.tools.min.js');
	wp_enqueue_script('dttheme-chosen', PAINTING_URI . '/framework/theme-options/js/chosen.jquery.min.js');
	wp_enqueue_script('dttheme-custom', PAINTING_URI . '/framework/theme-options/js/dttheme.admin.js');
	wp_enqueue_media();

	wp_localize_script('dttheme-custom', 'objectL10n', array(
		'saveall' => esc_html__('Save All', 'painting'),
		'saving' => esc_html__('Saving ...', 'painting'),
		'noResult' => esc_html__('No Results Found!', 'painting'),
		'resetConfirm' => esc_html__('This will restore all of your options to default. Are you sure?', 'painting'),
		'importConfirm' => esc_html__('You are going to import the dummy data provided with the theme, kindly confirm?', 'painting'),
		'backupMsg' => esc_html__('Click OK to backup your current saved options.', 'painting'),
		'backupSuccess' => esc_html__('Your options are backuped successfully', 'painting'),
		'backupFailure' => esc_html__('Backup Process not working', 'painting'),
		'disableImportMsg' => esc_html__('Importing is disabled.. :), Please select atleast import type','painting'),
		'restoreMsg' => esc_html__('Warning: All of your current options will be replaced with the data from your last backup! Proceed?', 'painting'),
		'restoreSuccess' => esc_html__('Your options are restored from previous backup successfully', 'painting'),
		'restoreFailure' => esc_html__('Restore Process not working', 'painting'),
		'importMsg' => esc_html__('Click ok import options from the above textarea', 'painting'),
		'importSuccess' => esc_html__('Your options are imported successfully', 'painting'),
		'importFailure' => esc_html__('Import Process not working', 'painting')));
		
}
add_action( 'admin_enqueue_scripts', 'painting_admin_scripts' );

/* ---------------------------------------------------------------------------
 * Loads the Options Panel
 * --------------------------------------------------------------------------- */
require_once( PAINTING_DIR .'/framework/utils.php' );
require_once( PAINTING_DIR .'/framework/fonts.php' );
require_once( PAINTING_DIR .'/framework/theme-options/init.php' );

/* ---------------------------------------------------------------------------
 * Loads Theme Functions
 * --------------------------------------------------------------------------- */

// Functions --------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/register-functions.php' );

// Header -----------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/register-head.php' );
require_once( PAINTING_DIR .'/framework/register-colorsnfonts.php' );


// Meta box ---------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/theme-metaboxes/post-metabox.php' );
require_once( PAINTING_DIR .'/framework/theme-metaboxes/page-metabox.php' );

// Menu -------------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/register-menu.php' );
require_once( PAINTING_DIR .'/framework/register-mega-menu.php' );

// Hooks ------------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/register-hooks.php' );

// Widgets ----------------------------------------------------------------------
require_once( PAINTING_DIR .'/framework/register-widgets.php' );

// Plugins ---------------------------------------------------------------------- 
require_once( PAINTING_DIR .'/framework/register-plugins.php' );

// Privacy ---------------------------------------------------------------------- 
require_once( PAINTING_DIR .'/framework/register-privacy.php' );

// Mailchimp Utils --------------------------------------------------------------------
if ( function_exists ('is_plugin_active') ) 
{
require_once(PAINTING_CORE_PLUGIN.'/apis/mailchimp/mailchimp.php' );
}
// WooCommerce Functions
if( function_exists( 'is_woocommerce' ) ){
	require_once( PAINTING_DIR .'/framework/register-woocommerce.php' );
}

$GLOBALS['force_enable'] = painting_option('general', 'force-enable-global-layout');
$GLOBALS['page_layout'] = painting_option('general', 'global-page-layout');
?>