<?php
/**
 * Pagination - Show numbered pagination for catalog pages.
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version    3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wp_query = painting_get_global_variables('wp_query'); 

if ( $wp_query->max_num_pages <= 1 ) {
	return;
}
?>
<div class="pagination <?php echo painting_get_pagination_position(); ?>">
	<?php
    $pages = ($wp_query->max_num_pages) ? $wp_query->max_num_pages : 1;
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    if($paged > 1) echo '<div class="prev-post"><a href="'.get_pagenum_link($paged - 1).'"><span class="fa fa-caret-left"></span>&nbsp;'.esc_html__('Prev', 'painting').'</a></div>';
	echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
		'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
		'format'       => '',
		'add_args'     => '',
		'current'      => max( 1, get_query_var( 'paged' ) ),
		'total'        => $wp_query->max_num_pages,
		'prev_next'    => false,
		'type'         => 'list',
		'end_size'     => 3,
		'mid_size'     => 3
	) ) );
    if ($paged < $pages) echo '<div class="next-post"><a href="'.get_pagenum_link($paged + 1).'">'.esc_html__('Next', 'painting').'&nbsp;<span class="fa fa-caret-right"></span></a></div>';
	?>
</div>