<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$product = painting_get_global_variables('product'); 
$woocommerce_loop = painting_get_global_variables('woocommerce_loop'); 

if ( empty( $product ) || ! $product->exists() ) {
	return;
}

if ( $related_products ) : ?>

	<div class="dt-sc-margin30"></div>

	<div class="related products">

        <div class="hr-title dt-sc-hr-invisible-small">
            <h3><?php esc_html_e( 'Related Products', 'painting' ) ?></h3>
            <div class="title-sep-container"><div class="title-sep"> </div></div>
        </div>

		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $related_products as $related_product ) : ?>

				<?php
				 	$post_object = get_post( $related_product->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );

					wc_get_template_part( 'content', 'product' ); ?>

			<?php endforeach; ?>

		<?php woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_postdata();