<?php
if ( !class_exists( 'DTCustomerPostType' ) ) {

	class DTCustomerPostType {

		function __construct() {
			add_action ( 'init', array (
				$this,
				'dt_init'
			) );

			add_action( 'admin_init', array(
				$this,
				'dt_admin_init'
			) );
		}

		function dt_init() {
			$labels = array(
				'name' => esc_html__('Customers', 'dt_plugins_appointment' ),
				'singular_name' => esc_html__('Customer', 'dt_plugins_appointment' ),
				'menu_name' => esc_html__('Customers', 'dt_plugins_appointment' ),
				'add_new' => esc_html__('Add Customer', 'dt_plugins_appointment' ),
				'add_new_item' => esc_html__('Add New Customer', 'dt_plugins_appointment' ),
				'edit' => esc_html__('Edit Customer', 'dt_plugins_appointment' ),
				'edit_item' => esc_html__('Edit Customer', 'dt_plugins_appointment' ),
				'new_item' => esc_html__('New Customer', 'dt_plugins_appointment' ),
				'view' => esc_html__('View Customer', 'dt_plugins_appointment' ),
				'view_item' => esc_html__('View Customer', 'dt_plugins_appointment' ),
				'search_items' => esc_html__('Search Customers', 'dt_plugins_appointment' ),
				'not_found' => esc_html__('No Customers found', 'dt_plugins_appointment' ),
				'not_found_in_trash' => esc_html__('No Customers found in Trash', 'dt_plugins_appointment' ),
				'parent_item_colon' => esc_html__('Parent Customer:', 'dt_plugins_appointment' ),
			);

			$args = array(
				'labels' => $labels,
				'hierarchical' => false,
				'description' => esc_html__('This is Custom Post type named as Customers','dt_plugins_appointment'),
				'supports' => array('title'),
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'menu_position' => 31,
				'menu_icon' => 'dashicons-groups',
			);

			register_post_type('dt_customers', $args );
		}

		function dt_admin_init() {
			add_action ( 'add_meta_boxes', array (
				$this,
				'dt_add_customer_meta_box' 
			) );

			add_action ( 'save_post', array (
				$this,
				'save_customer_post_meta' 
			) );
			
			add_action ( 'pre_post_update', array (
				$this,
				'save_customer_post_meta' 
			) );
		}

		function dt_add_customer_meta_box() {

			add_meta_box( 'dt-member-metabox', esc_html__('Set Personal Information','dt_plugins_appointment'),
				array( $this, 'dt_customer_metabox'), 'dt_customers', 'normal',  'default');
		}

		function dt_customer_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_customer_metabox.php';
		}

		function save_customer_post_meta( $post_id ) {

			if ( ! isset( $_POST['dtappointment_addon_customer_metabox_nonce'] ) || ! isset( $_POST['dtappointment_addon_customer_metabox_nonce'] ) ) {
				return;
			}
		
			if ( ! wp_verify_nonce( $_POST['dtappointment_addon_customer_metabox_nonce'], 'dtappointment_addon_customer_metabox' ) || ! wp_verify_nonce( $_POST['dtappointment_addon_customer_metabox_nonce'], 'dtappointment_addon_customer_metabox' ) ) {
				return;
			}
		
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
		
			if ( isset( $_POST['post_type'] ) && 'dt_customers' == $_POST['post_type'] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			if ( (key_exists('post_type', $_POST)) && ('dt_customers' == $_POST['post_type']) ) :
			
				if ( isset($_POST['_info']) ):
					$info = painting_wp_kses(array_unique(array_filter($_POST['_info'])));
					update_post_meta ( $post_id, "_info", array_filter ( $info ) );
				endif;
			
			endif;
			
		}
	}
}?>
